//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "SplashPage.h"
#include <winreg.h>
#include <dir.h>
#include "sword.h"

USEFORM("..\..\CBuilder5\BibleCS\AboutBoxfrm.cpp", AboutBox);
USEFORM("..\..\CBuilder5\BibleCS\bookmarkfrm.cpp", Bookmarksfrm);
USEFORM("..\..\CBuilder5\BibleCS\DevOfTheDay.cpp", DevOfTheDay2);
USEFORM("..\..\CBuilder5\BibleCS\editentryfrm.cpp", EditEntry);
USEFORM("..\..\CBuilder5\BibleCS\FontSel.cpp", FontSelFrm);
USEFORM("..\..\CBuilder5\BibleCS\mainfrm.cpp", Form1);
USEFORM("..\..\CBuilder5\BibleCS\ModInstForm.cpp", ModInstFrm);
USEFORM("..\..\CBuilder5\BibleCS\ModVisFrm.cpp", ModVisForm);
USEFORM("..\..\CBuilder5\BibleCS\newbmfilefrm.cpp", NewBMfrm);
USEFORM("..\..\CBuilder5\BibleCS\optionfrm.cpp", Optionsfrm);
USEFORM("..\..\CBuilder5\BibleCS\RangeMaintFrm.cpp", RangeMaintForm);
USEFORM("..\..\CBuilder5\BibleCS\searchfrm.cpp", Form2);
USEFORM("..\..\CBuilder5\BibleCS\splashfrm.cpp", splashForm);
USEFORM("..\..\CBuilder5\BibleCS\SplashPage.cpp", SplashPg);
USEFORM("..\..\CBuilder5\BibleCS\StudyProfessor.cpp", Form3);
USEFORM("..\..\CBuilder5\BibleCS\versesel.cpp", VerseSelFrm);
USEFORM("..\..\CBuilder5\BibleCS\vrslstfrm.cpp", VerseListFrm);
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {

        LONG result;

        result = Application->ExeName.Length();
        char * dir = new char[result + 1];
        strcpy (dir, Application->ExeName.c_str());
        for (;result > 0 && dir[result] != '\\'; result--) {
                dir[result] = 0;
        }
        chdir(dir);
        delete [] dir;

        try {
                HKEY hkey;
                HWND otherInst;

                // see if there's a previous instance running
                otherInst = ::FindWindow(NULL, "The SWORD Project for Windows");
                // if so, and we have an argument, send the argument to the other instance
                if (otherInst && *lpCmdLine) {
                        result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "sword\\OpenVerse", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                        result = RegSetValueEx(hkey, NULL, 0, REG_SZ, lpCmdLine, strlen(lpCmdLine) + 1);
                        result = RegCloseKey(hkey);

                        PostMessage(otherInst, WM_VERSE, NULL, NULL);
                        return 0;
                }

                // adjust the registry for our private protocol using the current path
                result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "sword", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                result = RegSetValueEx(hkey, NULL, 0, REG_SZ, "URL:SWORD Protocol", strlen("URL:SWORD Protocol") + 1);
                result = RegSetValueEx(hkey, "URL Protocol", 0, REG_SZ, "", 1);
                result = RegCloseKey(hkey);
                result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "sword\\DefaultIcon", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                result = RegSetValueEx(hkey, NULL, 0, REG_SZ, Application->ExeName.c_str(), Application->ExeName.Length() + 1);
                result = RegCloseKey(hkey);
                AnsiString opencommand = Application->ExeName + " \"%1\"";
                result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "sword\\shell\\open\\command", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                result = RegSetValueEx(hkey, NULL, 0, REG_SZ, opencommand.c_str(), opencommand.Length() + 1);
                result = RegCloseKey(hkey);


		/*
                // don't override Logos' setting if it exists
                result = RegOpenKeyEx(HKEY_CLASSES_ROOT, "libronixdls", 0, KEY_READ | KEY_WRITE, &hkey);
                if (!result) {
                        char* libStr = new char[32];
                        unsigned long libSize = 32;
                        result = RegQueryValueEx(hkey, NULL, NULL, NULL, libStr, &libSize);
                        if (!result) {
                                if (strstr(libStr, "SWORD")) {
                                        result = 1;
                                }
                        }
                }
                if (result) {
                        result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "libronixdls", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                        result = RegSetValueEx(hkey, NULL, 0, REG_SZ, "URL:SWORD Protocol", strlen("URL:SWORD Protocol") + 1);
                        result = RegSetValueEx(hkey, "URL Protocol", 0, REG_SZ, "", 1);
                        result = RegCloseKey(hkey);
                        result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "libronixdls\\DefaultIcon", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                        result = RegSetValueEx(hkey, NULL, 0, REG_SZ, Application->ExeName.c_str(), Application->ExeName.Length() + 1);
                        result = RegCloseKey(hkey);
                        AnsiString opencommand = Application->ExeName + " \"%1\"";
                        result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "libronixdls\\shell\\open\\command", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
                        result = RegSetValueEx(hkey, NULL, 0, REG_SZ, opencommand.c_str(), opencommand.Length() + 1);
                        result = RegCloseKey(hkey);
                }
		*/
        }
	catch (Exception &exception) {
		Application->ShowException(&exception);
	}

	try {
		Application->Initialize();
		Application->Title = "The SWORD Project";
		Application->CreateForm(__classid(TAboutBox), &AboutBox);
		Application->CreateForm(__classid(TBookmarksfrm), &Bookmarksfrm);
		Application->CreateForm(__classid(TDevOfTheDay2), &DevOfTheDay2);
		Application->CreateForm(__classid(TEditEntry), &EditEntry);
		Application->CreateForm(__classid(TFontSelFrm), &FontSelFrm);
		Application->CreateForm(__classid(TForm1), &Form1);
		Application->CreateForm(__classid(TModInstFrm), &ModInstFrm);
		Application->CreateForm(__classid(TModVisForm), &ModVisForm);
		Application->CreateForm(__classid(TNewBMfrm), &NewBMfrm);
		Application->CreateForm(__classid(TOptionsfrm), &Optionsfrm);
		Application->CreateForm(__classid(TRangeMaintForm), &RangeMaintForm);
		Application->CreateForm(__classid(TForm2), &Form2);
		Application->CreateForm(__classid(TsplashForm), &splashForm);
		Application->CreateForm(__classid(TSplashPg), &SplashPg);
		Application->CreateForm(__classid(TForm3), &Form3);
		Application->CreateForm(__classid(TVerseSelFrm), &VerseSelFrm);
		Application->CreateForm(__classid(TVerseListFrm), &VerseListFrm);
		SplashPg = new TSplashPg(static_cast<void*>(NULL));
		SplashPg->Show();
		Application->ProcessMessages();
		Application->Run();
		delete SplashPg;
	}
	catch (Exception &exception) {
		Application->ShowException(&exception);
	}
	return 0;
}
//---------------------------------------------------------------------------




