//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "swdisprtf.h"
#include <unicodertf.h>



//---------------------------------------------------------------------------
__fastcall SWDispRTF::SWDispRTF(TWinControl *Owner)
	: TRxRichEditX(Owner) {
	RTFStream = new TMemoryStream();
	
	ExpandNewLine = true;
	this->AutoURLDetect = true;	 
}

__fastcall SWDispRTF::~SWDispRTF()
{
	if (RTFStream)
		delete RTFStream;
}


void __fastcall SWDispRTF::Loaded(void)
{
	TRxRichEditX::Loaded();
}


int __fastcall SWDispRTF::GetMySelStart() {
	CHARRANGE cr;
	
	SendMessage(Handle, EM_EXGETSEL, 0, (long)&cr);
	return cr.cpMin;
}


void __fastcall SWDispRTF::SetMySelStart(int iselstart) {
	CHARRANGE cr;
	
	cr.cpMin = iselstart;
	cr.cpMax = iselstart;
	SendMessage(Handle, EM_EXSETSEL, 0, (long)&cr);
}

// Display for Comm and LD
char SWDispRTF::Display(SWModule &Module) {
	System::AnsiString newtext, tmptext;
	static UnicodeRTF filter;
	char buf[255];

	module = &Module;
	type = "Default";

	recalcAppearance();
	
	newtext = RTFHeader;
	newtext = newtext + RTFHeadMargin;
	Module.Error(); // clear error;
	newtext = newtext + "\\pard \\nowidctlpar \\cf7\\f0 ";
	(const char *)Module;	// force key to snap to entry before pulling out the text of the key
	strcpy(buf, Module.KeyText());
	SWKey *key = Module;

	// VerseKey locales are not yet UTF8, so don't try to convert them.
	if (!SWDYNAMIC_CAST(VerseKey, key))
		filter.ProcessText(buf, 253, Module, &Module);

	newtext = newtext + RTFHeadingPre + buf + RTFHeadingPost + ":{\\par}";
	tmptext = "";

	tmptext = (const char *)Module;
	
	newtext = newtext + RTFVersePre + tmptext + RTFVersePost;
	newtext = newtext + RTFTrailer;
	RTFStream->Clear();
	RTFStream->WriteBuffer(newtext.c_str(), newtext.Length());
	RTFStream->Position = 0;
	Lines->LoadFromStream(RTFStream);

	// make links
	while (true) {
		int start, len, foundAt, endAt;

		start = (SelLength) ? SelStart + SelLength : 0;
		len = Text.Length() - start;
		foundAt = this->SearchText("<a href=\"\">", start, len, TRichSearchTypes());
		if (foundAt == -1)
			break;

		SelStart = foundAt;
		SelLength = 11;
		this->SelText = "";
		endAt = this->SearchText("</a>", foundAt, len, TRichSearchTypes());
		if (foundAt == -1)
			break;
		SelStart = endAt;
		SelLength = 4;
		this->SelText = "";
		SelStart = foundAt;
		SelLength = endAt - foundAt;
		this->SelAttributes->Link = true;
	}
	//{ Position control text at current verse }
	SelStart = 0;
/*
	if (Visible) {
		TComponent *owner = this->Owner;
		TForm *parentForm = dynamic_cast<TForm *>(owner);
		TWinControl *focus = 0;
		
		if (parentForm)
			focus = parentForm->ActiveControl;
		this->SetFocus();
		SelStart = 0;
		SelLength = 0;
		SendMessage(Handle, EM_SCROLLCARET, 0, 0);
		if (focus)
			focus->SetFocus();
	}
*/
	SelLength = 0;
	SendMessage(Handle, EM_SCROLLCARET, 0, 0);

	return 0;
}

//---------------------------------------------------------------------------


