#ifndef TRxRichEditX_
#define TRxRichEditX_

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <RxRichEdit.hpp>
#include <ExtCtrls.hpp>
#include <swmodule.h>
#include <listkey.h>

using namespace sword;
/*
struct RTF_FORMAT {
	AnsiString fontFace; 	// Font Name
	int chFontHeadSize;		// Chapter Name Heading Size
	int bkFontHeadSize; 	// Book Name Heading Size
	int bodyFontSize;		// Body Font Size
	int vsNumFontSize;		// VerseNumbering or Pre/Post-Fix Size
	bool prChHeadings;		// Print Heading
	bool prBookHeadings;	// Print Book Name
	bool prPreFix;			// Print Verse Prefix (James 1:19 KJV)
	bool prPostFix;		// Print Verse Postfix
	bool prVerseNum;		// Print Verse Number
	bool paragraph;		// Print Bible Text as a paragraph rather than seperate lines
	bool superVSNum;		// Verse Numbers superscripted
};
*/
struct DISP_ATTRIBS {
	// ** Type Dependant means that each text type (Bible, Commentary, etc.) has it's own setting ** //
	// Font name and size
	AnsiString fontName;	// Font Name (Type Dependant)
	int fontSize;			// Font Size (Type Dependant)
	int chFontHeadSize;		// Chapter Name Heading Size (Type Dependant)
	int vsNumFontSize;		// VerseNumbering or Pre/Post-Fix Size (Type Dependant)
	// Font Colors
	int backColor;			// Background Color (Type Dependant)
	int fontColor;			// Foreground Color (Type Dependant)
	int entryKeyColor;		// Verse Number Color (Should be type dependant but isn't yet)
	int currentVSColor;		// Current Verse Color
	int morphColor;		// MorphTags Color
	int strongsColor;		// Strongs Tags Color
	int lookupFieldColor;	// Lookup Key Fields color
	// Options
	bool markCurrentVerse;	// whether or not to mark current verse
	bool prChHeadings;		// Print Heading (Type Dependant)
	bool prBookHeadings;	// Print Book Name (Type Dependant)
	bool prPreFix;			// Print Verse Prefix (James 1:19 KJV) (Type Dependant)
	bool prPostFix;		// Print Verse Postfix (Type Dependant)
	bool prVerseNum;		// Print Verse Number  (Type Dependant)
	bool superVSNum;		// Verse Numbers superscripted (Type Dependant)
	bool paragraph;		// Print Bible Text as a paragraph rather than seperate lines (Type Dependant)
};

/*
typedef struct {
	TCharRange chrg;
	PWideChar lpstrText;
} TTextRangeW;

*/
class TRxRichEditX : public TRxRichEdit {
private:
	AnsiString GetFormattedText(SWModule* module);
	AnsiString ChapterHeading(SWModule* module, int nChapter);
	AnsiString BookHeading(SWModule* module, AnsiString name);
	AnsiString PrintEntry(SWModule* module, int nVerse);
	AnsiString PrintFix(SWModule* module);
	//RTF_FORMAT format_ops;
	void buildRTFHeader();
	void clearHTMLTags();

public:
	static char platformID;
	static void TColorToRGB(const TColor& color, int& red, int& green, int& blue);
	// The following RTF variables are used to simplify streaming rtf formatting
	// be sure to call recalcAppearance() so that these variables are set according 
	// to the module type being rendered.

	// RTFHeader: use to open a new RTF stream with font and color tables defined here. 
	AnsiString RTFHeader;
	//RTFHeadMargin: Use to place a margin above the Heading.
	AnsiString RTFHeadMargin;
	// RTFTrailer: Use to close your rtf stream.
	AnsiString RTFTrailer;
	// RTFChapterMarkPre: Use to begin a new chapter heading. Includes the text "Chapter "
	AnsiString RTFChapterMarkPre;
	// RTFChapterMarkPost: Use to close your chapter heading.
	AnsiString RTFChapterMarkPost;
	// RTFHeadingPre: Use to begin a mini-heading such as for pop-up windows 
	AnsiString RTFHeadingPre;
	// RTFHeadingPost: Closes the mini-heading
	AnsiString RTFHeadingPost;
	// RTFVerseMarkPre: Use to begin a verse number
	AnsiString RTFVerseMarkPre;
	// RTFVerseMarkPost: Use to close a verse number
	AnsiString RTFVerseMarkPost;
	// RTFVersePre: Use to begin the actual text of a verse
	AnsiString RTFVersePre;
	// RTFVersePost: Use to close the actual text of a verse
	AnsiString RTFVersePost;
	DISP_ATTRIBS dispAttribs;

	TRxRichEditX(TWinControl *parent);
	int paintTo(HDC, TRect *size, int margin = 4);
	bool fillWithVerses(SWModule *module, ListKey *verses, const char *introText = 0, bool heading = true, bool verseNum = true, const char* type = "Default", bool stripNewlines = true);
	void fillWithRTFString(SWModule *module, const char *text, const char *type = "Default");
	void getDisplayPrefs(DISP_ATTRIBS *attribs, SWModule *module);
	void drawTo(HDC dc) { PaintControls(dc, 0); }
	void RenderModule(SWModule* module);
	SWModule *module;
	AnsiString type;
	void recalcAppearance();
	void makeLinks();
	void makeImages();
	void insertImage(const char *filePath);
	SWBuf bitmapToRTF(Graphics::TBitmap *pict);
	void insertRTF(const char *rtf);
	AnsiString getType();
	static WideString Trim(WideString &src);
	WideString __fastcall GetText();
	long __fastcall TextLen();
	WideString __fastcall GetSelTextWide() {return GetTextRange(SelStart, SelStart + SelLength); }
	__property WideString SelTextWide = {read=GetSelTextWide};
	WideString __fastcall GetTextRange(int StartPos, int EndPos);
	WideString __fastcall WordAtCursor(void);
};

#endif  // TRxRichEditX_
