unit TntComCtrls_Design;

interface

uses
  {$IFDEF VER130} DsgnIntf, Menus, {$ELSE} DesignIntf, DesignMenus, DesignEditors, {$ENDIF}
  Classes, ComCtrls;

type
{$IFDEF VER130}
  IPrepareMenuItem = TMenuItem{TNT-ALLOW TMenuItem};
{$ELSE}
  IPrepareMenuItem = IMenuItem;
{$ENDIF}

  TTntListViewEditor = class(TComponentEditor)
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string{TNT-ALLOW string}; override;
    function GetVerbCount: Integer; override;
  end;

  TTntPageControlEditor = class(TDefaultEditor)
  private
    function PageControl: TPageControl{TNT-ALLOW TPageControl};
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string{TNT-ALLOW string}; override;
    function GetVerbCount: Integer; override;
    procedure PrepareItem(Index: Integer; const AItem: IPrepareMenuItem); override;
  end;

procedure Register;

implementation

uses {$IFNDEF VER130} DsnConst, {$ENDIF} TntComCtrls, TntDesignEditors_Design;

procedure Register;
begin
  RegisterComponentEditor(TTntListView, TTntListViewEditor);
  RegisterComponentEditor(TTntPageControl, TTntPageControlEditor);
  RegisterComponentEditor(TTntTabSheet, TTntPageControlEditor);
end;

{ TTntListViewEditor }

function TTntListViewEditor.GetVerbCount: Integer;
begin
  Result := 2;
end;

{$IFDEF VER130}
resourcestring
  SListColumnsEditor = 'Columns Editor...';
  SListItemsEditor = 'Items Editor...';
{$ENDIF}

function TTntListViewEditor.GetVerb(Index: Integer): string{TNT-ALLOW string};
begin
  case Index of
    0: Result := SListColumnsEditor;
    1: Result := SListItemsEditor;
  end;
end;

procedure TTntListViewEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0: EditPropertyWithDialog(Component, 'Columns', Designer);
    1: EditPropertyWithDialog(Component, 'Items', Designer);
  end;
end;

{ TTntPageControlEditor }

function TTntPageControlEditor.PageControl: TPageControl{TNT-ALLOW TPageControl};
begin
  if Component is TTabSheet{TNT-ALLOW TTabSheet} then
    Result := TTabSheet{TNT-ALLOW TTabSheet}(Component).PageControl
  else
    Result := Component as TPageControl{TNT-ALLOW TPageControl};
end;

function TTntPageControlEditor.GetVerbCount: Integer;
begin
  Result := 4;
end;

{$IFDEF VER130}
resourcestring
  SNewPage = 'New Page';
  SNextPage = 'Next Page';
  SPrevPage = 'Previous Page';
  SDeletePage = 'Delete Page';
{$ENDIF}

function TTntPageControlEditor.GetVerb(Index: Integer): string{TNT-ALLOW string};
begin
  case Index of
    0: Result := SNewPage;
    1: Result := SNextPage;
    2: Result := SPrevPage;
    3: Result := SDeletePage;
  end;
end;

procedure TTntPageControlEditor.PrepareItem(Index: Integer; const AItem: IPrepareMenuItem);
begin
  AItem.Enabled := (Index <> 3) or (PageControl.PageCount > 0);
end;

type TAccessPageControl = class(TPageControl{TNT-ALLOW TPageControl});

procedure TTntPageControlEditor.ExecuteVerb(Index: Integer);

  procedure CreateNewTabSheet;
  var
    NewTabsheet: TTntTabSheet;
  begin
    NewTabSheet := TTntTabSheet.Create(PageControl.Owner);
      NewTabSheet.PageControl := Self.PageControl;
    with NewTabSheet do begin
      Name := Designer.UniqueName(ClassName);
      Caption := Name;
      Visible := True;
    end;
    PageControl.ActivePage := NewTabSheet;
  end;

  {$IFDEF VER130}
  procedure SelectNextPage(GoForward: Boolean);
  var
    Page: TTabSheet{TNT-ALLOW TTabSheet};
  begin
    with TAccessPageControl(PageControl) do begin
      Page := FindNextPage(ActivePage, GoForward, False);
      if (Page <> nil) and (Page <> ActivePage) and CanChange then
      begin
        ActivePage := Page;
        Change;
      end;
    end;
  end;
  {$ELSE}
  procedure SelectNextPage(GoForward: Boolean);
  begin
    PageControl.SelectNextPage(GoForward, False);
  end;
  {$ENDIF}

begin
  case Index of
    0: CreateNewTabSheet;
    1: SelectNextPage(True);
    2: SelectNextPage(False);
    3: if PageControl.ActivePage <> nil then
         PageControl.ActivePage.Free;
  end;
end;

end.
