//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "vrslstfrm.h"
#include "rtfhintfrm.h"
#include "PrintFrm.h"
#include <io.h>
#include <localemgr.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TVerseListForm *VerseListForm;
//---------------------------------------------------------------------------

//TODO:  add toolbar
//TODO:  add print to toolbar that will call up print form and populate print range
//TODO:  add const char *ListKey::rangeToString() to ListKey to allow easy implementation of above
//TODO:  add const char *VerseKey::rangeToString() to VerseKey to allow easy implementation of above
//TODO:  add save to toolbar
//TODO:  add add current verse to toolbar
//TODO:  add edit entry to toolbar
//TODO:  add new verse list to mainfrm
//TODO:  add open verse list to mainfrm

__fastcall TVerseListForm::TVerseListForm(TComponent* Owner, ListKey &iVerseList)
	: TForm(Owner), verseList(iVerseList) {
	pvrtf = new TRxRichEditX(this);

	pvrtf->Parent = plPreview;
	pvrtf->Align = alClient;
	pvrtf->ScrollBars = ssVertical;
	pvrtf->ReadOnly = true;
}
//---------------------------------------------------------------------------

void __fastcall TVerseListForm::ListBox1Click(TObject *Sender) {
	SWModule *target = 0;

	if (Form1->TextPageControl->ActivePage->Caption == "PARALLEL") {
		target = Form1->parallelDisp->getModules()[0];
	}
	else {
		ModMap::iterator it;
		it = Form1->mainmgr->Modules.find(Form1->TextPageControl->ActivePage->Caption.c_str());
		if (it != Form1->mainmgr->Modules.end())
			target = it->second;
	}
	if (target) {
		ListKey key;
		SWKey *tkey = target->CreateKey();
		*tkey = ListBox1->Items->Strings[ListBox1->ItemIndex].c_str();
		key << *tkey;
		delete tkey;
		pvrtf->fillWithVerses(target, &key, 0, true, false);
	}
}
//---------------------------------------------------------------------------

void __fastcall TVerseListForm::ListBox1DblClick(TObject *Sender)
{
	*(Form1->DefaultVSKey) = ListBox1->Items->Strings[ListBox1->ItemIndex].c_str();
	Form1->TextKeyChanged();
}
//---------------------------------------------------------------------------
void __fastcall TVerseListForm::FormShow(TObject *Sender)
{
	Caption = _tr("Verse List");
	SpeedButton1->Hint = _tr("Add Current Verse To List");
	SpeedButton2->Hint = _tr("Remove Highlighted Entry From List");
	SpeedButton3->Hint = _tr("Copy All Entries To Clipboard");
	SpeedButton4->Hint = _tr("Print All Entries");
	SpeedButton5->Hint = _tr("Save Verse List To File");
	SpeedButton6->Hint = _tr("Load Verse List From File");
	fillWithVerseList(verseList);
}
//---------------------------------------------------------------------------


void TVerseListForm::fillWithVerseList(ListKey &verseList) {



	ListBox1->Items->Clear();
	for (verseList = TOP; (!verseList.Error()); verseList++)
		ListBox1->Items->Add((const char *)verseList);
}


void __fastcall TVerseListForm::SpeedButton1Click(TObject *Sender)
{
	ListBox1->Items->Add((const char *)*(Form1->DefaultVSKey));
}
//---------------------------------------------------------------------------

void __fastcall TVerseListForm::SpeedButton2Click(TObject *Sender)
{
	int item = ListBox1->ItemIndex;
	if (item >=0) {
		ListBox1->Items->Delete(item);
	}	
}
//---------------------------------------------------------------------------

void __fastcall TVerseListForm::SpeedButton3Click(TObject *Sender)
{
	ListKey verses;
	for (int i = 0; i < ListBox1->Items->Count; i++) {
		verses << ListBox1->Items->Strings[i].c_str();
	}

	TPageControl *targetpc = Form1->TextPageControl;
	
	if ((Form1->ActiveControl == Form1->CommentaryPageControl) || (IsChild(Form1->CommentaryPageControl->Handle, Form1->ActiveControl->Handle)))
		targetpc = Form1->CommentaryPageControl;
	if ((Form1->ActiveControl == Form1->LexDictPageControl) || (IsChild(Form1->LexDictPageControl->Handle, Form1->ActiveControl->Handle)))
		targetpc = Form1->LexDictPageControl;

	SWModule *target = 0;

	if (targetpc->ActivePage->Caption == "PARALLEL") {
		target = Form1->parallelDisp->getModules()[0];
	}
	else {
		ModMap::iterator it;
		it = Form1->mainmgr->Modules.find(targetpc->ActivePage->Caption.c_str());
		if (it != Form1->mainmgr->Modules.end())
			target = it->second;
	}
	if (target) {
		RTFHintForm->rtfDrawer->fillWithVerses(target, &verses, 0, true, true);
		RTFHintForm->rtfDrawer->SelectAll();
		RTFHintForm->rtfDrawer->CopyToClipboard();
	}
}
//---------------------------------------------------------------------------

void __fastcall TVerseListForm::SpeedButton4Click(TObject *Sender)
{
	ListKey verses;
	for (int i = 0; i < ListBox1->Items->Count; i++) {
		verses << ListBox1->Items->Strings[i].c_str();
	}
	PrintForm->print(&verses);	
}
//---------------------------------------------------------------------------

void __fastcall TVerseListForm::SpeedButton5Click(TObject *Sender)
{
	int result = VLSaveDialog->Execute();
	SetCurrentDir(ExtractFilePath(Application->ExeName));
	if (result) {
		if (FileMgr::existsFile(VLSaveDialog->FileName.c_str())) {
			WideString message = _tr("File exists.  Overwrite?");
			WideString header = _tr("Overwrite File");
			if (MessageBoxW(Handle, message, header, MB_YESNO) != IDYES) {
				return;
			}
		}
		FileDesc *fd;
		unlink(VLSaveDialog->FileName.c_str());
		fd = FileMgr::systemFileMgr.open(VLSaveDialog->FileName.c_str(), O_CREAT|O_WRONLY|O_BINARY, S_IREAD|S_IWRITE);
		ListKey verses;
		for (int i = 0; i < ListBox1->Items->Count; i++) {
			VerseKey toEn;
			toEn = ListBox1->Items->Strings[i].c_str();
			toEn.getText();
			toEn.setLocale("en_us");
			verses << toEn.getText();
		}
		const char *rangeText = verses.getRangeText();
		write(fd->getFd(), rangeText, strlen(rangeText));
		FileMgr::systemFileMgr.close(fd);
	}
}
//---------------------------------------------------------------------------

void __fastcall TVerseListForm::SpeedButton6Click(TObject *Sender)
{
	int result = VLOpenDialog->Execute();
	SetCurrentDir(ExtractFilePath(Application->ExeName));
	if (result) {
		if (!FileMgr::existsFile(VLOpenDialog->FileName.c_str())) {
			return;
		}
		FileDesc *fd;
		fd = FileMgr::systemFileMgr.open(VLOpenDialog->FileName.c_str(), O_RDONLY|O_BINARY);
		ListKey verses;
		VerseKey parser;
		long size = lseek(fd->getFd(), 0, SEEK_END);
		lseek(fd->getFd(), 0, SEEK_SET);
		char *buf = new char[size+5];
		memset(buf, 0, size+5);
		read(fd->getFd(), buf, size);
		FileMgr::systemFileMgr.close(fd);
		verses = parser.ParseVerseList(buf, parser, false);
		fillWithVerseList(verses);
		delete [] buf;
	}
}
//---------------------------------------------------------------------------

