//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "RemoteMntFrm.h"
#include <installmgr.h>

using namespace std;

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TRemoteMntForm *RemoteMntForm;


class TRemoteSource : public TObject {
public:
	InstallSource is;
	TRemoteSource(const char *confEnt) : is("FTP", confEnt) {
	}
};


//---------------------------------------------------------------------------
__fastcall TRemoteMntForm::TRemoteMntForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TRemoteMntForm::FormShow(TObject *Sender)
{
	ConfigEntMap::iterator loop, end;
	config = new SWConfig("./installMgr/InstallMgr.conf");	
	ListBox1->Clear();
	loop = config->Sections["Sources"].lower_bound("FTPSource");
	end = config->Sections["Sources"].upper_bound("FTPSource");
	while (loop != end) {
		TRemoteSource *rs = new TRemoteSource(loop->second.c_str());
		ListBox1->Items->AddObject(rs->is.caption.c_str(), rs);
		loop++;
	}
	ListBox1->ItemIndex = 0;
	ListBox1Click(0);
	CheckBox1->Checked = (!stricmp((*config)["General"]["PassiveFTP"].c_str(), "true"));
	checkDisabled();
}


void TRemoteMntForm::checkDisabled() {
	bool enabled = ListBox1->Items->Count;
	NameEdit->Enabled = enabled;
	MachineEdit->Enabled = enabled;
	DirEdit->Enabled = enabled;
}


//---------------------------------------------------------------------------
void __fastcall TRemoteMntForm::FormClose(TObject *Sender,
	 TCloseAction &Action)
{
	delete config;	
}


void __fastcall TRemoteMntForm::SpeedButton4Click(TObject *Sender)
{
	ModalResult = mrCancel;	
}


void __fastcall TRemoteMntForm::ListBox1Click(TObject *Sender)
{
	if (ListBox1->ItemIndex >= 0) {
		TRemoteSource *rs = (TRemoteSource *)ListBox1->Items->Objects[ListBox1->ItemIndex];

		NameEdit->Text = rs->is.caption.c_str();
		MachineEdit->Text = rs->is.source.c_str();
		DirEdit->Text = rs->is.directory.c_str();
	}
	else {
		NameEdit->Text = "";
		MachineEdit->Text = "";
		DirEdit->Text = "";
	}
}


void __fastcall TRemoteMntForm::NameEditChange(TObject *Sender)
{
	if (ListBox1->ItemIndex < 0)
		return;
	TRemoteSource *rs = (TRemoteSource *)ListBox1->Items->Objects[ListBox1->ItemIndex];
	rs->is.caption = NameEdit->Text.c_str();
	ListBox1->Items->Strings[ListBox1->ItemIndex] = rs->is.caption.c_str();
}


void __fastcall TRemoteMntForm::MachineEditChange(TObject *Sender)
{
	if (ListBox1->ItemIndex < 0)
		return;
	TRemoteSource *rs = (TRemoteSource *)ListBox1->Items->Objects[ListBox1->ItemIndex];
	rs->is.source = MachineEdit->Text.c_str();
}


void __fastcall TRemoteMntForm::DirEditChange(TObject *Sender)
{
	if (ListBox1->ItemIndex < 0)
		return;
	TRemoteSource *rs = (TRemoteSource *)ListBox1->Items->Objects[ListBox1->ItemIndex];
	rs->is.directory = DirEdit->Text.c_str();
}

void __fastcall TRemoteMntForm::SpeedButton2Click(TObject *Sender)
{
	if (ListBox1->ItemIndex < 0)
		return;
	int delItem = ListBox1->ItemIndex;
	ListBox1->Items->Delete(delItem);
	ListBox1->ItemIndex = (delItem < ListBox1->Items->Count) ? delItem : delItem - 1;
	checkDisabled();
	ListBox1Click(0);
}
//---------------------------------------------------------------------------

void __fastcall TRemoteMntForm::SpeedButton1Click(TObject *Sender)
{
	TRemoteSource *rs = new TRemoteSource("[New Remote Site]|ftp.domain.org|/pub/sword/raw/");
	ListBox1->ItemIndex = ListBox1->Items->AddObject(rs->is.caption.c_str(), rs);
		
	checkDisabled();
	ListBox1Click(0);
}
//---------------------------------------------------------------------------

void __fastcall TRemoteMntForm::SpeedButton3Click(TObject *Sender)
{
	TRemoteSource *rs;
	config->Sections["Sources"].erase("FTPSource");
	for (int i = 0; i < ListBox1->Items->Count; i++) {
		rs = (TRemoteSource *)ListBox1->Items->Objects[i];
		config->Sections["Sources"].insert(ConfigEntMap::value_type("FTPSource", rs->is.getConfEnt().c_str()));
	}
	(*config)["General"]["PassiveFTP"] = (CheckBox1->Checked) ? "true" : "false";
	config->Save();
	ModalResult = mrOk;
}
//---------------------------------------------------------------------------

