//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <vcl/clipbrd.hpp>
#pragma hdrstop

#include "mainfrm.h"
#include "swdisprtfchap.h"
#include "searchfrm.h"
#include "swwinlog.h"
#include "AboutBoxfrm.h"
#include "ModInstForm.h"
#include "biblecsmgr.h"
#include "Greek2Greek.h"
#include "bookmarkfrm.h"
#include "optionfrm.h"
#include "vrslstfrm.h"
#include <utilstr.h>
#include <filemgr.h>
#include "editentryfrm.h"
#include "versesel.h"
#include "ModTabPanel.h"

//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------


__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
	optionsconf = new SWConfig("./options.conf");

	Lookup->Text = "[ SWORD DDE Lookup ]";
	Search->Text = "[ SWORD DDE Search ]";    
	Application->OnHint = DisplayHint;
}

void __fastcall TForm1::DisplayHint(TObject* Sender) 
{ 
	StatusBar1->SimpleText = Application->Hint;
}

//---------------------------------------------------------------------------
__fastcall TForm1::~TForm1()
{
	list <SWDisplay *>::iterator it;
	int loop;
	
	if (mainmgr)
		delete mainmgr;
	for (it = displays.begin(); it != displays.end(); it++)
		delete *it;
	if (layoutconf)
		delete layoutconf;

	if (optionsconf)
		delete optionsconf;
		
//	for (loop = 0; loop < 10; loop++) {
//		if (ctrlstates[loop]);
//			delete ctrlstates[loop];
//	}
}
//---------------------------------------------------------------------------
void TForm1::BuildRTFHeader(char *buf, char *font, int max)
{
	char buf1[1024], buf2[1024];
	SectionMap::iterator sit;
	
	sprintf(buf1, "{\\rtf1\\ansi");
	if (font)
		sprintf(buf2, "{\\fonttbl{\\f0\\fdecor\\fprq2 %s;}{\\f1\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f2\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f3\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f4\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f7\\froman\\fcharset2\\fprq2 Symbol;}{\\f8\\froman\\fcharset2\\fprq2 Symbol;}}", font);
	else sprintf(buf2, "{\\fonttbl{\\f0\\fdecor\\fprq2 Times New Roman;}{\\f1\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f7\\froman\\fcharset2\\fprq2 Symbol;}{\\f8\\froman\\fcharset2\\fprq2 Symbol;}}");
	strcat(buf1, buf2);

	if ((sit = optionsconf->Sections.find("Appearance")) != optionsconf->Sections.end()) {
		sprintf(buf2, "{\\colortbl;\\red0\\green0\\blue255;\\red%d\\green%d\\blue%d;\\red0\\green0\\blue255;\\red0\\green200\\blue50;\\red0\\green0\\blue255;\\red255\\green0\\blue0;}",
			atoi((*sit).second["CurrentVSColorRed"].c_str()),
			atoi((*sit).second["CurrentVSColorGreen"].c_str()),
			atoi((*sit).second["CurrentVSColorBlue"].c_str()));
	}
	else	sprintf(buf2, "{\\colortbl;\\red0\\green0\\blue255;\\red0\\green200\\blue50;\\red0\\green0\\blue255;\\red0\\green200\\blue50;\\red0\\green0\\blue255;\\red255\\green0\\blue0;}");
	strcat(buf1, buf2);
	memset(buf, 0, max);
	strncpy(buf, buf1, max);
}

char TForm1::CreateTextPane(SWModule *mod, char *font) {
	TTabSheet *newtab = new TTabSheet(this);
	SWDispRTFChap *newrtf = new SWDispRTFChap(this);
	TTextPanel *panel = new TTextPanel(this, mod, font);
	char buf[512];
	SectionMap::iterator sit;
	
	newtab->Caption = mod->Name();
	newtab->Hint = mod->Description();
//	newtab->PageControl = PageControl1;
	panel->Parent = newtab;
/*	
	newrtf->Align = alClient;
	newrtf->ScrollBars = ssVertical;
	newrtf->ReadOnly = true;
	newrtf->PopupMenu = (strcmp(mod->Name(), "N27U4")) ? PopupMenu2 : PopupMenu1;
	newrtf->OnMouseDown = RTFMouseDown;

	BuildRTFHeader(buf, font, 512);
	newrtf->RTFHeader = buf;

	if ((sit = optionsconf->Sections.find("Appearance")) != optionsconf->Sections.end()) {
		newrtf->MarkCurrentVerse = (atoi((*sit).second["AutoVSColor"].c_str())) ? true:false;
	}

	mod->Disp(*displays.insert(displays.begin(), new RTFDisp(newrtf)));
	mod->setKey(DefaultVSKey);
*/
	return 0;
}
//---------------------------------------------------------------------------
char TForm1::CreateCommentPane(SWModule *mod) {
	TTabSheet *newtab = new TTabSheet(this);
	TWinControl *newrtf;

	if (mainmgr->config->Sections[mod->Name()]["ModDrv"] == "HREFCom") {
//		if (mainmgr->config->Sections[mod->Name()]["External"] == "1") {
			newrtf = new TPanel(this);
			((TPanel *)newrtf)->Caption = "Syncronizing to External Viewer";
			mod->Disp(*displays.insert(displays.begin(), new DispExternal()));
/*
		}
		else {
	//		newrtf = new THTML(this->Handle);
	//		newrtf = new SWDispRTF(this);
			newrtf = HTML1;
			newrtf->Visible = true;
			mod->Disp(*displays.insert(displays.begin(), new HREFDisp((THTML *)newrtf)));
	//		mod->Disp(*displays.insert(displays.begin(), new RTFDisp((SWDispRTF *)newrtf)));
		}
*/
	}
	else {
		newrtf = new SWDispRTF(this);
		mod->Disp(*displays.insert(displays.begin(), new RTFDisp((SWDispRTF *)newrtf)));
		((SWDispRTF *)newrtf)->ScrollBars = ssVertical;
		((SWDispRTF *)newrtf)->ReadOnly = true;
		if (mainmgr->config->Sections[mod->Name()]["ModDrv"] == "RawFiles") {
			((SWDispRTF *)newrtf)->PopupMenu = PopupMenu3;
			((SWDispRTF *)newrtf)->ExpandNewLine = false;
		}
		else	((SWDispRTF *)newrtf)->PopupMenu = PopupMenu2;
		((SWDispRTF *)newrtf)->OnMouseDown = RTFMouseDown;
	}

	newtab->Caption = mod->Name();
	newtab->Hint = mod->Description();
	newtab->PageControl = PageControl2;
	newrtf->Parent = newtab;
	newrtf->Align = alClient;

	mod->setKey(DefaultVSKey);
	return 0;
}
//---------------------------------------------------------------------------
char TForm1::CreateLDPane(SWModule *mod) {
	TTabSheet *newtab = new TTabSheet(this);
	SWDispRTF *newrtf = new SWDispRTF(this);

	newtab->Caption = mod->Name();
	newtab->Hint = mod->Description();
	newtab->PageControl = PageControl3;
	newrtf->Parent = newtab;
	newrtf->Align = alClient;
	newrtf->ScrollBars = ssVertical;
	newrtf->ReadOnly = true;
	newrtf->PopupMenu = PopupMenu2;
	newrtf->OnMouseDown = RTFMouseDown;

	mod->Disp(*displays.insert(displays.begin(), new RTFDisp(newrtf)));
	mod->setKey(DefaultStrKey);
	return 0;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PageControl1Change(TObject *Sender)
{
//	RefreshActiveSheet(PageControl1);
//	Form1->ActiveControl = PageControl1;
}
//---------------------------------------------------------------------------
void TForm1::RefreshActiveSheet(TPageControl *pc)
{
	ModMap::iterator it;
	
	it = mainmgr->Modules.find(pc->ActivePage->Caption.c_str());
	if (it != mainmgr->Modules.end()) {
		(*it).second->Display();
		if (logmodstate)
			modstates.insert(modstates.begin(), new ModState(pc, pc->ActivePage, (*it).second->KeyText()));
	}
}


void TForm1::TextKeyChanged()
{
	cbBook->ItemIndex = cbBook->Items->IndexOf(DefaultVSKey.books[DefaultVSKey.Testament()-1][DefaultVSKey.Book()-1].name);
	CHBox->Text  = DefaultVSKey.Chapter();
	VSBox->Text  = DefaultVSKey.Verse();
	freeHandLookup->Text = (const char *)DefaultVSKey;
	textTabs->RefreshActiveSheet();
	logmodstate = false;		// only log state once
	RefreshActiveSheet(PageControl2);
	logmodstate = true;
}


void __fastcall TForm1::btnLookupClick(TObject *Sender)
{
	if (!(StrToInt(CHBox->Text)) || (!StrToInt(VSBox->Text)))
		DefaultVSKey.AutoNormalize(0);

	if (StrToInt(CHBox->Text) < 0)
		CHBox->Text = StrToInt(CHBox->Text) + 1;
	if (StrToInt(VSBox->Text) < 0)
		VSBox->Text = StrToInt(VSBox->Text) + 1;

	DefaultVSKey       = (cbBook->Text + " " + CHBox->Text + ":" + VSBox->Text).c_str();
	TextKeyChanged();
	DefaultVSKey.AutoNormalize(1);	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::PageControl2Change(TObject *Sender)
{
	RefreshActiveSheet(PageControl2);
	Form1->ActiveControl = PageControl2;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DictKeyEditChange(TObject *Sender)
{
	if (DictKeyEdit->Modified) {
		DefaultStrKey = DictKeyEdit->Text.c_str();
		RefreshActiveSheet(PageControl3);
		DictKeyEdit->Modified = false;
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::PageControl3Change(TObject *Sender)
{
	RefreshActiveSheet(PageControl3);
	Form1->ActiveControl = PageControl3;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NewSearchWindow1Click(TObject *Sender)
{
	Form2->Show();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
	Close();	
}

void __fastcall TForm1::About1Click(TObject *Sender)
{
	AboutBox->ShowModal();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DictionaryLookup1Click(TObject *Sender)
{
	int wordstart;
	
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	if (!rtf->SelLength) {
		for (wordstart = rtf->SelStart; (wordstart > -1)&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart--);
		rtf->SelStart = (wordstart > -1) ? wordstart: 0;
		for (wordstart = rtf->SelStart + 1; (wordstart < rtf->Text.Length())&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart++);
		rtf->SelLength = ((wordstart < rtf->Text.Length()) ? wordstart : rtf->Text.Length() - 1) - rtf->SelStart - 1;
	}
	DictKeyEdit->Text = Trim(rtf->SelText);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SaveLayout1Click(TObject *Sender)
{
	ConfigEntMap sit;
	
	sit = layoutconf->Sections["Screen"];
	sit["MainTop"]       = IntToStr(Form1->Top).c_str();
	sit["MainLeft"]      = IntToStr(Form1->Left).c_str();
	sit["MainHeight"]    = IntToStr(Form1->Height).c_str();
	sit["MainWidth"]     = IntToStr(Form1->Width).c_str();
	sit["TextComHeight"] = IntToStr(pnlTextCom->Height).c_str();
	sit["TextWidth"]     = IntToStr(pnlText->Width).c_str();
	layoutconf->Sections["Screen"] = sit;
	layoutconf->Save();
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
	ModMap::iterator it;
	SectionMap::iterator sit;
	ConfigEntMap::iterator eit;
	AnsiString s1;
	char *font;
	int val;
	int loop;
	int maxFiles;

	mainmgr = new BibleCSMGR(ModInstFrm);
//	textTabs = new TModTabPanel(this, mainmgr, "Biblical Texts");
//	textTabs->Align = alClient;	
//	textTabs->Parent = pnlText;
//	logmodstate = true;
//	freshdict   = true;
//	if ((maxFiles = atoi(optionsconf->Sections["System"]["MaxFiles"].c_str()))) {
//		FileMgr::systemFileMgr.maxFiles = maxFiles;
//	}

//	DefaultVSKey = TOP;
//	DefaultVSKey = "Genesis 1:1";
//	cbBook->Clear();
/*
	while (!DefaultVSKey.Error()) {
		s1 = (const char *)DefaultVSKey;
		s1.SetLength(s1.Length() - 4);
		cbBook->Items->Add(s1);
		DefaultVSKey.Book(DefaultVSKey.Book() + 1);
	}
	cbBook->ItemIndex = cbBook->Items->IndexOf("James");

	DefaultVSKey.Persist(1);	// when set to a module, make the module hold on to this actual key and not a copy
	DefaultVSKey = "James 1:19"; // set to our standard starting verse
	DefaultStrKey.Persist(1);
	DefaultStrKey = "";
	Hint = "";
	ShowHint = true;
	Application->ShowHint = true;
	if (SWLog::systemlog)
		delete SWLog::systemlog;
	SWLog::systemlog = new SWWinLog(this->Handle);		// set the system logger to our MSWindows specific SWLog class
	layoutconf = new SWConfig("./layout.conf");

	if ((sit = layoutconf->Sections.find("Screen")) != layoutconf->Sections.end()) {
		if (val = atoi((*sit).second["MainTop"].c_str()))
			Form1->Top = val;
		if (val = atoi((*sit).second["MainLeft"].c_str()))
			Form1->Left = val;
		if (val = atoi((*sit).second["MainHeight"].c_str()))
			Form1->Height = val;
		if (val = atoi((*sit).second["MainWidth"].c_str()))
			Form1->Width = val;
		if (val = atoi((*sit).second["TextComHeight"].c_str()))
			pnlTextCom->Height = val;
		if (val = atoi((*sit).second["TextWidth"].c_str()))
			pnlText->Width = val;
	}

	for (loop = 0; loop < 10; loop++)
		ctrlstates.insert(ctrlstates.begin(), 0);

	ImageList1->Add(BackBtnImage->Picture->Bitmap, NULL);
	ImageList1->Add(SearchBtnImage->Picture->Bitmap, NULL);
	ImageList2->Add(BookmarkBtnImage->Picture->Bitmap, NULL);
*/
}


//void __fastcall TForm1::CreateWnd() {
//	TForm::CreateWnd();

/*	
	for (it = mainmgr->Modules.begin(); it != mainmgr->Modules.end(); it++) {
		if (!strcmp((*it).second->Type(), "Biblical Texts")) {
			font = 0;
			if ((sit = mainmgr->config->Sections.find((*it).second->Name())) != mainmgr->config->Sections.end()) {
				if ((eit = (*sit).second.find("Font")) != (*sit).second.end()) {
					font = (char *)(*eit).second.c_str();
				}
			}
			CreateTextPane((*it).second, font);
		}
		if (!strcmp((*it).second->Type(), "Commentaries"))
			CreateCommentPane((*it).second);
		if (!strcmp((*it).second->Type(), "Lexicons / Dictionaries"))
			CreateLDPane((*it).second);
	}
*/
//}

//---------------------------------------------------------------------------
void __fastcall TForm1::LookupPokeData(TObject *Sender)
{
	char buf[255];
	char *token;
	ModMap::iterator it;

	strncpy(buf, Lookup->Text.c_str(), 254);
	buf[254] = 0;
	token = strtok(buf, " ");
	if ((it = mainmgr->Modules.find(token)) != mainmgr->Modules.end()) {
		token = strtok(NULL, "");
		it->second->setKey(token);
		Lookup->Text = (const char *)(*(*it).second);
	}
	else Lookup->Text = "";
			
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SearchPokeData(TObject *Sender)
{
	char buf[255];
	char *token;
	ModMap::iterator it;
	AnsiString retval = "";

	strncpy(buf, Search->Text.c_str(), 254);
	buf[254] = 0;
	token = strtok(buf, " ");
	if ((it = mainmgr->Modules.find(token)) != mainmgr->Modules.end()) {
		token = strtok(NULL, "");
		ListKey &results = (*it).second->Search(token, REG_ICASE);
		while (!results.Error()) {
			retval = retval + (const char *)results + "; ";
			results++;
		}
		Search->Text = retval;
	}
	else Search->Text = "";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::UpDown3Click(TObject *Sender, TUDBtnType Button)
{
	ModMap::iterator it;
	
	it = mainmgr->Modules.find(PageControl3->ActivePage->Caption.c_str());
	if (it != mainmgr->Modules.end()) {
		if (Button == btNext)
			(*((*it).second))++;
		else	(*((*it).second))--;
		DictKeyEdit->Text = ((*it).second)->KeyText();
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::UpDown1Click(TObject *Sender, TUDBtnType Button)
{
	btnLookupClick(Sender);
}
//---------------------------------------------------------------------------

void TForm1::RestoreState(ModState *state)
{
	if (state) {
		state->pc->ActivePage = state->ap;
//		if ((state->pc == PageControl1) || (state->pc == PageControl2)) {
//				DefaultVSKey = state->key;
//				TextKeyChanged();
//		}
		if (state->pc == PageControl3) {
				DictKeyEdit->Text = (const char *)state->key;
		}
		if (state->pc->ActivePage->ControlCount)
			Form1->ActiveControl = (TWinControl *)state->pc->ActivePage->Controls[0];
	}
}


void __fastcall TForm1::BackbtnClick(TObject *Sender)
{
	list <ModState *>::iterator it;

	logmodstate = false;
	it = modstates.begin();
	if (it != modstates.end()) {
		it++;
	
		if (it != modstates.end()) {
			RestoreState(*it);
			delete *modstates.begin();
			modstates.erase(modstates.begin(), it);
		}
	}
	logmodstate = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
/*
	list <ModState *>::iterator it;
	ListBox1->Clear();
	for (it = modstates.begin(); it != modstates.end(); it++) {
		ListBox1->Items->Add((*it)->ap->Caption.c_str());
	}
*/
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CopyasBGreekTransliteration1Click(TObject *Sender)
{
	char *retbuf;
	int len;
	TClipboard *clip = new TClipboard();
	
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	len = rtf->SelText.Length() * 2;
	retbuf = new char [ len ];
	if (!Greek2bGreek(retbuf, rtf->SelText.c_str(), len)) {
		clip->SetTextBuf(retbuf);
	}
	delete clip;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Copy1Click(TObject *Sender)
{
	int wordstart;
	
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	if (!rtf->SelLength) {
		for (wordstart = rtf->SelStart; (wordstart > -1)&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart--);
		rtf->SelStart = (wordstart > -1) ? wordstart: 0;
		for (wordstart = rtf->SelStart + 1; (wordstart < rtf->Text.Length())&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart++);
		rtf->SelLength = ((wordstart < rtf->Text.Length()) ? wordstart : rtf->Text.Length() - 1) - rtf->SelStart - 1;
	}
	rtf->CopyToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BookmarkItemClick(TObject *Sender)
{
	TMenuItem *menuchoice = (TMenuItem *)Sender;
	DefaultVSKey = menuchoice->Caption.c_str();	
	TextKeyChanged();
}

void __fastcall TForm1::AddBookmark1Click(TObject *Sender)
{
//	TMenuItem *newitem;

	Bookmarksfrm->bmtree->Items->AddChild(Bookmarksfrm->bmtree->Items->Item[0], (const char *)DefaultVSKey);
}

void TForm1::AddSectionToMenu(TMenu *menu, TMenuItem *item, TTreeNode *tree)
{
	TMenuItem *newitem;
	
	for (tree = tree->getFirstChild(); tree; tree = tree->getNextSibling()) {
		newitem = new TMenuItem(menu);
		newitem->Caption = tree->Text;
		if (!tree->getFirstChild()) 
			newitem->OnClick = BookmarkItemClick;
		item->Add(newitem);
		AddSectionToMenu(menu, newitem, tree);
	}
}

void TForm1::RefreshBookmarksMenu(TMenu *menu, TTreeView *treeview)
{
	TMenuItem *newitem;
	TTreeNode *tree = 0;

	if (treeview->Items->Count)
		tree = treeview->Items->Item[0];
	
	while (menu->Items->Count > 3)
		menu->Items->Delete(3);

	for (;tree;tree = tree->getNextSibling()) {
		newitem = new TMenuItem(menu);
		newitem->Caption = tree->Text;
		menu->Items->Add(newitem);
		AddSectionToMenu(menu, newitem, tree);
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BookmarkbtnClick(TObject *Sender)
{
	TPoint menup;
	TPoint point;
	point.x = 0;
	point.y = Bookmarkbtn->Height;
	menup = Bookmarkbtn->ClientToScreen(point);
	RefreshBookmarksMenu(BookmarkPopup, Bookmarksfrm->bmtree);
	BookmarkPopup->Popup(menup.x, menup.y);	
}
//---------------------------------------------------------------------------


void __fastcall TForm1::EditBookmarks1Click(TObject *Sender)
{
	Bookmarksfrm->Show();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyDown(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
	char buf[5];
	int val;
	ModMap::iterator it;
	TPageControl *pc = textTabs->pageControl;

	if ((Shift.Contains(ssCtrl)) && (!Shift.Contains(ssAlt))) {
		if ((Key >= '0') && (Key <= '9')) {
			sprintf(buf, "%c", Key);
			val = atoi(buf);

			if (!Shift.Contains(ssShift)) {
				if ((Screen->ActiveControl == PageControl2) || (IsChild(PageControl2->Handle, Screen->ActiveControl->Handle)))
					pc = PageControl2;
				if ((Screen->ActiveControl == PageControl3) || (IsChild(PageControl3->Handle, Screen->ActiveControl->Handle)))
					pc = PageControl3;

				it = mainmgr->Modules.find(pc->ActivePage->Caption.c_str());
				if (it != mainmgr->Modules.end()) {
					if (ctrlstates[val])
						delete ctrlstates[val];
					
					ctrlstates[val] = new ModState(pc, pc->ActivePage, (*it).second->KeyText());
				}
			}
			else	RestoreState(ctrlstates[val]);
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Options1Click(TObject *Sender)
{
	ModMap::iterator it;
	SectionMap::iterator sit;
	ConfigEntMap emap;
	int color;

	if ((sit = optionsconf->Sections.find("Appearance")) != optionsconf->Sections.end()) {
		Optionsfrm->CurrentVSColor->Brush->Color = atoi((*sit).second["CurrentVSColorRed"].c_str())
			| (atoi((*sit).second["CurrentVSColorGreen"].c_str()) << 8)
			| (atoi((*sit).second["CurrentVSColorBlue"].c_str()) << 16);
		Optionsfrm->AutoVSColor->Checked = ((atoi((*sit).second["AutoVSColor"].c_str()))?true:false);
	}
	
	if ((sit = optionsconf->Sections.find("Bookmarks")) != optionsconf->Sections.end()) {
		Optionsfrm->AutoBMPersonal->Checked = ((atoi((*sit).second["AutoSavePersonal"].c_str()))?true:false);
		Optionsfrm->AutoBMOther->Checked    = ((atoi((*sit).second["AutoSaveOther"].c_str()))?true:false);
	}
		
	if (Optionsfrm->ShowModal() == mrOk) {
		emap = optionsconf->Sections["Appearance"];
		color = Optionsfrm->CurrentVSColor->Brush->Color;
		emap["CurrentVSColorRed"]   = IntToStr(color & 0xFF).c_str();
		emap["CurrentVSColorGreen"] = IntToStr((color >> 8) & 0xFF).c_str();
		emap["CurrentVSColorBlue"]  = IntToStr((color >> 16) & 0xFF).c_str();
		emap["AutoVSColor"]         = IntToStr((Optionsfrm->AutoVSColor->Checked)?1:0).c_str();
		optionsconf->Sections["Appearance"] = emap;

		emap = optionsconf->Sections["Bookmarks"];
		emap["AutoSavePersonal"] = IntToStr((Optionsfrm->AutoBMPersonal->Checked)?1:0).c_str();
		emap["AutoSaveOther"]    = IntToStr((Optionsfrm->AutoBMOther->Checked)?1:0).c_str();
		optionsconf->Sections["Bookmarks"] = emap;

		optionsconf->Save();
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::cbBookChange(TObject *Sender)
{
	CHBox->Text = "1";
	VSBox->Text = "1";
	if (Screen->ActiveControl == cbBook)	
		btnLookupClick(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::PopupMenuPopup(TObject *Sender)
{

	int versestart, verseend;
	TMenuItem * newitem;
	TPopupMenu *menu = (TPopupMenu *)Sender;
	int staticMenuItemsCount = 0;

	if (menu == PopupMenu1)
		staticMenuItemsCount = 3;
	else if (menu == PopupMenu2)
		staticMenuItemsCount = 2;
	else if (menu == PopupMenu3)
		staticMenuItemsCount = 6;
		
	while (menu->Items->Count > staticMenuItemsCount)
		menu->Items->Delete(staticMenuItemsCount);

	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	if (!rtf->SelLength) {
		for (versestart = rtf->SelStart; ((versestart)&&(rtf->Text[versestart] != '#')); versestart--);
		if (versestart) {
			for (verseend = versestart; ((verseend < rtf->Text.Length())&&(rtf->Text[verseend] != '|')); verseend++);
			if ((verseend < rtf->Text.Length()) && (verseend > rtf->SelStart)) {
				int len = (verseend - versestart) + 1;
				char *buf = new char [ len + 1 ];
				memset(buf, 0 , len + 1);
				strncpy(buf, &rtf->Text.c_str()[versestart], len - 2);	// strip the # and | from the string
				tmpVerseList = DefaultVSKey.ParseVerseList(buf, DefaultVSKey);

				ModMap::iterator target;
				target = mainmgr->Modules.find(((TPageControl*)rtf->Parent->Parent)->ActivePage->Caption.c_str());
				if (target != Form1->mainmgr->Modules.end()) {
					char *keytext = 0;		// check for and remove return at end of keytext
					stdstr(&keytext, (*(*target).second).KeyText());
					if (keytext[strlen(keytext)-1] == '\r')
						keytext[strlen(keytext)-1] = 0;
					
					tmpVerseListCaption = String("VerseList from- ") + (*target).first.c_str() + ": " + keytext;
					delete [] keytext;		// ---------------------------------
				}
				delete [] buf;
				newitem = new TMenuItem(menu);
				newitem->Caption = "-";
				menu->Items->Add(newitem);
				newitem = new TMenuItem(menu);
				newitem->Caption = "Create Verse List";
				newitem->Hint = "Create a New Verse List Window";
				newitem->Default = true;
				newitem->OnClick = createVerseList;
				menu->Items->Add(newitem);
				versestart = 3;
				while (!tmpVerseList.Error()) {
					versestart++;
					newitem = new TMenuItem(menu);
					newitem->Caption = (const char *)tmpVerseList;
					newitem->OnClick = BookmarkItemClick;
					if (!(versestart%15))
						newitem->Break = mbBreak;
					menu->Items->Add(newitem);
					tmpVerseList++;
				}
			}
		}
	}
	
}
//---------------------------------------------------------------------------


void __fastcall TForm1::createVerseList(TObject *Sender)
{
	TVerseListFrm *tmpForm = new TVerseListFrm(this, tmpVerseList);
	tmpForm->Caption = tmpVerseListCaption;
	tmpForm->Show();	
}
//---------------------------------------------------------------------------

void __fastcall TForm1::freeHandLookupKeyPress(TObject *Sender, char &Key)
{
	if (Key == '\r') {
		ListKey tmpVerseList = DefaultVSKey.ParseVerseList(freeHandLookup->Text.c_str(), DefaultVSKey);
		if (tmpVerseList.Count() > 1) {
			TVerseListFrm *tmpForm = new TVerseListFrm(this, tmpVerseList);
			tmpForm->Caption = "User Verse List";
			tmpForm->Show();
		}
		if (tmpVerseList.Count()) {
			tmpVerseList = TOP;
			DefaultVSKey = tmpVerseList;
			TextKeyChanged();
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RTFMouseDown(TObject *Sender, TMouseButton Button,
	 TShiftState Shift, int X, int Y)
{
	((TWinControl *)Sender)->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EditEntry1Click(TObject *Sender)
{
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	SWModule *module = 0;
//	EditEntry->RichEdit1->Text = rtf->Text;
	ModMap::iterator target;
	target = mainmgr->Modules.find(((TPageControl*)rtf->Parent->Parent)->ActivePage->Caption.c_str());
	if (target != Form1->mainmgr->Modules.end()) {
		EditEntry->Module = module = (*target).second;
		EditEntry->RTFDisplay = rtf;
	}
	else	EditEntry->Module = module = 0;
	EditEntry->ShowModal();
	if (EditEntry->ResultBuf) {
		if (module)
//			DictKeyEdit->Text = EditEntry->ResultBuf;  // for testing purposes
			*module << EditEntry->ResultBuf;
	}
	RefreshActiveSheet(PageControl2);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DeleteEntry1Click(TObject *Sender)
{
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	SWModule *module = 0;
	ModMap::iterator target;

	target = mainmgr->Modules.find(((TPageControl*)rtf->Parent->Parent)->ActivePage->Caption.c_str());
	if (target != Form1->mainmgr->Modules.end()) {
		module = (*target).second;
		module->deleteEntry();
	}
	RefreshActiveSheet(PageControl2);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::LinktoVerse1Click(TObject *Sender)
{
	if (VerseSelFrm->ShowModal() == mrOk) {
		SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
		SWModule *module = 0;
		ModMap::iterator target;
		SWKey *linkkey = new VerseKey(VerseSelFrm->Panel2->Caption.c_str());

		target = mainmgr->Modules.find(((TPageControl*)rtf->Parent->Parent)->ActivePage->Caption.c_str());
		if (target != Form1->mainmgr->Modules.end()) {
			module = (*target).second;
			*module << linkkey;
		}
		RefreshActiveSheet(PageControl2);
	}
}
//---------------------------------------------------------------------------



