/*  Project sword

    GNU Copyleft GPL  1996. Almost No Rights Reserved.

    SUBSYSTEM:    sword.exe Application
    FILE:         swrtdlgc.cpp
    AUTHOR:       The Sword Project Team


    OVERVIEW
    ========
    Source file for implementation of swordTDLGClient (TDialog).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "tversedt.h"
#include "swordapp.h"
#include "swrtdlgc.h"
#include "serchdlg.h"

#include <versekey.h>
#include <rawtext.h>
#include <rawcom.h>
#include <rawld.h>
#include <tbdisp.h>


class TBLDDisp: public TBDisp {
	int nameid, keyid;
public:
	TBLDDisp(HWND iwnd, int ictrlid, int inameid = 0, int ikeyid = 0):TBDisp(iwnd, ictrlid) {
		nameid = inameid;
		keyid  = ikeyid;
	}
	virtual char Display(SWModule &imodule) {
		TBDisp::Display(imodule);
		if (nameid)
			SetDlgItemText(wnd, nameid, imodule.Description());
		if (keyid)
			SetDlgItemText(wnd,  keyid, (char *)(SWKey)imodule);
	}
};


SWDisplay   *edit1disp = 0;
SWDisplay   *edit2disp = 0;
SWDisplay   *edit3disp = 0;
VerseKey *masterkey = 0;
SWModule *webster   = 0;
SWModule *mhc       = 0;
SWModule *eastons   = 0;
SWModule *vines     = 0;

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(swordTDLGClient, TDialog)
//{{swordTDLGClientRSP_TBL_BEGIN}}
    EV_BN_CLICKED(IDC_LOOKUP, BNClicked),
    EV_WM_RBUTTONDOWN,
    EV_BN_CLICKED(IDC_UPBUTTON, UpVerse),
    EV_BN_CLICKED(IDC_DOWNBUTTON, DownVerse),
    EV_COMMAND(CM_EDITFIND, SearchTxt),
//{{swordTDLGClientRSP_TBL_END}}
END_RESPONSE_TABLE;


// SWLookup This is a kludgy way to lookup, but a Module manager will do
//	this work in the future
void SWLookup(char *modname, SWKey &key)
{
	if (!stricmp(modname, eastons->Name())) {
		eastons->setKey(key);
		eastons->Display();
	}
	if (!stricmp(modname, vines->Name())) {
		vines->setKey(key);
		vines->Display();
	}
}




//{{swordTDLGClient Implementation}}


//////////////////////////////////////////////////////////
// swordTDLGClient
// ==========
// Construction/Destruction handling.
static swordTDLGClientXfer swordTDLGClientData;

swordTDLGClient::swordTDLGClient (TWindow *parent, TResId resId, TModule *module)
    : TDialog(parent, resId, module)
{
//{{swordTDLGClientXFER_USE}}
    BookCB  = new TComboBox(this, IDC_BOOK, 1);
    WebEdit = new TVerseEdit(this, IDC_VTEXT, 255);
    MHCEdit = new TVerseEdit(this, IDC_CTEXT, 255);
    LDText  = new TVerseEdit(this, IDC_DTEXT, 255);

    SetTransferBuffer(&swordTDLGClientData);
//{{swordTDLGClientXFER_USE_END}}

}


swordTDLGClient::~swordTDLGClient ()
{
    Destroy();

    delete edit1disp;
    delete edit2disp;
    delete edit3disp;
    delete webster;
    delete mhc;
    delete eastons;
    delete vines;
    delete masterkey;
}


void swordTDLGClient::SetupWindow ()
{
	char loop1, loop2;

    TDialog::SetupWindow();

	edit1disp = new TBLDDisp(HWindow, IDC_VTEXT, 0, IDC_KTEXT);
	edit2disp = new TBLDDisp(HWindow, IDC_CTEXT);
	edit3disp = new TBLDDisp(HWindow, IDC_DTEXT, IDC_LDNAME, IDC_LDKEY);
	masterkey = new VerseKey();
	webster   = new RawText("../../../../modules/texts/rawtext/webster/", "Webster", "Webster Text", edit1disp);
	mhc       = new RawCom ("../../../../modules/comments/rawcom/mhc/", "MHC", "Matthew Henry's Commentary", edit2disp);
	eastons   = new RawLD  ("../../../../modules/lexdict/rawld/eastons/eastons", "Eastons", "Easton's Bible Dictionary", edit3disp);
	vines     = new RawLD  ("../../../../modules/lexdict/rawld/vines/vines", "Vines", "Vine's Bible Dictionary", edit3disp);

	masterkey->Persist(1);
	webster->setKey(*masterkey);
	mhc->setKey(*masterkey);

	for (loop1 = 0; loop1 < 2; loop1++) {
		for (loop2 = 0; loop2 < VerseKey::BMAX[loop1]; loop2++) {
			BookCB->AddString(VerseKey::books[loop1][loop2].name);
		}
	}
	BookCB->SetSelIndex(58);
	SetDlgItemText(IDC_CHAPTER, "1");
	SetDlgItemText(IDC_VERSE, "19");
}


void swordTDLGClient::BNClicked ()
{
	char buf[80], tmpbuf[70];
	int ch, vs;

	BookCB->GetText(tmpbuf, 79);
	ch = GetDlgItemInt(IDC_CHAPTER);
	vs = GetDlgItemInt(IDC_VERSE);

	masterkey->AutoNormalize(ch && vs);	// if either chapter or verse are 0 then don't auto normalize so that we can lookup intros

	wsprintf(buf, "%s %d:%d", tmpbuf, ch, vs);
	*masterkey = buf;

	webster->Display();
	mhc->Display();

}


void swordTDLGClient::EvRButtonDown (uint modKeys, TPoint& point)
{
    TDialog::EvRButtonDown(modKeys, point);
}


void swordTDLGClient::UpVerse ()
{
	(*masterkey)--;
	webster->Display();
	mhc->Display();
}


void swordTDLGClient::DownVerse ()
{
	(*masterkey)++;
	webster->Display();
	mhc->Display();
}


void swordTDLGClient::EvPaint ()
{
    TDialog::EvPaint();

    // INSERT>> Your code here.

}


void swordTDLGClient::SearchTxt ()
{
    new SearchDlg(this)->Create();
}

