/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.data;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class DataObject
implements Cloneable,
Serializable {
    private Hashtable values = new Hashtable();
    private static boolean DEBUG = true;

    public void copyFrom(DataObject dataObject) {
        try {
            this.values = (Hashtable)dataObject.values.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Object clone() {
        DataObject dataObject = null;
        try {
            dataObject = (DataObject)super.clone();
            dataObject.values = (Hashtable)this.values.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return dataObject;
    }

    public static void setDebug(boolean bl) {
        DEBUG = bl;
    }

    protected void setCompanyID(int n) {
        this.setIntValue("COMPANYID", n);
    }

    public int getCompanyID() {
        return this.getIntValue("COMPANYID");
    }

    public float getFloatValue(String string) {
        return ((Float)this.getValue(string)).floatValue();
    }

    public int getIntValue(String string) {
        Integer n = (Integer)this.getValue(string);
        return n != null ? n : 0;
    }

    public String getStringValue(String string) {
        String string2 = (String)this.getValue(string);
        if (string2 == null || "null".equals(string2)) {
            string2 = "";
        }
        return string2;
    }

    public Timestamp getTSValue(String string) {
        Timestamp timestamp = (Timestamp)this.getValue(string);
        return timestamp;
    }

    public java.util.Date getDateValue(String string) {
        java.util.Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        Object object = this.getValue(string);
        if (object instanceof String) {
            try {
                date = simpleDateFormat.parse(object.toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (object instanceof Date) {
            date = new java.util.Date(((Date)object).getTime());
        }
        return date;
    }

    public void setIntValue(String string, int n) {
        this.setValue(string, new Integer(n));
    }

    public void setFloatValue(String string, float f) {
        this.setValue(string, new Float(f));
    }

    public void setDateValue(String string, java.util.Date date) {
        if (date != null) {
            this.setValue(string, new Date(date.getTime()));
        } else {
            this.setValue(string, null);
        }
    }

    public void setValue(String string, Object object) {
        if (object != null) {
            this.values.put(string, object);
        } else {
            this.values.remove(string);
        }
    }

    public void setValue(String string, String string2, int n) {
        if (string2 != null && string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        this.values.put(string, string2);
    }

    public void fillFromRow(ResultSet resultSet) throws Exception {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string = resultSetMetaData.getColumnName(i + 1);
            Object object = resultSet.getObject(i + 1);
            if (object == null) continue;
            this.values.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDataSet(String string) {
        Vector<DataObject> vector = new Vector<DataObject>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Object var6_6 = null;
        try {
            connection = DataObject.getDBConnection();
            if (connection == null) {
                System.out.println("<br>couldn't get DB connection");
                Vector<DataObject> vector2 = vector;
                return vector2;
            }
            try {
                statement = this.prepareSQL(connection, string);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    DataObject dataObject = this.createDataObject();
                    dataObject.fillFromRow(resultSet);
                    vector.add(dataObject);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (DEBUG) {
            System.out.println("rs.size() = " + vector.size());
        }
        return vector;
    }

    protected DataObject createDataObject() {
        return new DataObject();
    }

    public Object getValue(String string) {
        return this.values.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeSQL(String string) {
        Connection connection = null;
        Statement statement = null;
        Object var4_4 = null;
        int n = -1;
        try {
            connection = DataObject.getDBConnection();
            if (connection == null) {
                System.out.println("<br>couldn't get DB connection");
                int n2 = -1;
                return n2;
            }
            try {
                statement = this.prepareSQL(connection, string);
                n = statement.executeUpdate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public static synchronized Connection getDBConnection() {
        DataSource dataSource = null;
        Connection connection = null;
        try {
            InitialContext initialContext = new InitialContext();
            if (initialContext == null) {
                throw new Exception("Boom - No Context");
            }
            dataSource = (DataSource)initialContext.lookup("java:comp/env/storeDB");
            try {
                connection = dataSource.getConnection();
            }
            catch (SQLException sQLException) {
                System.out.println("getting new data source connection failed! Error: " + sQLException + "\n");
            }
        }
        catch (Exception exception) {
            System.out.println("Could Not get data source, error: " + exception + "\n");
        }
        return connection;
    }

    private PreparedStatement prepareSQL(Connection connection, String string) throws Exception {
        String string2;
        int n;
        int n2 = 1;
        Vector<Object> vector = new Vector<Object>();
        int n3 = string.indexOf(123, n2);
        while (n3 > -1) {
            n = string.indexOf(125, n3);
            if (n > -1) {
                string2 = string.substring(n3 + 1, n);
                Object object = this.getValue(string2);
                if (DEBUG) {
                    System.out.println("Adding Param (from {" + string2 + "}: " + object);
                }
                vector.add(object);
                string = string.substring(0, n3) + "?" + string.substring(n + 1);
            }
            n2 = n3 + 1;
            n3 = string.indexOf(123, n2);
        }
        if (DEBUG) {
            System.out.println("Preparing SQL: " + string);
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        for (n = 0; n < vector.size(); ++n) {
            string2 = vector.get(n);
            try {
                if (string2 instanceof String) {
                    preparedStatement.setString(n + 1, string2);
                }
            }
            catch (DataTruncation dataTruncation) {
                System.out.println("Data truncated!");
                dataTruncation.printStackTrace();
            }
            if (string2 instanceof Integer) {
                preparedStatement.setInt(n + 1, (Integer)((Object)string2));
            } else if (string2 instanceof Date) {
                preparedStatement.setDate(n + 1, (Date)((Object)string2));
            } else {
                preparedStatement.setObject(n + 1, string2);
            }
            if (!DEBUG) continue;
            System.out.println("Param " + n + ": " + string2);
        }
        return preparedStatement;
    }

    public int save(DataObject dataObject, String string, String[] stringArray) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.values.keys();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            Object v = this.values.get(string2);
            Object object = dataObject.getValue(string2);
            if (v.equals("null") || v.equals(object)) continue;
            stringBuffer.append((bl ? "" : ",") + string2 + "={" + string2 + "}");
            bl = false;
        }
        if (!bl) {
            bl = true;
            string2 = "UPDATE " + string + " SET " + stringBuffer.toString() + " WHERE ";
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + (bl ? "" : " AND ") + stringArray[i] + "={" + stringArray[i] + "}";
                bl = false;
            }
            return this.executeSQL(string2);
        }
        return 0;
    }

    public int saveNew(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Enumeration enumeration = this.values.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            Object v = this.values.get(string2);
            if (v.equals("null")) continue;
            stringBuffer.append((n == 0 ? "" : ",") + string2);
            stringBuffer2.append((n == 0 ? "" : ",") + "{" + string2 + "}");
            ++n;
        }
        if (n > 0) {
            string2 = "INSERT INTO " + string + " (" + stringBuffer.toString() + ") VALUES (";
            string2 = string2 + stringBuffer2;
            string2 = string2 + ")";
            return this.executeSQL(string2);
        }
        return 0;
    }

    public DataObject lookupThis(String string) {
        Object object;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.values.keys();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            object = this.values.get(string2);
            stringBuffer.append((bl ? "" : " AND ") + string2 + "={" + string2 + "}");
            bl = false;
        }
        string2 = "SELECT * FROM " + string + " WHERE " + stringBuffer.toString();
        object = this.getDataSet(string2);
        if (((Vector)object).size() != 1) {
            System.out.println("Serious Data Error, this object is not unique");
        }
        return (DataObject)((Vector)object).get(0);
    }
}

