/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;

public class AsciiToBetacode {
    public static String getClassInfo(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "26-Apr-2002";
                break;
            }
            case 1: {
                string = "Converts an ASCII string containing Greek text into Betacode";
                break;
            }
            case 2: {
                string = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                string = "Omnes una manet nox.";
            }
        }
        return string;
    }

    public String convertString(String string) {
        int n = string.length();
        char c = '\n';
        boolean bl = false;
        String string2 = new String();
        string = string + " ";
        MessageHandler.clearMsgQueue();
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            string2 = string2 + this.convertChar(c, c2, string.charAt(n2 + 1));
            c = c2;
            MessageHandler.enqueueMsg(" at pos. " + String.valueOf(n2 + 1) + "\n");
            ++n2;
        }
        return string2;
    }

    private String getAsciiConvChar(char c, char c2) {
        String string = new String();
        string = Character.isUpperCase(c) ? "*" + c2 : "" + c2;
        return string;
    }

    private String convertChar(char c, char c2, char c3) {
        char c4 = Character.toUpperCase(c2);
        char c5 = Character.toUpperCase(c3);
        String string = new String();
        if (c2 > 'y') {
            switch (c2) {
                case '\u00ca': {
                    string = "*H";
                    break;
                }
                case '\u00ea': {
                    string = "H";
                    break;
                }
                case '\u00d4': {
                    string = "*W";
                    break;
                }
                case '\u00f4': {
                    string = "W";
                    break;
                }
                case '\u00cf': {
                    string = "*+I";
                    break;
                }
                case '\u00ef': {
                    string = "I+";
                    break;
                }
                case '\u009f': {
                    string = "*+U";
                    break;
                }
                case '\u00ff': {
                    string = "U+";
                    break;
                }
                default: {
                    string = "?";
                    break;
                }
            }
        } else {
            block10 : switch (c4) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '\'': 
                case '(': 
                case ')': 
                case ',': 
                case '.': 
                case ':': 
                case ';': 
                case '?': 
                case 'A': 
                case 'B': 
                case 'D': 
                case 'E': 
                case 'G': 
                case 'I': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'R': 
                case 'U': 
                case 'Z': {
                    string = this.getAsciiConvChar(c2, c4);
                    break;
                }
                case 'C': 
                case 'K': 
                case 'T': {
                    if (c5 == 'H') break;
                    string = this.getAsciiConvChar(c2, c4);
                    break;
                }
                case 'P': {
                    if (c5 == 'H' || c5 == 'S') break;
                    string = this.getAsciiConvChar(c2, c4);
                    break;
                }
                case 'Y': {
                    string = this.getAsciiConvChar(c2, 'U');
                    break;
                }
                case 'X': {
                    string = this.getAsciiConvChar(c2, 'C');
                    break;
                }
                case 'S': {
                    if (c == 'P') {
                        string = "*Y";
                        break;
                    }
                    if (c == 'p') {
                        string = "Y";
                        break;
                    }
                    if (c2 == 's') {
                        switch (c3) {
                            case '\t': 
                            case '\n': 
                            case '\u000b': 
                            case '\f': 
                            case '\r': 
                            case ' ': 
                            case '(': 
                            case ')': 
                            case ',': 
                            case '-': 
                            case '.': 
                            case '/': 
                            case ':': 
                            case ';': 
                            case '?': 
                            case '[': 
                            case ']': 
                            case '{': 
                            case '}': {
                                string = "J";
                                break block10;
                            }
                        }
                        string = "S";
                        break;
                    }
                    string = "*S";
                    break;
                }
                case 'H': {
                    switch (c) {
                        case 'T': {
                            string = "*Q";
                            break block10;
                        }
                        case 't': {
                            string = "Q";
                            break block10;
                        }
                        case 'P': {
                            string = "*F";
                            break block10;
                        }
                        case 'p': {
                            string = "F";
                            break block10;
                        }
                        case 'C': 
                        case 'K': {
                            string = "*X";
                            break block10;
                        }
                        case 'c': 
                        case 'k': {
                            string = "X";
                        }
                    }
                }
            }
        }
        return string;
    }
}

