/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;
import greekconverter.UnicodeToName;
import java.util.Stack;

public class BetacodeToUnicode {
    private static final char UNDEFINED_SYMBOL = '\u0000';
    private static final byte CASE_LOWER = 0;
    private static final byte CASE_UPPER = 1;
    private static final byte WORDEND_NO = 0;
    private static final byte WORDEND_YES = 1;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_SYMBOL = 1;
    private static final int STATE_UPPERCASE = 2;
    private static final char[][] tblLookup = new char[256][];
    private static final char[] tblChars = new char[256];
    private static final char[] tblPunct = new char[164];
    private static final char[] tblTSyms = new char[23];
    private static final char[] tblSigma = new char[5];
    private static final char[] tblLBrack = new char[33];
    private static final char[] tblRBrack = new char[33];
    private static final byte[] tblWordEnd = new byte[256];
    Stack bracketStack = new Stack();
    int state = 0;

    public static String getClassInfo(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "12-Feb-2004";
                break;
            }
            case 1: {
                string = "Converts a Beta coded string into *decomposed* Unicode.";
                break;
            }
            case 2: {
                string = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                string = "Quid sit futurum cras, fuge quaerere.";
            }
        }
        return string;
    }

    public String convertString(String string) {
        int n = string.length();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(n);
        char c = ' ';
        int n3 = 32;
        BetaSymbol betaSymbol = new BetaSymbol();
        boolean bl = false;
        MessageHandler.clearMsgQueue();
        MessageHandler.enqueueMsg("Input >" + string + "< has " + n + " characters", 20);
        while (n2 < n) {
            c = string.charAt(n2++);
            switch (c) {
                case '*': {
                    stringBuffer.append(this.convertChar(betaSymbol));
                    betaSymbol.setCase((byte)1);
                    this.state = 2;
                    break;
                }
                case ')': {
                    betaSymbol.setBreathing('\u0313');
                    break;
                }
                case '(': {
                    betaSymbol.setBreathing('\u0314');
                    break;
                }
                case '/': {
                    betaSymbol.setAccent('\u0301');
                    break;
                }
                case '\\': {
                    betaSymbol.setAccent('\u0300');
                    break;
                }
                case '=': {
                    betaSymbol.setAccent('\u0342');
                    break;
                }
                case '|': {
                    betaSymbol.setIota('\u0345');
                    break;
                }
                case '+': {
                    betaSymbol.setDiaeresis('\u0308');
                    break;
                }
                case '#': 
                case '%': 
                case '[': 
                case ']': {
                    stringBuffer.append(this.convertChar(betaSymbol));
                    betaSymbol.setCharacter(c);
                    this.state = 1;
                    break;
                }
                case 'S': 
                case 's': {
                    if (this.state == 2) {
                        betaSymbol.setCharacter(c);
                        this.state = 0;
                        break;
                    }
                    stringBuffer.append(this.convertChar(betaSymbol));
                    betaSymbol.setCharacter(c);
                    this.state = 1;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (this.state == 1) {
                        betaSymbol.appNumStr(String.valueOf(c));
                        break;
                    }
                }
                default: {
                    if (this.state == 2) {
                        betaSymbol.setCharacter(c);
                        this.state = 0;
                        break;
                    }
                    betaSymbol.setWordEnd(tblWordEnd[c]);
                    stringBuffer.append(this.convertChar(betaSymbol));
                    betaSymbol.setCharacter(c);
                }
            }
            MessageHandler.enqueueMsg(" at pos. " + n2 + "\n");
        }
        betaSymbol.setWordEnd((byte)1);
        stringBuffer.append(this.convertChar(betaSymbol));
        MessageHandler.enqueueMsg(" at pos. " + n2 + "\n");
        return stringBuffer.toString();
    }

    private String convertChar(BetaSymbol betaSymbol) {
        StringBuffer stringBuffer = new StringBuffer(5);
        char c = betaSymbol.getCharacter();
        byte by = betaSymbol.getCase();
        int n = betaSymbol.getNum();
        try {
            if (tblLookup[c] == tblChars) {
                n = by == 1 ? (int)Character.toUpperCase(c) : (int)Character.toLowerCase(c);
            } else if (tblLookup[c] == tblSigma) {
                if (by == 1) {
                    n = 4;
                } else if (n == 0 && betaSymbol.getWordEnd() == 1) {
                    n = 2;
                }
            }
            char c2 = tblLookup[c][n];
            if (c2 == '\u0000') {
                stringBuffer.append(c);
                stringBuffer.append(n);
            } else {
                stringBuffer.append(c2);
                stringBuffer.append(betaSymbol.getBreathing());
                stringBuffer.append(betaSymbol.getDiaeresis());
                stringBuffer.append(betaSymbol.getAccent());
                stringBuffer.append(betaSymbol.getIota());
            }
        }
        catch (Exception exception) {
            stringBuffer.append(c);
            stringBuffer.append(n);
        }
        this.state = 0;
        betaSymbol.reset();
        String string = stringBuffer.toString();
        MessageHandler.enqueueMsg(UnicodeToName.convertString(string), 20);
        return string;
    }

    static {
        int n = 0;
        while (n < 256) {
            BetacodeToUnicode.tblLookup[n] = tblChars;
            ++n;
        }
        BetacodeToUnicode.tblLookup[35] = tblTSyms;
        BetacodeToUnicode.tblLookup[37] = tblPunct;
        BetacodeToUnicode.tblLookup[83] = tblSigma;
        BetacodeToUnicode.tblLookup[91] = tblLBrack;
        BetacodeToUnicode.tblLookup[93] = tblRBrack;
        BetacodeToUnicode.tblLookup[115] = tblSigma;
        n = 0;
        while (n < 256) {
            BetacodeToUnicode.tblChars[n] = (char)n;
            ++n;
        }
        BetacodeToUnicode.tblChars[33] = 8228;
        BetacodeToUnicode.tblChars[63] = 803;
        BetacodeToUnicode.tblChars[65] = 913;
        BetacodeToUnicode.tblChars[66] = 914;
        BetacodeToUnicode.tblChars[67] = 926;
        BetacodeToUnicode.tblChars[68] = 916;
        BetacodeToUnicode.tblChars[69] = 917;
        BetacodeToUnicode.tblChars[70] = 934;
        BetacodeToUnicode.tblChars[71] = 915;
        BetacodeToUnicode.tblChars[72] = 919;
        BetacodeToUnicode.tblChars[73] = 921;
        BetacodeToUnicode.tblChars[74] = '\u0000';
        BetacodeToUnicode.tblChars[75] = 922;
        BetacodeToUnicode.tblChars[76] = 923;
        BetacodeToUnicode.tblChars[77] = 924;
        BetacodeToUnicode.tblChars[78] = 925;
        BetacodeToUnicode.tblChars[79] = 927;
        BetacodeToUnicode.tblChars[80] = 928;
        BetacodeToUnicode.tblChars[81] = 920;
        BetacodeToUnicode.tblChars[82] = 929;
        BetacodeToUnicode.tblChars[83] = 931;
        BetacodeToUnicode.tblChars[84] = 932;
        BetacodeToUnicode.tblChars[85] = 933;
        BetacodeToUnicode.tblChars[86] = 988;
        BetacodeToUnicode.tblChars[87] = 937;
        BetacodeToUnicode.tblChars[88] = 935;
        BetacodeToUnicode.tblChars[89] = 936;
        BetacodeToUnicode.tblChars[90] = 918;
        BetacodeToUnicode.tblChars[97] = 945;
        BetacodeToUnicode.tblChars[98] = 946;
        BetacodeToUnicode.tblChars[99] = 958;
        BetacodeToUnicode.tblChars[100] = 948;
        BetacodeToUnicode.tblChars[101] = 949;
        BetacodeToUnicode.tblChars[102] = 966;
        BetacodeToUnicode.tblChars[103] = 947;
        BetacodeToUnicode.tblChars[104] = 951;
        BetacodeToUnicode.tblChars[105] = 953;
        BetacodeToUnicode.tblChars[106] = 962;
        BetacodeToUnicode.tblChars[107] = 954;
        BetacodeToUnicode.tblChars[108] = 955;
        BetacodeToUnicode.tblChars[109] = 956;
        BetacodeToUnicode.tblChars[110] = 957;
        BetacodeToUnicode.tblChars[111] = 959;
        BetacodeToUnicode.tblChars[112] = 960;
        BetacodeToUnicode.tblChars[113] = 952;
        BetacodeToUnicode.tblChars[114] = 961;
        BetacodeToUnicode.tblChars[115] = 963;
        BetacodeToUnicode.tblChars[116] = 964;
        BetacodeToUnicode.tblChars[117] = 965;
        BetacodeToUnicode.tblChars[118] = 989;
        BetacodeToUnicode.tblChars[119] = 969;
        BetacodeToUnicode.tblChars[120] = 967;
        BetacodeToUnicode.tblChars[121] = 968;
        BetacodeToUnicode.tblChars[122] = 950;
        n = 0;
        while (n < 164) {
            BetacodeToUnicode.tblPunct[n] = '\u0000';
            ++n;
        }
        BetacodeToUnicode.tblPunct[0] = 8224;
        BetacodeToUnicode.tblPunct[1] = 63;
        BetacodeToUnicode.tblPunct[2] = 42;
        BetacodeToUnicode.tblPunct[3] = 47;
        BetacodeToUnicode.tblPunct[4] = 33;
        BetacodeToUnicode.tblPunct[5] = 124;
        BetacodeToUnicode.tblPunct[6] = 61;
        BetacodeToUnicode.tblPunct[7] = 43;
        BetacodeToUnicode.tblPunct[8] = 37;
        BetacodeToUnicode.tblPunct[9] = 38;
        BetacodeToUnicode.tblPunct[10] = 58;
        BetacodeToUnicode.tblPunct[11] = 46;
        BetacodeToUnicode.tblPunct[12] = 8903;
        BetacodeToUnicode.tblPunct[13] = 8225;
        BetacodeToUnicode.tblPunct[14] = 167;
        BetacodeToUnicode.tblPunct[15] = 8242;
        BetacodeToUnicode.tblPunct[16] = 166;
        BetacodeToUnicode.tblPunct[17] = 8214;
        BetacodeToUnicode.tblPunct[18] = 60;
        BetacodeToUnicode.tblPunct[19] = 8208;
        BetacodeToUnicode.tblPunct[20] = 769;
        BetacodeToUnicode.tblPunct[21] = 768;
        BetacodeToUnicode.tblPunct[22] = 770;
        BetacodeToUnicode.tblPunct[23] = 776;
        BetacodeToUnicode.tblPunct[24] = 771;
        BetacodeToUnicode.tblPunct[25] = 807;
        BetacodeToUnicode.tblPunct[26] = 772;
        BetacodeToUnicode.tblPunct[27] = 774;
        BetacodeToUnicode.tblPunct[28] = 776;
        BetacodeToUnicode.tblPunct[29] = 803;
        BetacodeToUnicode.tblPunct[30] = 8127;
        BetacodeToUnicode.tblPunct[31] = 8190;
        BetacodeToUnicode.tblPunct[32] = 8189;
        BetacodeToUnicode.tblPunct[33] = 8175;
        BetacodeToUnicode.tblPunct[34] = 8128;
        BetacodeToUnicode.tblPunct[35] = 8142;
        BetacodeToUnicode.tblPunct[36] = 8158;
        BetacodeToUnicode.tblPunct[37] = 8157;
        BetacodeToUnicode.tblPunct[38] = 8159;
        BetacodeToUnicode.tblPunct[39] = 168;
        BetacodeToUnicode.tblPunct[40] = 728;
        BetacodeToUnicode.tblPunct[41] = 175;
        BetacodeToUnicode.tblPunct[43] = 120;
        BetacodeToUnicode.tblPunct[47] = 61;
        BetacodeToUnicode.tblPunct[94] = 775;
        BetacodeToUnicode.tblPunct[98] = 12291;
        BetacodeToUnicode.tblPunct[100] = 59;
        BetacodeToUnicode.tblPunct[101] = 35;
        BetacodeToUnicode.tblPunct[102] = 39;
        BetacodeToUnicode.tblPunct[103] = 92;
        BetacodeToUnicode.tblPunct[104] = 8248;
        BetacodeToUnicode.tblPunct[107] = 126;
        BetacodeToUnicode.tblPunct[108] = 177;
        BetacodeToUnicode.tblPunct[109] = 183;
        BetacodeToUnicode.tblPunct[127] = 815;
        BetacodeToUnicode.tblPunct[128] = 770;
        BetacodeToUnicode.tblPunct[129] = 8224;
        BetacodeToUnicode.tblPunct[132] = 8174;
        BetacodeToUnicode.tblPunct[133] = 8141;
        BetacodeToUnicode.tblPunct[134] = 8143;
        BetacodeToUnicode.tblPunct[147] = 778;
        BetacodeToUnicode.tblPunct[148] = 780;
        BetacodeToUnicode.tblPunct[149] = 808;
        BetacodeToUnicode.tblPunct[150] = 124;
        BetacodeToUnicode.tblPunct[151] = 8208;
        BetacodeToUnicode.tblPunct[152] = 46;
        BetacodeToUnicode.tblPunct[153] = 8208;
        BetacodeToUnicode.tblPunct[154] = 8756;
        BetacodeToUnicode.tblPunct[158] = 8258;
        BetacodeToUnicode.tblPunct[159] = 215;
        BetacodeToUnicode.tblPunct[160] = 45;
        BetacodeToUnicode.tblPunct[161] = 247;
        BetacodeToUnicode.tblPunct[162] = 824;
        BetacodeToUnicode.tblPunct[163] = 182;
        n = 0;
        while (n < 23) {
            BetacodeToUnicode.tblTSyms[n] = '\u0000';
            ++n;
        }
        BetacodeToUnicode.tblTSyms[0] = 884;
        BetacodeToUnicode.tblTSyms[1] = 990;
        BetacodeToUnicode.tblTSyms[2] = 986;
        BetacodeToUnicode.tblTSyms[3] = 990;
        BetacodeToUnicode.tblTSyms[4] = 990;
        BetacodeToUnicode.tblTSyms[5] = 992;
        BetacodeToUnicode.tblTSyms[6] = 8208;
        BetacodeToUnicode.tblTSyms[7] = 46;
        BetacodeToUnicode.tblTSyms[9] = 769;
        BetacodeToUnicode.tblTSyms[17] = 47;
        BetacodeToUnicode.tblTSyms[19] = 768;
        BetacodeToUnicode.tblTSyms[22] = 885;
        BetacodeToUnicode.tblSigma[0] = 963;
        BetacodeToUnicode.tblSigma[1] = 963;
        BetacodeToUnicode.tblSigma[2] = 962;
        BetacodeToUnicode.tblSigma[3] = 1010;
        BetacodeToUnicode.tblSigma[4] = 931;
        n = 0;
        while (n < 33) {
            BetacodeToUnicode.tblLBrack[n] = '\u0000';
            BetacodeToUnicode.tblRBrack[n] = '\u0000';
            ++n;
        }
        BetacodeToUnicode.tblLBrack[0] = 91;
        BetacodeToUnicode.tblRBrack[0] = 93;
        BetacodeToUnicode.tblLBrack[1] = 40;
        BetacodeToUnicode.tblRBrack[1] = 41;
        BetacodeToUnicode.tblLBrack[2] = 12296;
        BetacodeToUnicode.tblRBrack[2] = 12297;
        BetacodeToUnicode.tblLBrack[3] = 123;
        BetacodeToUnicode.tblRBrack[3] = 125;
        BetacodeToUnicode.tblLBrack[4] = 12314;
        BetacodeToUnicode.tblRBrack[4] = 12315;
        BetacodeToUnicode.tblLBrack[5] = 8990;
        BetacodeToUnicode.tblRBrack[5] = 8991;
        BetacodeToUnicode.tblLBrack[6] = 8988;
        BetacodeToUnicode.tblRBrack[6] = 8989;
        BetacodeToUnicode.tblLBrack[7] = 8988;
        BetacodeToUnicode.tblRBrack[7] = 8991;
        BetacodeToUnicode.tblLBrack[8] = 8990;
        BetacodeToUnicode.tblRBrack[8] = 8989;
        BetacodeToUnicode.tblLBrack[11] = 8333;
        BetacodeToUnicode.tblRBrack[11] = 8334;
        BetacodeToUnicode.tblLBrack[13] = 91;
        BetacodeToUnicode.tblRBrack[13] = 93;
        BetacodeToUnicode.tblLBrack[16] = 12310;
        BetacodeToUnicode.tblRBrack[16] = 12311;
        BetacodeToUnicode.tblLBrack[18] = 12298;
        BetacodeToUnicode.tblRBrack[18] = 12299;
        BetacodeToUnicode.tblLBrack[20] = 9127;
        BetacodeToUnicode.tblRBrack[20] = 9131;
        BetacodeToUnicode.tblLBrack[21] = 9130;
        BetacodeToUnicode.tblRBrack[21] = 9130;
        BetacodeToUnicode.tblLBrack[22] = 9128;
        BetacodeToUnicode.tblRBrack[22] = 9132;
        BetacodeToUnicode.tblLBrack[23] = 9129;
        BetacodeToUnicode.tblRBrack[23] = 9133;
        BetacodeToUnicode.tblLBrack[30] = 9115;
        BetacodeToUnicode.tblRBrack[30] = 9118;
        BetacodeToUnicode.tblLBrack[31] = 9116;
        BetacodeToUnicode.tblRBrack[31] = 9119;
        BetacodeToUnicode.tblLBrack[32] = 9117;
        BetacodeToUnicode.tblRBrack[32] = 9120;
        n = 0;
        while (n < 256) {
            BetacodeToUnicode.tblWordEnd[n] = 0;
            ++n;
        }
        BetacodeToUnicode.tblWordEnd[32] = 1;
        BetacodeToUnicode.tblWordEnd[46] = 1;
        BetacodeToUnicode.tblWordEnd[58] = 1;
        BetacodeToUnicode.tblWordEnd[59] = 1;
        BetacodeToUnicode.tblWordEnd[44] = 1;
        BetacodeToUnicode.tblWordEnd[35] = 1;
        BetacodeToUnicode.tblWordEnd[37] = 1;
        BetacodeToUnicode.tblWordEnd[91] = 1;
        BetacodeToUnicode.tblWordEnd[93] = 1;
        BetacodeToUnicode.tblWordEnd[34] = 1;
        BetacodeToUnicode.tblWordEnd[36] = 1;
        BetacodeToUnicode.tblWordEnd[60] = 1;
        BetacodeToUnicode.tblWordEnd[62] = 1;
        BetacodeToUnicode.tblWordEnd[64] = 1;
    }

    private class BetaSymbol {
        char character;
        String breathing;
        String accent;
        String iota;
        String diaeresis;
        byte charCase;
        byte wordEnd;
        String numStr;

        public void reset() {
            this.character = (char)32;
            this.breathing = "";
            this.accent = "";
            this.iota = "";
            this.diaeresis = "";
            this.charCase = 0;
            this.wordEnd = 0;
            this.numStr = "0";
        }

        public BetaSymbol() {
            this.reset();
        }

        public void setCharacter(char c) {
            this.character = c;
        }

        public char getCharacter() {
            return this.character;
        }

        public void setBreathing(char c) {
            this.breathing = String.valueOf(c);
        }

        public String getBreathing() {
            return this.breathing;
        }

        public void setAccent(char c) {
            this.accent = String.valueOf(c);
        }

        public String getAccent() {
            return this.accent;
        }

        public void setIota(char c) {
            this.iota = String.valueOf(c);
        }

        public String getIota() {
            return this.iota;
        }

        public void setDiaeresis(char c) {
            this.diaeresis = String.valueOf(c);
        }

        public String getDiaeresis() {
            return this.diaeresis;
        }

        public void setCase(byte by) {
            this.charCase = by;
        }

        public byte getCase() {
            return this.charCase;
        }

        public void setWordEnd(byte by) {
            this.wordEnd = by;
        }

        public byte getWordEnd() {
            return this.wordEnd;
        }

        public void setNumStr(String string) {
            this.numStr = string;
        }

        public void appNumStr(String string) {
            this.numStr = this.numStr + string;
        }

        public void setNum(int n) {
            this.numStr = String.valueOf(n);
        }

        public int getNum() {
            return Integer.parseInt(this.numStr);
        }
    }
}

