/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.AsciiToBetacode;
import greekconverter.BetacodeToSPIonic;
import greekconverter.BetacodeToUnicode;
import greekconverter.BibleWorksToBetacode;
import greekconverter.BibleWorksToUnicode;
import greekconverter.GreekKeysToUnicode;
import greekconverter.MessageHandler;
import greekconverter.UnicodeDecompose;
import greekconverter.UnicodePrecompose;
import greekconverter.UnicodeToAscii;
import greekconverter.UnicodeToBetacode;
import greekconverter.UnicodeToGreekKeys;
import greekconverter.UnicodeToHtml;
import greekconverter.UnicodeToName;

public class GreekConverter {
    private String lastErrMsg;
    private AsciiToBetacode ascii2Beta = new AsciiToBetacode();
    private BetacodeToUnicode beta2Uni = new BetacodeToUnicode();
    private BibleWorksToBetacode bw2Beta = new BibleWorksToBetacode();
    private UnicodeToAscii uni2Ascii = new UnicodeToAscii();

    public static String getClassInfo(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "23-Jun-2004";
                break;
            }
            case 1: {
                string = "Wrapper class for the conversion classes";
                break;
            }
            case 2: {
                string = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                string = "Ut desint vires, tamen est laudanda voluntas.";
            }
        }
        return string;
    }

    public void printMessageQueue(String string, String string2) {
        MessageHandler.printMsgQueue(string, string2);
    }

    public void setMessageLevel(int n) {
        MessageHandler.setMsgLevel(n);
        MessageHandler.enqueueMsg("MessageLevel set to " + n, 20);
    }

    public int getMessageLevel() {
        return MessageHandler.getMsgLevel();
    }

    public String decomposeUnicode(String string) {
        return UnicodeDecompose.normalizeString(string);
    }

    public String precomposeUnicode(String string) {
        return UnicodePrecompose.precomposeStringFirstPass(string);
    }

    public String convertStringUniToBeta(String string) {
        return UnicodeToBetacode.convertString(string);
    }

    public String convertStringUniToAscii(String string) {
        return this.uni2Ascii.convertString(string);
    }

    public String convertStringUniToHtml(String string) {
        return UnicodeToHtml.convertString(string);
    }

    public void setHTMLMode(int n) {
        UnicodeToHtml.setMode(n);
    }

    public short[] convertStringUniToGreekKeys(String string) {
        return UnicodeToGreekKeys.convertString(string);
    }

    public String convertStringGreekKeysToUni(short[] sArray) {
        return GreekKeysToUnicode.convertString(sArray);
    }

    public String convertStringBwToBeta(String string) {
        return this.bw2Beta.convertString(string);
    }

    public String convertStringBwToUni(String string) {
        return BibleWorksToUnicode.convertString(string);
    }

    public String convertStringBetaToUni(String string) {
        return this.beta2Uni.convertString(string);
    }

    public String convertStringBetaToSp(String string) {
        return BetacodeToSPIonic.convertString(string);
    }

    public String convertStringAsciiToBeta(String string) {
        return this.ascii2Beta.convertString(string);
    }

    public String convertStringUniToName(String string) {
        return UnicodeToName.convertString(string);
    }
}

