/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;

public class UnicodeToBetacode {
    private static final int currLang = 1;
    private static final String NOT_SUPPORTED = new String("[1?]");
    private static final String NOT_ASSIGNED = new String("[2?]");
    private static final String[][] tblLookup = new String[256][];
    private static final String[] tblLatin1 = new String[256];
    private static final String[] tblModif = new String[256];
    private static final String[] tblDiacritGreek = new String[256];
    private static final String[] tblGreekExtended = new String[256];
    private static final String[] tblPunct = new String[256];
    private static final String[] tblNotSupported = new String[256];

    public static String getClassInfo(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "16-Sep-2002";
                break;
            }
            case 1: {
                string = "Converts precomposed Unicode into Betacode";
                break;
            }
            case 2: {
                string = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                string = "Vis consili expers mole ruit sua.";
            }
        }
        return string;
    }

    public static final String convertString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 50);
        MessageHandler.clearMsgQueue();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(UnicodeToBetacode.convertChar(string.charAt(n2)));
            MessageHandler.enqueueMsg(" at pos. " + String.valueOf(n2 + 1) + "\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    static final String convertChar(char c) {
        int n = c >> 8;
        String string = tblLookup[n][c & 0xFF];
        if (string == NOT_SUPPORTED || string == NOT_ASSIGNED) {
            return "U+" + Integer.toHexString(c) + string;
        }
        return string;
    }

    static {
        int n = 0;
        while (n < 256) {
            UnicodeToBetacode.tblLookup[n] = tblNotSupported;
            UnicodeToBetacode.tblNotSupported[n] = NOT_SUPPORTED;
            UnicodeToBetacode.tblLatin1[n] = String.valueOf((char)n);
            UnicodeToBetacode.tblModif[n] = NOT_SUPPORTED;
            UnicodeToBetacode.tblDiacritGreek[n] = NOT_ASSIGNED;
            UnicodeToBetacode.tblGreekExtended[n] = NOT_ASSIGNED;
            UnicodeToBetacode.tblPunct[n] = NOT_SUPPORTED;
            ++n;
        }
        UnicodeToBetacode.tblLookup[0] = tblLatin1;
        UnicodeToBetacode.tblLookup[2] = tblModif;
        UnicodeToBetacode.tblLookup[3] = tblDiacritGreek;
        UnicodeToBetacode.tblLookup[31] = tblGreekExtended;
        UnicodeToBetacode.tblLookup[32] = tblPunct;
        UnicodeToBetacode.tblLatin1[33] = "%4";
        UnicodeToBetacode.tblLatin1[34] = "\"";
        UnicodeToBetacode.tblLatin1[35] = "%101";
        UnicodeToBetacode.tblLatin1[36] = "#1219";
        UnicodeToBetacode.tblLatin1[37] = "%8";
        UnicodeToBetacode.tblLatin1[38] = "%9";
        UnicodeToBetacode.tblLatin1[39] = "'";
        UnicodeToBetacode.tblLatin1[40] = "[1";
        UnicodeToBetacode.tblLatin1[41] = "]1";
        UnicodeToBetacode.tblLatin1[42] = "%2";
        UnicodeToBetacode.tblLatin1[43] = "%7";
        UnicodeToBetacode.tblLatin1[44] = ",";
        UnicodeToBetacode.tblLatin1[45] = "-";
        UnicodeToBetacode.tblLatin1[46] = ".";
        UnicodeToBetacode.tblLatin1[47] = "%3";
        UnicodeToBetacode.tblLatin1[58] = ":";
        UnicodeToBetacode.tblLatin1[59] = ";";
        UnicodeToBetacode.tblLatin1[60] = "[2";
        UnicodeToBetacode.tblLatin1[61] = "%6";
        UnicodeToBetacode.tblLatin1[62] = "]2";
        UnicodeToBetacode.tblLatin1[63] = "%1";
        UnicodeToBetacode.tblLatin1[64] = "1220";
        UnicodeToBetacode.tblLatin1[91] = "[";
        UnicodeToBetacode.tblLatin1[92] = "%103";
        UnicodeToBetacode.tblLatin1[93] = "]";
        UnicodeToBetacode.tblLatin1[94] = "%34";
        UnicodeToBetacode.tblLatin1[95] = "_";
        UnicodeToBetacode.tblLatin1[96] = "%33";
        UnicodeToBetacode.tblLatin1[123] = "[3";
        UnicodeToBetacode.tblLatin1[124] = "%5";
        UnicodeToBetacode.tblLatin1[125] = "]3";
        UnicodeToBetacode.tblLatin1[126] = "%107";
        UnicodeToBetacode.tblLatin1[160] = " ";
        UnicodeToBetacode.tblLatin1[161] = "%1";
        UnicodeToBetacode.tblLatin1[162] = "#1200";
        UnicodeToBetacode.tblLatin1[163] = "#1202";
        UnicodeToBetacode.tblLatin1[164] = "%1";
        UnicodeToBetacode.tblLatin1[165] = "%1";
        UnicodeToBetacode.tblLatin1[166] = "%16";
        UnicodeToBetacode.tblLatin1[167] = "%14";
        UnicodeToBetacode.tblLatin1[168] = "%39";
        UnicodeToBetacode.tblLatin1[169] = "#1225";
        UnicodeToBetacode.tblLatin1[170] = "&4a&";
        UnicodeToBetacode.tblLatin1[171] = "\"6";
        UnicodeToBetacode.tblLatin1[172] = "%1";
        UnicodeToBetacode.tblLatin1[173] = "-";
        UnicodeToBetacode.tblLatin1[174] = "%1";
        UnicodeToBetacode.tblLatin1[175] = "%41";
        UnicodeToBetacode.tblLatin1[176] = "#1204";
        UnicodeToBetacode.tblLatin1[177] = "%108";
        UnicodeToBetacode.tblLatin1[178] = "&4\u00912&";
        UnicodeToBetacode.tblLatin1[179] = "&4\u00913&";
        UnicodeToBetacode.tblLatin1[180] = "%32";
        UnicodeToBetacode.tblLatin1[181] = "$M&";
        UnicodeToBetacode.tblLatin1[182] = "%163";
        UnicodeToBetacode.tblLatin1[183] = ":";
        UnicodeToBetacode.tblLatin1[184] = NOT_SUPPORTED;
        UnicodeToBetacode.tblLatin1[185] = "&4\u00911&";
        UnicodeToBetacode.tblLatin1[186] = "&4o&";
        UnicodeToBetacode.tblLatin1[187] = "\"6";
        UnicodeToBetacode.tblLatin1[188] = "&19\u00911/4&";
        UnicodeToBetacode.tblLatin1[189] = "&19\u00911/2&";
        UnicodeToBetacode.tblLatin1[190] = "&19\u00913/4&";
        UnicodeToBetacode.tblLatin1[191] = "%1";
        UnicodeToBetacode.tblLatin1[192] = "A\\";
        UnicodeToBetacode.tblLatin1[193] = "A/";
        UnicodeToBetacode.tblLatin1[194] = "A=";
        UnicodeToBetacode.tblLatin1[195] = "A%24";
        UnicodeToBetacode.tblLatin1[196] = "A+";
        UnicodeToBetacode.tblLatin1[197] = "A%147";
        UnicodeToBetacode.tblLatin1[198] = "#1215";
        UnicodeToBetacode.tblLatin1[199] = "C%25";
        UnicodeToBetacode.tblLatin1[200] = "E\\";
        UnicodeToBetacode.tblLatin1[201] = "E/";
        UnicodeToBetacode.tblLatin1[202] = "E=";
        UnicodeToBetacode.tblLatin1[203] = "E+";
        UnicodeToBetacode.tblLatin1[204] = "I\\";
        UnicodeToBetacode.tblLatin1[205] = "I/";
        UnicodeToBetacode.tblLatin1[206] = "I=";
        UnicodeToBetacode.tblLatin1[207] = "I+";
        UnicodeToBetacode.tblLatin1[208] = "#1212";
        UnicodeToBetacode.tblLatin1[209] = "N%24";
        UnicodeToBetacode.tblLatin1[210] = "O\\";
        UnicodeToBetacode.tblLatin1[211] = "O/";
        UnicodeToBetacode.tblLatin1[212] = "O=";
        UnicodeToBetacode.tblLatin1[213] = "O%24";
        UnicodeToBetacode.tblLatin1[214] = "O+";
        UnicodeToBetacode.tblLatin1[215] = "%159";
        UnicodeToBetacode.tblLatin1[216] = "O%162";
        UnicodeToBetacode.tblLatin1[217] = "U\\";
        UnicodeToBetacode.tblLatin1[218] = "U/";
        UnicodeToBetacode.tblLatin1[219] = "U=";
        UnicodeToBetacode.tblLatin1[220] = "U+";
        UnicodeToBetacode.tblLatin1[221] = "Y/";
        UnicodeToBetacode.tblLatin1[222] = "%1";
        UnicodeToBetacode.tblLatin1[223] = "#1203";
        UnicodeToBetacode.tblLatin1[224] = "a\\";
        UnicodeToBetacode.tblLatin1[225] = "a/";
        UnicodeToBetacode.tblLatin1[226] = "a=";
        UnicodeToBetacode.tblLatin1[227] = "a%24";
        UnicodeToBetacode.tblLatin1[228] = "a+";
        UnicodeToBetacode.tblLatin1[229] = "a%147";
        UnicodeToBetacode.tblLatin1[230] = "#1216";
        UnicodeToBetacode.tblLatin1[231] = "c%25";
        UnicodeToBetacode.tblLatin1[232] = "e\\";
        UnicodeToBetacode.tblLatin1[233] = "e/";
        UnicodeToBetacode.tblLatin1[234] = "e=";
        UnicodeToBetacode.tblLatin1[235] = "e+";
        UnicodeToBetacode.tblLatin1[236] = "i\\";
        UnicodeToBetacode.tblLatin1[237] = "i/";
        UnicodeToBetacode.tblLatin1[238] = "i=";
        UnicodeToBetacode.tblLatin1[239] = "i+";
        UnicodeToBetacode.tblLatin1[240] = "%1";
        UnicodeToBetacode.tblLatin1[241] = "n%24";
        UnicodeToBetacode.tblLatin1[242] = "o\\";
        UnicodeToBetacode.tblLatin1[243] = "o/";
        UnicodeToBetacode.tblLatin1[244] = "o=";
        UnicodeToBetacode.tblLatin1[245] = "o%24";
        UnicodeToBetacode.tblLatin1[246] = "o+";
        UnicodeToBetacode.tblLatin1[247] = "%161";
        UnicodeToBetacode.tblLatin1[248] = "o%162";
        UnicodeToBetacode.tblLatin1[249] = "u\\";
        UnicodeToBetacode.tblLatin1[250] = "u/";
        UnicodeToBetacode.tblLatin1[251] = "u=";
        UnicodeToBetacode.tblLatin1[252] = "u+";
        UnicodeToBetacode.tblLatin1[253] = "y/";
        UnicodeToBetacode.tblLatin1[254] = "%1";
        UnicodeToBetacode.tblLatin1[255] = "y+";
        UnicodeToBetacode.tblModif[185] = "#";
        UnicodeToBetacode.tblModif[186] = "##";
        UnicodeToBetacode.tblModif[188] = "%30";
        UnicodeToBetacode.tblModif[189] = "%31";
        UnicodeToBetacode.tblModif[198] = tblLatin1[94];
        UnicodeToBetacode.tblModif[201] = tblLatin1[175];
        UnicodeToBetacode.tblModif[202] = tblLatin1[180];
        UnicodeToBetacode.tblModif[203] = tblLatin1[96];
        UnicodeToBetacode.tblModif[216] = "%40";
        UnicodeToBetacode.tblModif[220] = tblLatin1[126];
        UnicodeToBetacode.tblDiacritGreek[0] = "\\";
        UnicodeToBetacode.tblDiacritGreek[1] = "/";
        UnicodeToBetacode.tblDiacritGreek[2] = "=";
        UnicodeToBetacode.tblDiacritGreek[3] = "%24";
        UnicodeToBetacode.tblDiacritGreek[4] = "%26";
        UnicodeToBetacode.tblDiacritGreek[6] = "%27";
        UnicodeToBetacode.tblDiacritGreek[7] = "%94";
        UnicodeToBetacode.tblDiacritGreek[8] = "+";
        UnicodeToBetacode.tblDiacritGreek[10] = "%147";
        UnicodeToBetacode.tblDiacritGreek[12] = "%148";
        UnicodeToBetacode.tblDiacritGreek[17] = "#534";
        UnicodeToBetacode.tblDiacritGreek[18] = "%25";
        UnicodeToBetacode.tblDiacritGreek[19] = ")";
        UnicodeToBetacode.tblDiacritGreek[20] = "(";
        UnicodeToBetacode.tblDiacritGreek[35] = "?";
        UnicodeToBetacode.tblDiacritGreek[39] = "%25";
        UnicodeToBetacode.tblDiacritGreek[40] = "%149";
        UnicodeToBetacode.tblDiacritGreek[47] = "%127";
        UnicodeToBetacode.tblDiacritGreek[55] = "%162";
        UnicodeToBetacode.tblDiacritGreek[56] = "%162";
        UnicodeToBetacode.tblDiacritGreek[66] = "=";
        UnicodeToBetacode.tblDiacritGreek[67] = ")";
        UnicodeToBetacode.tblDiacritGreek[68] = "/+";
        UnicodeToBetacode.tblDiacritGreek[69] = "|";
        UnicodeToBetacode.tblDiacritGreek[116] = tblModif[185];
        UnicodeToBetacode.tblDiacritGreek[117] = "#22";
        UnicodeToBetacode.tblDiacritGreek[122] = "`|";
        UnicodeToBetacode.tblDiacritGreek[126] = ";";
        UnicodeToBetacode.tblDiacritGreek[132] = "%32";
        UnicodeToBetacode.tblDiacritGreek[133] = "%132";
        UnicodeToBetacode.tblDiacritGreek[134] = "*/A";
        UnicodeToBetacode.tblDiacritGreek[135] = ":";
        UnicodeToBetacode.tblDiacritGreek[136] = "*/E";
        UnicodeToBetacode.tblDiacritGreek[137] = "*/H";
        UnicodeToBetacode.tblDiacritGreek[138] = "*/I";
        UnicodeToBetacode.tblDiacritGreek[140] = "*/O";
        UnicodeToBetacode.tblDiacritGreek[142] = "*/U";
        UnicodeToBetacode.tblDiacritGreek[143] = "*/W";
        UnicodeToBetacode.tblDiacritGreek[144] = "I/+";
        UnicodeToBetacode.tblDiacritGreek[145] = "*A";
        UnicodeToBetacode.tblDiacritGreek[146] = "*B";
        UnicodeToBetacode.tblDiacritGreek[147] = "*G";
        UnicodeToBetacode.tblDiacritGreek[148] = "*D";
        UnicodeToBetacode.tblDiacritGreek[149] = "*E";
        UnicodeToBetacode.tblDiacritGreek[150] = "*Z";
        UnicodeToBetacode.tblDiacritGreek[151] = "*H";
        UnicodeToBetacode.tblDiacritGreek[152] = "*Q";
        UnicodeToBetacode.tblDiacritGreek[153] = "*I";
        UnicodeToBetacode.tblDiacritGreek[154] = "*K";
        UnicodeToBetacode.tblDiacritGreek[155] = "*L";
        UnicodeToBetacode.tblDiacritGreek[156] = "*M";
        UnicodeToBetacode.tblDiacritGreek[157] = "*N";
        UnicodeToBetacode.tblDiacritGreek[158] = "*C";
        UnicodeToBetacode.tblDiacritGreek[159] = "*O";
        UnicodeToBetacode.tblDiacritGreek[160] = "*P";
        UnicodeToBetacode.tblDiacritGreek[161] = "*R";
        UnicodeToBetacode.tblDiacritGreek[163] = "*S";
        UnicodeToBetacode.tblDiacritGreek[164] = "*T";
        UnicodeToBetacode.tblDiacritGreek[165] = "*U";
        UnicodeToBetacode.tblDiacritGreek[166] = "*F";
        UnicodeToBetacode.tblDiacritGreek[167] = "*X";
        UnicodeToBetacode.tblDiacritGreek[168] = "*Y";
        UnicodeToBetacode.tblDiacritGreek[169] = "*W";
        UnicodeToBetacode.tblDiacritGreek[170] = "*I+";
        UnicodeToBetacode.tblDiacritGreek[171] = "*U+";
        UnicodeToBetacode.tblDiacritGreek[172] = "A/";
        UnicodeToBetacode.tblDiacritGreek[173] = "E/";
        UnicodeToBetacode.tblDiacritGreek[174] = "H/";
        UnicodeToBetacode.tblDiacritGreek[175] = "I/";
        UnicodeToBetacode.tblDiacritGreek[176] = "U/+";
        UnicodeToBetacode.tblDiacritGreek[177] = "A";
        UnicodeToBetacode.tblDiacritGreek[178] = "B";
        UnicodeToBetacode.tblDiacritGreek[179] = "G";
        UnicodeToBetacode.tblDiacritGreek[180] = "D";
        UnicodeToBetacode.tblDiacritGreek[181] = "E";
        UnicodeToBetacode.tblDiacritGreek[182] = "Z";
        UnicodeToBetacode.tblDiacritGreek[183] = "H";
        UnicodeToBetacode.tblDiacritGreek[184] = "Q";
        UnicodeToBetacode.tblDiacritGreek[185] = "I";
        UnicodeToBetacode.tblDiacritGreek[186] = "K";
        UnicodeToBetacode.tblDiacritGreek[187] = "L";
        UnicodeToBetacode.tblDiacritGreek[188] = "M";
        UnicodeToBetacode.tblDiacritGreek[189] = "N";
        UnicodeToBetacode.tblDiacritGreek[190] = "C";
        UnicodeToBetacode.tblDiacritGreek[191] = "O";
        UnicodeToBetacode.tblDiacritGreek[192] = "P";
        UnicodeToBetacode.tblDiacritGreek[193] = "R";
        UnicodeToBetacode.tblDiacritGreek[194] = "J";
        UnicodeToBetacode.tblDiacritGreek[195] = "S";
        UnicodeToBetacode.tblDiacritGreek[196] = "T";
        UnicodeToBetacode.tblDiacritGreek[197] = "U";
        UnicodeToBetacode.tblDiacritGreek[198] = "F";
        UnicodeToBetacode.tblDiacritGreek[199] = "X";
        UnicodeToBetacode.tblDiacritGreek[200] = "Y";
        UnicodeToBetacode.tblDiacritGreek[201] = "W";
        UnicodeToBetacode.tblDiacritGreek[202] = "I+";
        UnicodeToBetacode.tblDiacritGreek[203] = "U+";
        UnicodeToBetacode.tblDiacritGreek[204] = "O/";
        UnicodeToBetacode.tblDiacritGreek[205] = "U/";
        UnicodeToBetacode.tblDiacritGreek[206] = "W/";
        UnicodeToBetacode.tblDiacritGreek[208] = "B";
        UnicodeToBetacode.tblDiacritGreek[209] = "Q";
        UnicodeToBetacode.tblDiacritGreek[210] = "*Y";
        UnicodeToBetacode.tblDiacritGreek[211] = "*/Y";
        UnicodeToBetacode.tblDiacritGreek[212] = "*Y+";
        UnicodeToBetacode.tblDiacritGreek[213] = "F";
        UnicodeToBetacode.tblDiacritGreek[214] = "P";
        UnicodeToBetacode.tblDiacritGreek[215] = "K'";
        UnicodeToBetacode.tblDiacritGreek[218] = "#2";
        UnicodeToBetacode.tblDiacritGreek[219] = "#2";
        UnicodeToBetacode.tblDiacritGreek[220] = "*V";
        UnicodeToBetacode.tblDiacritGreek[221] = "V";
        UnicodeToBetacode.tblDiacritGreek[222] = "#3";
        UnicodeToBetacode.tblDiacritGreek[223] = "#3";
        UnicodeToBetacode.tblDiacritGreek[224] = "#5";
        UnicodeToBetacode.tblDiacritGreek[225] = "#5";
        UnicodeToBetacode.tblDiacritGreek[240] = "K";
        UnicodeToBetacode.tblDiacritGreek[241] = "R";
        UnicodeToBetacode.tblDiacritGreek[242] = "S3";
        UnicodeToBetacode.tblDiacritGreek[243] = "j";
        UnicodeToBetacode.tblDiacritGreek[244] = "*Q";
        UnicodeToBetacode.tblDiacritGreek[245] = "E";
        UnicodeToBetacode.tblGreekExtended[0] = "A)";
        UnicodeToBetacode.tblGreekExtended[1] = "A(";
        UnicodeToBetacode.tblGreekExtended[2] = "A)\\";
        UnicodeToBetacode.tblGreekExtended[3] = "A(\\";
        UnicodeToBetacode.tblGreekExtended[4] = "A)/";
        UnicodeToBetacode.tblGreekExtended[5] = "A(/";
        UnicodeToBetacode.tblGreekExtended[6] = "A)=";
        UnicodeToBetacode.tblGreekExtended[7] = "A(=";
        UnicodeToBetacode.tblGreekExtended[8] = "*)A";
        UnicodeToBetacode.tblGreekExtended[9] = "*(A";
        UnicodeToBetacode.tblGreekExtended[10] = "*)\\A";
        UnicodeToBetacode.tblGreekExtended[11] = "*(\\A";
        UnicodeToBetacode.tblGreekExtended[12] = "*)/A";
        UnicodeToBetacode.tblGreekExtended[13] = "*(/A";
        UnicodeToBetacode.tblGreekExtended[14] = "*)=A";
        UnicodeToBetacode.tblGreekExtended[15] = "*(=";
        UnicodeToBetacode.tblGreekExtended[16] = "E)";
        UnicodeToBetacode.tblGreekExtended[17] = "E(";
        UnicodeToBetacode.tblGreekExtended[18] = "E)\\";
        UnicodeToBetacode.tblGreekExtended[19] = "E(\\";
        UnicodeToBetacode.tblGreekExtended[20] = "E)/";
        UnicodeToBetacode.tblGreekExtended[21] = "E(/";
        UnicodeToBetacode.tblGreekExtended[24] = "*)E";
        UnicodeToBetacode.tblGreekExtended[25] = "*(E";
        UnicodeToBetacode.tblGreekExtended[26] = "*)\\E";
        UnicodeToBetacode.tblGreekExtended[27] = "*(\\E";
        UnicodeToBetacode.tblGreekExtended[28] = "*)/E";
        UnicodeToBetacode.tblGreekExtended[29] = "*(/E";
        UnicodeToBetacode.tblGreekExtended[32] = "H)";
        UnicodeToBetacode.tblGreekExtended[33] = "H(";
        UnicodeToBetacode.tblGreekExtended[34] = "H)\\";
        UnicodeToBetacode.tblGreekExtended[35] = "H(\\";
        UnicodeToBetacode.tblGreekExtended[36] = "H)/";
        UnicodeToBetacode.tblGreekExtended[37] = "H(/";
        UnicodeToBetacode.tblGreekExtended[38] = "H)=";
        UnicodeToBetacode.tblGreekExtended[39] = "H(=";
        UnicodeToBetacode.tblGreekExtended[40] = "*)H";
        UnicodeToBetacode.tblGreekExtended[41] = "*(H";
        UnicodeToBetacode.tblGreekExtended[42] = "*)\\H";
        UnicodeToBetacode.tblGreekExtended[43] = "*(\\H";
        UnicodeToBetacode.tblGreekExtended[44] = "*)/H";
        UnicodeToBetacode.tblGreekExtended[45] = "*(/H";
        UnicodeToBetacode.tblGreekExtended[46] = "*)=H";
        UnicodeToBetacode.tblGreekExtended[47] = "*(=H";
        UnicodeToBetacode.tblGreekExtended[48] = "I)";
        UnicodeToBetacode.tblGreekExtended[49] = "I(";
        UnicodeToBetacode.tblGreekExtended[50] = "I)\\";
        UnicodeToBetacode.tblGreekExtended[51] = "I(\\";
        UnicodeToBetacode.tblGreekExtended[52] = "I)/";
        UnicodeToBetacode.tblGreekExtended[53] = "I(/";
        UnicodeToBetacode.tblGreekExtended[54] = "I)=";
        UnicodeToBetacode.tblGreekExtended[55] = "I(=";
        UnicodeToBetacode.tblGreekExtended[56] = "*)I";
        UnicodeToBetacode.tblGreekExtended[57] = "*(I";
        UnicodeToBetacode.tblGreekExtended[58] = "*)\\I";
        UnicodeToBetacode.tblGreekExtended[59] = "*(\\I";
        UnicodeToBetacode.tblGreekExtended[60] = "*)/I";
        UnicodeToBetacode.tblGreekExtended[61] = "*(/I";
        UnicodeToBetacode.tblGreekExtended[62] = "*)=I";
        UnicodeToBetacode.tblGreekExtended[63] = "*(=I";
        UnicodeToBetacode.tblGreekExtended[64] = "O)";
        UnicodeToBetacode.tblGreekExtended[65] = "O(";
        UnicodeToBetacode.tblGreekExtended[66] = "O)\\";
        UnicodeToBetacode.tblGreekExtended[67] = "O(\\";
        UnicodeToBetacode.tblGreekExtended[68] = "O)/";
        UnicodeToBetacode.tblGreekExtended[69] = "O(/";
        UnicodeToBetacode.tblGreekExtended[72] = "*)O";
        UnicodeToBetacode.tblGreekExtended[73] = "*(O";
        UnicodeToBetacode.tblGreekExtended[74] = "*)\\O";
        UnicodeToBetacode.tblGreekExtended[75] = "*(\\O";
        UnicodeToBetacode.tblGreekExtended[76] = "*)/O";
        UnicodeToBetacode.tblGreekExtended[77] = "*(/O";
        UnicodeToBetacode.tblGreekExtended[80] = "U)";
        UnicodeToBetacode.tblGreekExtended[81] = "U(";
        UnicodeToBetacode.tblGreekExtended[82] = "U)\\";
        UnicodeToBetacode.tblGreekExtended[83] = "U(\\";
        UnicodeToBetacode.tblGreekExtended[84] = "U)/";
        UnicodeToBetacode.tblGreekExtended[85] = "U(/";
        UnicodeToBetacode.tblGreekExtended[86] = "U)=";
        UnicodeToBetacode.tblGreekExtended[87] = "U(=";
        UnicodeToBetacode.tblGreekExtended[89] = "*(U";
        UnicodeToBetacode.tblGreekExtended[91] = "*(\\U";
        UnicodeToBetacode.tblGreekExtended[93] = "*(/U";
        UnicodeToBetacode.tblGreekExtended[95] = "*(=U";
        UnicodeToBetacode.tblGreekExtended[96] = "W)";
        UnicodeToBetacode.tblGreekExtended[97] = "W(";
        UnicodeToBetacode.tblGreekExtended[98] = "W)\\";
        UnicodeToBetacode.tblGreekExtended[99] = "W(\\";
        UnicodeToBetacode.tblGreekExtended[100] = "W)/";
        UnicodeToBetacode.tblGreekExtended[101] = "W(/";
        UnicodeToBetacode.tblGreekExtended[102] = "W)=";
        UnicodeToBetacode.tblGreekExtended[103] = "W(=";
        UnicodeToBetacode.tblGreekExtended[104] = "*)W";
        UnicodeToBetacode.tblGreekExtended[105] = "*(W";
        UnicodeToBetacode.tblGreekExtended[106] = "*)\\W";
        UnicodeToBetacode.tblGreekExtended[107] = "*(\\W";
        UnicodeToBetacode.tblGreekExtended[108] = "*)/W";
        UnicodeToBetacode.tblGreekExtended[109] = "*(/W";
        UnicodeToBetacode.tblGreekExtended[110] = "*)=W";
        UnicodeToBetacode.tblGreekExtended[111] = "*(=W";
        UnicodeToBetacode.tblGreekExtended[112] = "A\\";
        UnicodeToBetacode.tblGreekExtended[113] = "A/";
        UnicodeToBetacode.tblGreekExtended[114] = "E\\";
        UnicodeToBetacode.tblGreekExtended[115] = "E/";
        UnicodeToBetacode.tblGreekExtended[116] = "H\\";
        UnicodeToBetacode.tblGreekExtended[117] = "H/";
        UnicodeToBetacode.tblGreekExtended[118] = "I\\";
        UnicodeToBetacode.tblGreekExtended[119] = "I/";
        UnicodeToBetacode.tblGreekExtended[120] = "O\\";
        UnicodeToBetacode.tblGreekExtended[121] = "O/";
        UnicodeToBetacode.tblGreekExtended[122] = "U\\";
        UnicodeToBetacode.tblGreekExtended[123] = "U/";
        UnicodeToBetacode.tblGreekExtended[124] = "W\\";
        UnicodeToBetacode.tblGreekExtended[125] = "W/";
        UnicodeToBetacode.tblGreekExtended[128] = "A)|";
        UnicodeToBetacode.tblGreekExtended[129] = "A(|";
        UnicodeToBetacode.tblGreekExtended[130] = "A)\\|";
        UnicodeToBetacode.tblGreekExtended[131] = "A(\\|";
        UnicodeToBetacode.tblGreekExtended[132] = "A)/|";
        UnicodeToBetacode.tblGreekExtended[133] = "A(/|";
        UnicodeToBetacode.tblGreekExtended[134] = "A)=|";
        UnicodeToBetacode.tblGreekExtended[135] = "A(=|";
        UnicodeToBetacode.tblGreekExtended[136] = "*)A|";
        UnicodeToBetacode.tblGreekExtended[137] = "*(A|";
        UnicodeToBetacode.tblGreekExtended[138] = "*)\\A|";
        UnicodeToBetacode.tblGreekExtended[139] = "*(\\A|";
        UnicodeToBetacode.tblGreekExtended[140] = "*)/A|";
        UnicodeToBetacode.tblGreekExtended[141] = "*(/A|";
        UnicodeToBetacode.tblGreekExtended[142] = "*)=A|";
        UnicodeToBetacode.tblGreekExtended[143] = "*(=A|";
        UnicodeToBetacode.tblGreekExtended[144] = "H)|";
        UnicodeToBetacode.tblGreekExtended[145] = "H(|";
        UnicodeToBetacode.tblGreekExtended[146] = "H)\\|";
        UnicodeToBetacode.tblGreekExtended[147] = "H(\\|";
        UnicodeToBetacode.tblGreekExtended[148] = "H)/|";
        UnicodeToBetacode.tblGreekExtended[149] = "H(/|";
        UnicodeToBetacode.tblGreekExtended[150] = "H)=|";
        UnicodeToBetacode.tblGreekExtended[151] = "H(=|";
        UnicodeToBetacode.tblGreekExtended[152] = "*)H|";
        UnicodeToBetacode.tblGreekExtended[153] = "*(H|";
        UnicodeToBetacode.tblGreekExtended[154] = "*)\\H|";
        UnicodeToBetacode.tblGreekExtended[155] = "*(\\H|";
        UnicodeToBetacode.tblGreekExtended[156] = "*)/H|";
        UnicodeToBetacode.tblGreekExtended[157] = "*(/H|";
        UnicodeToBetacode.tblGreekExtended[158] = "*)=H|";
        UnicodeToBetacode.tblGreekExtended[159] = "*(=H|";
        UnicodeToBetacode.tblGreekExtended[160] = "W)|";
        UnicodeToBetacode.tblGreekExtended[161] = "W(|";
        UnicodeToBetacode.tblGreekExtended[162] = "W)\\|";
        UnicodeToBetacode.tblGreekExtended[163] = "W(\\|";
        UnicodeToBetacode.tblGreekExtended[164] = "W)/|";
        UnicodeToBetacode.tblGreekExtended[165] = "W(/|";
        UnicodeToBetacode.tblGreekExtended[166] = "W)=|";
        UnicodeToBetacode.tblGreekExtended[167] = "W(=|";
        UnicodeToBetacode.tblGreekExtended[168] = "*)W|";
        UnicodeToBetacode.tblGreekExtended[169] = "*(W|";
        UnicodeToBetacode.tblGreekExtended[170] = "*)\\W|";
        UnicodeToBetacode.tblGreekExtended[171] = "*(\\W|";
        UnicodeToBetacode.tblGreekExtended[172] = "*)/W|";
        UnicodeToBetacode.tblGreekExtended[173] = "*(/W|";
        UnicodeToBetacode.tblGreekExtended[174] = "*)=W|";
        UnicodeToBetacode.tblGreekExtended[175] = "*(=W|";
        UnicodeToBetacode.tblGreekExtended[176] = "A%27";
        UnicodeToBetacode.tblGreekExtended[177] = "A%26";
        UnicodeToBetacode.tblGreekExtended[178] = "A\\|";
        UnicodeToBetacode.tblGreekExtended[179] = "A|";
        UnicodeToBetacode.tblGreekExtended[180] = "A/|";
        UnicodeToBetacode.tblGreekExtended[182] = "A=";
        UnicodeToBetacode.tblGreekExtended[183] = "A=|";
        UnicodeToBetacode.tblGreekExtended[184] = "*A%27";
        UnicodeToBetacode.tblGreekExtended[185] = "*A%26";
        UnicodeToBetacode.tblGreekExtended[186] = "*\\A";
        UnicodeToBetacode.tblGreekExtended[187] = "*/A";
        UnicodeToBetacode.tblGreekExtended[188] = "*A|";
        UnicodeToBetacode.tblGreekExtended[189] = "%30";
        UnicodeToBetacode.tblGreekExtended[190] = "I";
        UnicodeToBetacode.tblGreekExtended[191] = "%30";
        UnicodeToBetacode.tblGreekExtended[192] = "%34";
        UnicodeToBetacode.tblGreekExtended[193] = " =+ ";
        UnicodeToBetacode.tblGreekExtended[194] = "H\\|";
        UnicodeToBetacode.tblGreekExtended[195] = "H|";
        UnicodeToBetacode.tblGreekExtended[196] = "H/|";
        UnicodeToBetacode.tblGreekExtended[198] = "H=";
        UnicodeToBetacode.tblGreekExtended[199] = "H=|";
        UnicodeToBetacode.tblGreekExtended[200] = "*\\E";
        UnicodeToBetacode.tblGreekExtended[201] = "*/E";
        UnicodeToBetacode.tblGreekExtended[202] = "*\\H";
        UnicodeToBetacode.tblGreekExtended[203] = "*/H";
        UnicodeToBetacode.tblGreekExtended[204] = "*H|";
        UnicodeToBetacode.tblGreekExtended[205] = "%133";
        UnicodeToBetacode.tblGreekExtended[206] = "%35";
        UnicodeToBetacode.tblGreekExtended[207] = "%134";
        UnicodeToBetacode.tblGreekExtended[208] = "I%27";
        UnicodeToBetacode.tblGreekExtended[209] = "I%26";
        UnicodeToBetacode.tblGreekExtended[210] = "I\\+";
        UnicodeToBetacode.tblGreekExtended[211] = "I/+";
        UnicodeToBetacode.tblGreekExtended[214] = "I=";
        UnicodeToBetacode.tblGreekExtended[215] = "I=+";
        UnicodeToBetacode.tblGreekExtended[216] = "*I%27";
        UnicodeToBetacode.tblGreekExtended[217] = "*I%26";
        UnicodeToBetacode.tblGreekExtended[218] = "*\\I";
        UnicodeToBetacode.tblGreekExtended[219] = "*/I";
        UnicodeToBetacode.tblGreekExtended[221] = "%37";
        UnicodeToBetacode.tblGreekExtended[222] = "%36";
        UnicodeToBetacode.tblGreekExtended[223] = "%38";
        UnicodeToBetacode.tblGreekExtended[224] = "U%27";
        UnicodeToBetacode.tblGreekExtended[225] = "U%26";
        UnicodeToBetacode.tblGreekExtended[226] = "U\\+";
        UnicodeToBetacode.tblGreekExtended[227] = "U/+";
        UnicodeToBetacode.tblGreekExtended[228] = "R)";
        UnicodeToBetacode.tblGreekExtended[229] = "R(";
        UnicodeToBetacode.tblGreekExtended[230] = "U=";
        UnicodeToBetacode.tblGreekExtended[231] = "U=+";
        UnicodeToBetacode.tblGreekExtended[232] = "*U%27";
        UnicodeToBetacode.tblGreekExtended[233] = "*U%26";
        UnicodeToBetacode.tblGreekExtended[234] = "*\\U";
        UnicodeToBetacode.tblGreekExtended[235] = "*/U";
        UnicodeToBetacode.tblGreekExtended[236] = "*(R";
        UnicodeToBetacode.tblGreekExtended[237] = " \\+ ";
        UnicodeToBetacode.tblGreekExtended[238] = "%132";
        UnicodeToBetacode.tblGreekExtended[239] = "%33";
        UnicodeToBetacode.tblGreekExtended[242] = "W\\|";
        UnicodeToBetacode.tblGreekExtended[243] = "W|";
        UnicodeToBetacode.tblGreekExtended[244] = "W/|";
        UnicodeToBetacode.tblGreekExtended[246] = "W=";
        UnicodeToBetacode.tblGreekExtended[247] = "W=|";
        UnicodeToBetacode.tblGreekExtended[248] = "*\\O";
        UnicodeToBetacode.tblGreekExtended[249] = "*/O";
        UnicodeToBetacode.tblGreekExtended[250] = "*\\W";
        UnicodeToBetacode.tblGreekExtended[251] = "*/W";
        UnicodeToBetacode.tblGreekExtended[252] = "*=W";
        UnicodeToBetacode.tblGreekExtended[253] = "%32";
        UnicodeToBetacode.tblGreekExtended[254] = "%31";
        UnicodeToBetacode.tblPunct[0] = " ";
        UnicodeToBetacode.tblPunct[1] = " ";
        UnicodeToBetacode.tblPunct[2] = " ";
        UnicodeToBetacode.tblPunct[3] = " ";
        UnicodeToBetacode.tblPunct[4] = " ";
        UnicodeToBetacode.tblPunct[5] = " ";
        UnicodeToBetacode.tblPunct[6] = " ";
        UnicodeToBetacode.tblPunct[7] = " ";
        UnicodeToBetacode.tblPunct[8] = " ";
        UnicodeToBetacode.tblPunct[9] = " ";
        UnicodeToBetacode.tblPunct[10] = " ";
        UnicodeToBetacode.tblPunct[11] = "`";
        UnicodeToBetacode.tblPunct[16] = "-";
        UnicodeToBetacode.tblPunct[17] = "-";
        UnicodeToBetacode.tblPunct[18] = "-";
        UnicodeToBetacode.tblPunct[19] = "-";
        UnicodeToBetacode.tblPunct[20] = "--";
        UnicodeToBetacode.tblPunct[21] = "#6";
        UnicodeToBetacode.tblPunct[24] = "\"3";
        UnicodeToBetacode.tblPunct[25] = "\"3";
        UnicodeToBetacode.tblPunct[26] = "\"4";
        UnicodeToBetacode.tblPunct[27] = tblPunct[24];
        UnicodeToBetacode.tblPunct[28] = "\"";
        UnicodeToBetacode.tblPunct[29] = "\"";
        UnicodeToBetacode.tblPunct[30] = "\"1";
        UnicodeToBetacode.tblPunct[31] = tblPunct[28];
        UnicodeToBetacode.tblPunct[32] = "%";
        UnicodeToBetacode.tblPunct[33] = "%13";
        UnicodeToBetacode.tblPunct[36] = ".";
        UnicodeToBetacode.tblPunct[37] = "..";
        UnicodeToBetacode.tblPunct[38] = "...";
        UnicodeToBetacode.tblPunct[39] = ".";
        UnicodeToBetacode.tblPunct[47] = " ";
        UnicodeToBetacode.tblPunct[50] = tblModif[185];
        UnicodeToBetacode.tblPunct[51] = tblModif[186];
        UnicodeToBetacode.tblPunct[56] = "%104";
        UnicodeToBetacode.tblPunct[57] = "\"7";
        UnicodeToBetacode.tblPunct[58] = "\"7";
        UnicodeToBetacode.tblPunct[59] = "#13";
        UnicodeToBetacode.tblPunct[60] = "%4%4";
        UnicodeToBetacode.tblPunct[61] = "%1%4";
        UnicodeToBetacode.tblPunct[66] = "%158";
        UnicodeToBetacode.tblPunct[67] = "-";
        UnicodeToBetacode.tblPunct[68] = "%3";
        UnicodeToBetacode.tblPunct[71] = NOT_ASSIGNED;
        UnicodeToBetacode.tblPunct[72] = "%1%4";
        UnicodeToBetacode.tblPunct[73] = "%4%1";
    }
}

