/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lar;

import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.portletdisplaytemplate.util.PortletDisplayTemplateUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletPreferences;

public abstract class BasePortletDataHandler
implements PortletDataHandler {
    private static Log _log = LogFactoryUtil.getLog(BasePortletDataHandler.class);
    private DataLevel _dataLevel = DataLevel.SITE;
    private boolean _dataLocalized;
    private String[] _dataPortletPreferences = StringPool.EMPTY_ARRAY;
    private StagedModelType[] _deletionSystemEventStagedModelTypes = new StagedModelType[0];
    private PortletDataHandlerControl[] _exportControls = new PortletDataHandlerControl[0];
    private PortletDataHandlerControl[] _exportMetadataControls = new PortletDataHandlerControl[0];
    private PortletDataHandlerControl[] _importControls = new PortletDataHandlerControl[0];
    private PortletDataHandlerControl[] _importMetadataControls = new PortletDataHandlerControl[0];
    private String _portletId;
    private boolean _publishToLiveByDefault;
    private boolean _supportsDataStrategyCopyAsNew = true;

    @Override
    public PortletPreferences deleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        long startTime = 0L;
        if (_log.isInfoEnabled()) {
            _log.info("Deleting portlet " + portletId);
            startTime = System.currentTimeMillis();
        }
        try {
            PortletPreferences portletPreferences2 = this.doDeleteData(portletDataContext, portletId, portletPreferences);
            return portletPreferences2;
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
        finally {
            if (_log.isInfoEnabled()) {
                long duration = System.currentTimeMillis() - startTime;
                _log.info("Deleted portlet in " + Time.getDuration(duration));
            }
        }
    }

    @Override
    public String exportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        long startTime = 0L;
        if (_log.isInfoEnabled()) {
            _log.info("Exporting portlet " + portletId);
            startTime = System.currentTimeMillis();
        }
        try {
            portletDataContext.addDeletionSystemEventStagedModelTypes(this.getDeletionSystemEventStagedModelTypes());
            PortletDataHandlerControl[] portletDataHandlerControlArray = this.getExportControls();
            int n = portletDataHandlerControlArray.length;
            int n2 = 0;
            while (n2 < n) {
                PortletDataHandlerControl portletDataHandlerControl = portletDataHandlerControlArray[n2];
                this.addUncheckedModelAdditionCount(portletDataContext, portletDataHandlerControl);
                ++n2;
            }
            String string = this.doExportData(portletDataContext, portletId, portletPreferences);
            return string;
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
        finally {
            if (_log.isInfoEnabled()) {
                long duration = System.currentTimeMillis() - startTime;
                _log.info("Exported portlet in " + Time.getDuration(duration));
            }
        }
    }

    @Override
    public DataLevel getDataLevel() {
        return this._dataLevel;
    }

    @Override
    public String[] getDataPortletPreferences() {
        return this._dataPortletPreferences;
    }

    @Override
    public StagedModelType[] getDeletionSystemEventStagedModelTypes() {
        return this._deletionSystemEventStagedModelTypes;
    }

    @Override
    public PortletDataHandlerControl[] getExportConfigurationControls(long companyId, long groupId, Portlet portlet, boolean privateLayout) throws Exception {
        return this.getExportConfigurationControls(companyId, groupId, portlet, -1L, privateLayout);
    }

    @Override
    public PortletDataHandlerControl[] getExportConfigurationControls(long companyId, long groupId, Portlet portlet, long plid, boolean privateLayout) throws Exception {
        ArrayList<PortletDataHandlerBoolean> configurationControls = new ArrayList<PortletDataHandlerBoolean>();
        if (PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(0L, 3, plid, portlet, false) > 0L || PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(groupId, 2, portlet.getRootPortletId(), false) > 0L || PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(companyId, 1, portlet.getRootPortletId(), false) > 0L) {
            PortletDataHandlerControl[] portletDataHandlerControls = null;
            if (this.isDisplayPortlet()) {
                portletDataHandlerControls = this.getExportControls();
            }
            configurationControls.add(new PortletDataHandlerBoolean(null, "PORTLET_SETUP", "setup", true, false, portletDataHandlerControls, null, null));
        }
        if (PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(-1L, 5, portlet.getRootPortletId(), false) > 0L) {
            configurationControls.add(new PortletDataHandlerBoolean(null, "PORTLET_ARCHIVED_SETUPS", "archived-setups", true, false, null, null, null));
        }
        if (PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(-1L, 4, plid, portlet, false) > 0L || PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(groupId, 4, 0L, portlet, false) > 0L) {
            configurationControls.add(new PortletDataHandlerBoolean(null, "PORTLET_USER_PREFERENCES", "user-preferences", true, false, null, null, null));
        }
        return configurationControls.toArray(new PortletDataHandlerBoolean[configurationControls.size()]);
    }

    @Override
    public PortletDataHandlerControl[] getExportControls() {
        return this._exportControls;
    }

    @Override
    public PortletDataHandlerControl[] getExportMetadataControls() {
        return this._exportMetadataControls;
    }

    @Override
    public long getExportModelCount(ManifestSummary manifestSummary) {
        return this.getExportModelCount(manifestSummary, this.getExportControls());
    }

    @Override
    public PortletDataHandlerControl[] getImportConfigurationControls(Portlet portlet, ManifestSummary manifestSummary) {
        String[] configurationPortletOptions = manifestSummary.getConfigurationPortletOptions(portlet.getRootPortletId());
        return this.getImportConfigurationControls(configurationPortletOptions);
    }

    @Override
    public PortletDataHandlerControl[] getImportConfigurationControls(String[] configurationPortletOptions) {
        ArrayList<PortletDataHandlerBoolean> configurationControls = new ArrayList<PortletDataHandlerBoolean>();
        if (ArrayUtil.contains(configurationPortletOptions, "setup")) {
            PortletDataHandlerControl[] portletDataHandlerControls = null;
            if (this.isDisplayPortlet()) {
                portletDataHandlerControls = this.getExportControls();
            }
            configurationControls.add(new PortletDataHandlerBoolean(null, "PORTLET_SETUP", "setup", true, false, portletDataHandlerControls, null, null));
        }
        if (ArrayUtil.contains(configurationPortletOptions, "archived-setups")) {
            configurationControls.add(new PortletDataHandlerBoolean(null, "PORTLET_ARCHIVED_SETUPS", "archived-setups", true, false, null, null, null));
        }
        if (ArrayUtil.contains(configurationPortletOptions, "user-preferences")) {
            configurationControls.add(new PortletDataHandlerBoolean(null, "PORTLET_USER_PREFERENCES", "user-preferences", true, false, null, null, null));
        }
        return configurationControls.toArray(new PortletDataHandlerBoolean[configurationControls.size()]);
    }

    @Override
    public PortletDataHandlerControl[] getImportControls() {
        return this._importControls;
    }

    @Override
    public PortletDataHandlerControl[] getImportMetadataControls() {
        return this._importMetadataControls;
    }

    @Override
    public String getPortletId() {
        return this._portletId;
    }

    @Override
    public PortletPreferences importData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws PortletDataException {
        long startTime = 0L;
        if (_log.isInfoEnabled()) {
            _log.info("Importing portlet " + portletId);
            startTime = System.currentTimeMillis();
        }
        long sourceGroupId = portletDataContext.getSourceGroupId();
        try {
            if (Validator.isXml(data)) {
                this.addImportDataRootElement(portletDataContext, data);
            }
            PortletPreferences portletPreferences2 = this.doImportData(portletDataContext, portletId, portletPreferences, data);
            return portletPreferences2;
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
        finally {
            portletDataContext.setSourceGroupId(sourceGroupId);
            if (_log.isInfoEnabled()) {
                long duration = System.currentTimeMillis() - startTime;
                _log.info("Imported portlet in " + Time.getDuration(duration));
            }
        }
    }

    @Override
    public boolean isDataLocalized() {
        return this._dataLocalized;
    }

    @Override
    public boolean isDataPortalLevel() {
        return this._dataLevel.equals((Object)DataLevel.PORTAL);
    }

    @Override
    public boolean isDataPortletInstanceLevel() {
        return this._dataLevel.equals((Object)DataLevel.PORTLET_INSTANCE);
    }

    @Override
    public boolean isDataSiteLevel() {
        return this._dataLevel.equals((Object)DataLevel.SITE);
    }

    @Override
    public boolean isDisplayPortlet() {
        return this.isDataPortletInstanceLevel() && !ArrayUtil.isEmpty(this.getDataPortletPreferences());
    }

    @Override
    public boolean isPublishToLiveByDefault() {
        return this._publishToLiveByDefault;
    }

    @Override
    public boolean isSupportsDataStrategyCopyAsNew() {
        return this._supportsDataStrategyCopyAsNew;
    }

    @Override
    public void prepareManifestSummary(PortletDataContext portletDataContext) throws PortletDataException {
        this.prepareManifestSummary(portletDataContext, null);
    }

    @Override
    public void prepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            this.doPrepareManifestSummary(portletDataContext, portletPreferences);
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        String displayStyle = this.getDisplayTemplate(portletDataContext, portletId, portletPreferences);
        if (Validator.isNotNull(displayStyle) && displayStyle.startsWith("ddmTemplate_")) {
            DDMTemplate ddmTemplate;
            long displayStyleGroupId = this.getDisplayTemplateGroupId(portletDataContext, portletId, portletPreferences);
            long previousScopeGroupId = portletDataContext.getScopeGroupId();
            if (displayStyleGroupId != portletDataContext.getScopeGroupId()) {
                portletDataContext.setScopeGroupId(displayStyleGroupId);
            }
            if ((ddmTemplate = PortletDisplayTemplateUtil.fetchDDMTemplate(portletDataContext.getGroupId(), displayStyle)) != null) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel(portletDataContext, portletId, ddmTemplate);
            }
            portletDataContext.setScopeGroupId(previousScopeGroupId);
        }
        try {
            return this.doProcessExportPortletPreferences(portletDataContext, portletId, portletPreferences);
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            String displayStyle = this.getDisplayTemplate(portletDataContext, portletId, portletPreferences);
            if (Validator.isNotNull(displayStyle) && displayStyle.startsWith("ddmTemplate_")) {
                DDMTemplate ddmTemplate = null;
                long displayStyleGroupId = this.getDisplayTemplateGroupId(portletDataContext, portletId, portletPreferences);
                if (displayStyleGroupId == portletDataContext.getSourceCompanyGroupId()) {
                    Element importDataRootElement = portletDataContext.getImportDataRootElement();
                    Element referencesElement = importDataRootElement.element("references");
                    List<Element> referenceElements = referencesElement.elements();
                    String ddmTemplateUuid = PortletDisplayTemplateUtil.getDDMTemplateUuid(displayStyle);
                    boolean preloaded = false;
                    long referenceClassNameId = 0L;
                    String templateKey = null;
                    for (Element referenceElement : referenceElements) {
                        String className = referenceElement.attributeValue("class-name");
                        String uuid = referenceElement.attributeValue("uuid");
                        if (!className.equals(DDMTemplate.class.getName()) || !uuid.equals(ddmTemplateUuid)) continue;
                        preloaded = GetterUtil.getBoolean(referenceElement.attributeValue("preloaded"));
                        referenceClassNameId = PortalUtil.getClassNameId(referenceElement.attributeValue("referenced-class-name"));
                        templateKey = referenceElement.attributeValue("template-key");
                        break;
                    }
                    ddmTemplate = !preloaded ? PortletDisplayTemplateUtil.fetchDDMTemplate(portletDataContext.getCompanyGroupId(), displayStyle) : DDMTemplateLocalServiceUtil.fetchTemplate(portletDataContext.getCompanyGroupId(), referenceClassNameId, templateKey);
                } else {
                    ddmTemplate = displayStyleGroupId == portletDataContext.getSourceGroupId() ? PortletDisplayTemplateUtil.fetchDDMTemplate(portletDataContext.getScopeGroupId(), displayStyle) : PortletDisplayTemplateUtil.fetchDDMTemplate(displayStyleGroupId, displayStyle);
                }
                long importedDisplayStyleGroupId = portletDataContext.getScopeGroupId();
                if (ddmTemplate == null) {
                    String ddmTemplatePath;
                    String ddmTemplateUuid = PortletDisplayTemplateUtil.getDDMTemplateUuid(displayStyle);
                    Element ddmTemplateElement = portletDataContext.getImportDataElement(DDMTemplate.class.getSimpleName(), "uuid", ddmTemplateUuid);
                    if (ddmTemplateElement != null && (ddmTemplate = (DDMTemplate)portletDataContext.getZipEntryAsObject(ddmTemplatePath = ddmTemplateElement.attributeValue("path"))) != null) {
                        StagedModelDataHandlerUtil.importStagedModel(portletDataContext, ddmTemplate);
                    }
                } else {
                    importedDisplayStyleGroupId = ddmTemplate.getGroupId();
                }
                portletPreferences.setValue("displayStyleGroupId", String.valueOf(importedDisplayStyleGroupId));
            } else {
                portletPreferences.setValue("displayStyleGroupId", "");
            }
            return this.doProcessImportPortletPreferences(portletDataContext, portletId, portletPreferences);
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    public void setPortletId(String portletId) {
        this._portletId = portletId;
    }

    protected Element addExportDataRootElement(PortletDataContext portletDataContext) {
        Document document = SAXReaderUtil.createDocument();
        Class<?> clazz = this.getClass();
        Element rootElement = document.addElement(clazz.getSimpleName());
        portletDataContext.setExportDataRootElement(rootElement);
        return rootElement;
    }

    protected Element addImportDataRootElement(PortletDataContext portletDataContext, String data) throws DocumentException {
        Document document = SAXReaderUtil.read(data);
        Element rootElement = document.getRootElement();
        portletDataContext.setImportDataRootElement(rootElement);
        long groupId = GetterUtil.getLong(rootElement.attributeValue("group-id"));
        if (groupId != 0L) {
            portletDataContext.setSourceGroupId(groupId);
        }
        return rootElement;
    }

    protected void addUncheckedModelAdditionCount(PortletDataContext portletDataContext, PortletDataHandlerControl portletDataHandlerControl) {
        if (!(portletDataHandlerControl instanceof PortletDataHandlerBoolean)) {
            return;
        }
        PortletDataHandlerBoolean portletDataHandlerBoolean = (PortletDataHandlerBoolean)portletDataHandlerControl;
        PortletDataHandlerControl[] childPortletDataHandlerControls = portletDataHandlerBoolean.getChildren();
        if (childPortletDataHandlerControls != null) {
            PortletDataHandlerControl[] portletDataHandlerControlArray = childPortletDataHandlerControls;
            int n = childPortletDataHandlerControls.length;
            int n2 = 0;
            while (n2 < n) {
                PortletDataHandlerControl childPortletDataHandlerControl = portletDataHandlerControlArray[n2];
                this.addUncheckedModelAdditionCount(portletDataContext, childPortletDataHandlerControl);
                ++n2;
            }
        }
        if (Validator.isNull(portletDataHandlerControl.getClassName())) {
            return;
        }
        boolean checkedControl = GetterUtil.getBoolean(portletDataContext.getBooleanParameter(portletDataHandlerControl.getNamespace(), portletDataHandlerControl.getControlName(), false));
        if (!checkedControl) {
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            String manifestSummaryKey = ManifestSummary.getManifestSummaryKey(portletDataHandlerControl.getClassName(), portletDataHandlerBoolean.getReferrerClassName());
            manifestSummary.addModelAdditionCount(manifestSummaryKey, 0L);
        }
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return null;
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
    }

    protected PortletPreferences doProcessExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return portletPreferences;
    }

    protected PortletPreferences doProcessImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return portletPreferences;
    }

    protected String getDisplayTemplate(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) {
        try {
            Portlet portlet = PortletLocalServiceUtil.getPortletById(portletDataContext.getCompanyId(), portletId);
            if (Validator.isNotNull(portlet.getTemplateHandlerClass())) {
                return portletPreferences.getValue("displayStyle", null);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected long getDisplayTemplateGroupId(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) {
        try {
            Portlet portlet = PortletLocalServiceUtil.getPortletById(portletDataContext.getCompanyId(), portletId);
            if (Validator.isNotNull(portlet.getTemplateHandlerClass())) {
                return GetterUtil.getLong(portletPreferences.getValue("displayStyleGroupId", null));
            }
        }
        catch (Exception exception) {}
        return 0L;
    }

    protected String getExportDataRootElementString(Element rootElement) {
        if (rootElement == null) {
            return "";
        }
        try {
            Document document = rootElement.getDocument();
            return document.formattedString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    protected long getExportModelCount(ManifestSummary manifestSummary, PortletDataHandlerControl[] portletDataHandlerControls) {
        long totalModelCount = -1L;
        PortletDataHandlerControl[] portletDataHandlerControlArray = portletDataHandlerControls;
        int n = portletDataHandlerControls.length;
        int n2 = 0;
        while (n2 < n) {
            long childModelCount;
            PortletDataHandlerBoolean portletDataHandlerBoolean;
            PortletDataHandlerControl[] childPortletDataHandlerControls;
            PortletDataHandlerControl portletDataHandlerControl = portletDataHandlerControlArray[n2];
            long modelCount = manifestSummary.getModelAdditionCount(portletDataHandlerControl.getClassName(), portletDataHandlerControl.getReferrerClassName());
            if (portletDataHandlerControl instanceof PortletDataHandlerBoolean && (childPortletDataHandlerControls = (portletDataHandlerBoolean = (PortletDataHandlerBoolean)portletDataHandlerControl).getChildren()) != null && (childModelCount = this.getExportModelCount(manifestSummary, childPortletDataHandlerControls)) != -1L) {
                modelCount = modelCount == -1L ? childModelCount : (modelCount += childModelCount);
            }
            if (modelCount != -1L) {
                totalModelCount = totalModelCount == -1L ? modelCount : (totalModelCount += modelCount);
            }
            ++n2;
        }
        return totalModelCount;
    }

    protected void setAlwaysExportable(boolean alwaysExportable) {
    }

    protected void setAlwaysStaged(boolean alwaysStaged) {
    }

    protected void setDataLevel(DataLevel dataLevel) {
        this._dataLevel = dataLevel;
    }

    protected void setDataLocalized(boolean dataLocalized) {
        this._dataLocalized = dataLocalized;
    }

    protected void setDataPortletPreferences(String ... dataPortletPreferences) {
        this._dataPortletPreferences = dataPortletPreferences;
    }

    protected void setDeletionSystemEventStagedModelTypes(StagedModelType ... deletionSystemEventStagedModelTypes) {
        this._deletionSystemEventStagedModelTypes = deletionSystemEventStagedModelTypes;
    }

    protected void setExportControls(PortletDataHandlerControl ... exportControls) {
        this._exportControls = exportControls;
        this.setImportControls(exportControls);
    }

    protected void setExportMetadataControls(PortletDataHandlerControl ... exportMetadataControls) {
        this._exportMetadataControls = exportMetadataControls;
        this.setImportMetadataControls(exportMetadataControls);
    }

    protected void setImportControls(PortletDataHandlerControl ... importControls) {
        this._importControls = importControls;
    }

    protected void setImportMetadataControls(PortletDataHandlerControl ... importMetadataControls) {
        this._importMetadataControls = importMetadataControls;
    }

    protected void setPublishToLiveByDefault(boolean publishToLiveByDefault) {
        this._publishToLiveByDefault = publishToLiveByDefault;
    }

    protected void setSupportsDataStrategyCopyAsNew(boolean supportsDataStrategyCopyAsNew) {
        this._supportsDataStrategyCopyAsNew = supportsDataStrategyCopyAsNew;
    }
}

