/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BaseSearchResultPermissionFilter;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import java.util.ArrayList;

public class DefaultSearchResultPermissionFilter
extends BaseSearchResultPermissionFilter {
    private BaseIndexer _baseIndexer;
    private PermissionChecker _permissionChecker;

    public DefaultSearchResultPermissionFilter(BaseIndexer baseIndexer, PermissionChecker permissionChecker) {
        this._baseIndexer = baseIndexer;
        this._permissionChecker = permissionChecker;
    }

    @Override
    protected void filterHits(Hits hits, SearchContext searchContext) {
        ArrayList<Document> docs = new ArrayList<Document>();
        ArrayList<Float> scores = new ArrayList<Float>();
        Document[] documents = hits.getDocs();
        int excludeDocsSize = 0;
        int status = GetterUtil.getInteger(searchContext.getAttribute("status"), 0);
        int i = 0;
        while (i < documents.length) {
            Document document = documents[i];
            String entryClassName = document.get("entryClassName");
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            long entryClassPK = GetterUtil.getLong(document.get("entryClassPK"));
            try {
                if (indexer == null || indexer.isFilterSearch() && indexer.hasPermission(this._permissionChecker, entryClassName, entryClassPK, "VIEW") && indexer.isVisibleRelatedEntry(entryClassPK, status) || !indexer.isFilterSearch() || !indexer.isPermissionAware()) {
                    docs.add(document);
                    scores.add(Float.valueOf(hits.score(i)));
                } else {
                    ++excludeDocsSize;
                }
            }
            catch (Exception exception) {
                ++excludeDocsSize;
            }
            ++i;
        }
        hits.setDocs(docs.toArray(new Document[docs.size()]));
        hits.setScores(ArrayUtil.toFloatArray(scores));
        hits.setSearchTime((float)(System.currentTimeMillis() - hits.getStart()) / 1000.0f);
        hits.setLength(hits.getLength() - excludeDocsSize);
    }

    @Override
    protected Hits getHits(SearchContext searchContext) throws SearchException {
        return this._baseIndexer.doSearch(searchContext);
    }
}

