/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;

public class SortFactoryImpl
implements SortFactory {
    private static final Sort[] _DEFAULT_SORTS = new Sort[]{new Sort(null, 0, false), new Sort("modified", 6, true)};

    @Override
    public Sort create(String fieldName, boolean reverse) {
        return new Sort(fieldName, reverse);
    }

    @Override
    public Sort create(String fieldName, int type, boolean reverse) {
        return new Sort(fieldName, type, reverse);
    }

    @Override
    public Sort[] getDefaultSorts() {
        return _DEFAULT_SORTS;
    }

    @Override
    public Sort getSort(Class<?> clazz, int type, String orderByCol, String orderByType) {
        Indexer indexer = IndexerRegistryUtil.getIndexer(clazz);
        String sortField = indexer.getSortField(orderByCol, type);
        if (Validator.isNull(orderByType)) {
            orderByType = "asc";
        }
        return new Sort(sortField, type, !StringUtil.equalsIgnoreCase(orderByType, "asc"));
    }

    @Override
    public Sort getSort(Class<?> clazz, String orderByCol, String orderByType) {
        return this.getSort(clazz, 3, orderByCol, orderByType);
    }

    @Override
    public Sort[] toArray(List<Sort> sorts) {
        if (sorts == null || sorts.isEmpty()) {
            return new Sort[0];
        }
        Sort[] sortsArray = new Sort[sorts.size()];
        int i = 0;
        while (i < sorts.size()) {
            sortsArray[i] = sorts.get(i);
            ++i;
        }
        return sortsArray;
    }
}

