/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.security.pacl.permission.PortalSocketPermission;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class HttpUtil {
    private static Http _http;

    public static String addParameter(String url, String name, boolean value) {
        return HttpUtil.getHttp().addParameter(url, name, value);
    }

    public static String addParameter(String url, String name, double value) {
        return HttpUtil.getHttp().addParameter(url, name, value);
    }

    public static String addParameter(String url, String name, int value) {
        return HttpUtil.getHttp().addParameter(url, name, value);
    }

    public static String addParameter(String url, String name, long value) {
        return HttpUtil.getHttp().addParameter(url, name, value);
    }

    public static String addParameter(String url, String name, short value) {
        return HttpUtil.getHttp().addParameter(url, name, value);
    }

    public static String addParameter(String url, String name, String value) {
        return HttpUtil.getHttp().addParameter(url, name, value);
    }

    public static String decodePath(String path) {
        return HttpUtil.getHttp().decodePath(path);
    }

    public static String decodeURL(String url) {
        return HttpUtil.getHttp().decodeURL(url);
    }

    public static String decodeURL(String url, boolean unescapeSpaces) {
        return HttpUtil.getHttp().decodeURL(url, unescapeSpaces);
    }

    public static String encodeParameters(String url) {
        return HttpUtil.getHttp().encodeParameters(url);
    }

    public static String encodePath(String path) {
        return HttpUtil.getHttp().encodePath(path);
    }

    public static String encodeURL(String url) {
        return HttpUtil.getHttp().encodeURL(url);
    }

    public static String encodeURL(String url, boolean escapeSpaces) {
        return HttpUtil.getHttp().encodeURL(url, escapeSpaces);
    }

    public static String fixPath(String path) {
        return HttpUtil.getHttp().fixPath(path);
    }

    public static String fixPath(String path, boolean leading, boolean trailing) {
        return HttpUtil.getHttp().fixPath(path, leading, trailing);
    }

    public static String getCompleteURL(HttpServletRequest request) {
        return HttpUtil.getHttp().getCompleteURL(request);
    }

    public static Cookie[] getCookies() {
        return HttpUtil.getHttp().getCookies();
    }

    public static String getDomain(String url) {
        return HttpUtil.getHttp().getDomain(url);
    }

    public static Http getHttp() {
        PortalRuntimePermission.checkGetBeanProperty(HttpUtil.class);
        return _http;
    }

    public static String getIpAddress(String url) {
        return HttpUtil.getHttp().getIpAddress(url);
    }

    public static String getParameter(String url, String name) {
        return HttpUtil.getHttp().getParameter(url, name);
    }

    public static String getParameter(String url, String name, boolean escaped) {
        return HttpUtil.getHttp().getParameter(url, name, escaped);
    }

    public static Map<String, String[]> getParameterMap(String queryString) {
        return HttpUtil.getHttp().getParameterMap(queryString);
    }

    public static String getPath(String url) {
        return HttpUtil.getHttp().getPath(url);
    }

    public static String getProtocol(ActionRequest actionRequest) {
        return HttpUtil.getHttp().getProtocol(actionRequest);
    }

    public static String getProtocol(boolean secure) {
        return HttpUtil.getHttp().getProtocol(secure);
    }

    public static String getProtocol(HttpServletRequest request) {
        return HttpUtil.getHttp().getProtocol(request);
    }

    public static String getProtocol(RenderRequest renderRequest) {
        return HttpUtil.getHttp().getProtocol(renderRequest);
    }

    public static String getProtocol(String url) {
        return HttpUtil.getHttp().getProtocol(url);
    }

    public static String getQueryString(String url) {
        return HttpUtil.getHttp().getQueryString(url);
    }

    public static String getRequestURL(HttpServletRequest request) {
        return HttpUtil.getHttp().getRequestURL(request);
    }

    public static boolean hasDomain(String url) {
        return HttpUtil.getHttp().hasDomain(url);
    }

    public static boolean hasProtocol(String url) {
        return HttpUtil.getHttp().hasProtocol(url);
    }

    public static boolean hasProxyConfig() {
        return HttpUtil.getHttp().hasProxyConfig();
    }

    public static boolean isNonProxyHost(String host) {
        return HttpUtil.getHttp().isNonProxyHost(host);
    }

    public static boolean isProxyHost(String host) {
        return HttpUtil.getHttp().isProxyHost(host);
    }

    public static boolean isSecure(String url) {
        return HttpUtil.getHttp().isSecure(url);
    }

    public static String normalizePath(String uri) {
        if (Validator.isNull(uri)) {
            return uri;
        }
        uri = HttpUtil.removePathParameters(uri);
        String path = null;
        String queryString = null;
        int pos = uri.indexOf(63);
        if (pos != -1) {
            path = uri.substring(0, pos);
            queryString = uri.substring(pos + 1);
        } else {
            path = uri;
        }
        String[] uriParts = StringUtil.split(path.substring(1), "/");
        ArrayList<String> parts = new ArrayList<String>(uriParts.length);
        int i = 0;
        while (i < uriParts.length) {
            String curUriPart = URLCodec.decodeURL(uriParts[i]);
            String prevUriPart = null;
            if (i > 0) {
                prevUriPart = URLCodec.decodeURL(uriParts[i - 1]);
            }
            if (curUriPart.equals("..")) {
                if (!prevUriPart.equals(".")) {
                    parts.remove(parts.size() - 1);
                }
            } else if (curUriPart.length() > 0 && !curUriPart.equals(".")) {
                parts.add(URLCodec.encodeURL(curUriPart));
            }
            ++i;
        }
        StringBundler sb = new StringBundler(parts.size() * 2 + 2);
        for (String part : parts) {
            sb.append("/");
            sb.append(part);
        }
        if (Validator.isNotNull(queryString)) {
            sb.append("?");
            sb.append(queryString);
        }
        return sb.toString();
    }

    public static Map<String, String[]> parameterMapFromString(String queryString) {
        return HttpUtil.getHttp().parameterMapFromString(queryString);
    }

    public static String parameterMapToString(Map<String, String[]> parameterMap) {
        return HttpUtil.getHttp().parameterMapToString(parameterMap);
    }

    public static String parameterMapToString(Map<String, String[]> parameterMap, boolean addQuestion) {
        return HttpUtil.getHttp().parameterMapToString(parameterMap, addQuestion);
    }

    public static String protocolize(String url, ActionRequest actionRequest) {
        return HttpUtil.getHttp().protocolize(url, actionRequest);
    }

    public static String protocolize(String url, boolean secure) {
        return HttpUtil.getHttp().protocolize(url, secure);
    }

    public static String protocolize(String url, HttpServletRequest request) {
        return HttpUtil.getHttp().protocolize(url, request);
    }

    public static String protocolize(String url, int port, boolean secure) {
        return HttpUtil.getHttp().protocolize(url, port, secure);
    }

    public static String protocolize(String url, RenderRequest renderRequest) {
        return HttpUtil.getHttp().protocolize(url, renderRequest);
    }

    public static String removeDomain(String url) {
        return HttpUtil.getHttp().removeDomain(url);
    }

    public static String removeParameter(String url, String name) {
        return HttpUtil.getHttp().removeParameter(url, name);
    }

    public static String removePathParameters(String uri) {
        if (Validator.isNull(uri)) {
            return uri;
        }
        int pos = uri.indexOf(";");
        if (pos == -1) {
            return uri;
        }
        String[] uriParts = StringUtil.split(uri.substring(1), "/");
        StringBundler sb = new StringBundler(uriParts.length * 2);
        String[] stringArray = uriParts;
        int n = uriParts.length;
        int n2 = 0;
        while (n2 < n) {
            String uriPart = stringArray[n2];
            pos = uriPart.indexOf(";");
            if (pos == -1) {
                sb.append("/");
                sb.append(uriPart);
            } else if (pos != 0) {
                sb.append("/");
                sb.append(uriPart.substring(0, pos));
            }
            ++n2;
        }
        if (sb.length() == 0) {
            return "/";
        }
        return sb.toString();
    }

    public static String removeProtocol(String url) {
        return HttpUtil.getHttp().removeProtocol(url);
    }

    public static String sanitizeHeader(String header) {
        return HttpUtil.getHttp().sanitizeHeader(header);
    }

    public static String setParameter(String url, String name, boolean value) {
        return HttpUtil.getHttp().setParameter(url, name, value);
    }

    public static String setParameter(String url, String name, double value) {
        return HttpUtil.getHttp().setParameter(url, name, value);
    }

    public static String setParameter(String url, String name, int value) {
        return HttpUtil.getHttp().setParameter(url, name, value);
    }

    public static String setParameter(String url, String name, long value) {
        return HttpUtil.getHttp().setParameter(url, name, value);
    }

    public static String setParameter(String url, String name, short value) {
        return HttpUtil.getHttp().setParameter(url, name, value);
    }

    public static String setParameter(String url, String name, String value) {
        return HttpUtil.getHttp().setParameter(url, name, value);
    }

    public static byte[] URLtoByteArray(Http.Options options) throws IOException {
        PortalSocketPermission.checkConnect(options);
        return HttpUtil.getHttp().URLtoByteArray(options);
    }

    public static byte[] URLtoByteArray(String location) throws IOException {
        PortalSocketPermission.checkConnect(location);
        return HttpUtil.getHttp().URLtoByteArray(location);
    }

    public static byte[] URLtoByteArray(String location, boolean post) throws IOException {
        PortalSocketPermission.checkConnect(location);
        return HttpUtil.getHttp().URLtoByteArray(location, post);
    }

    public static String URLtoString(Http.Options options) throws IOException {
        PortalSocketPermission.checkConnect(options);
        return HttpUtil.getHttp().URLtoString(options);
    }

    public static String URLtoString(String location) throws IOException {
        PortalSocketPermission.checkConnect(location);
        return HttpUtil.getHttp().URLtoString(location);
    }

    public static String URLtoString(String location, boolean post) throws IOException {
        PortalSocketPermission.checkConnect(location);
        return HttpUtil.getHttp().URLtoString(location, post);
    }

    public static String URLtoString(URL url) throws IOException {
        PortalSocketPermission.checkConnect(url);
        return HttpUtil.getHttp().URLtoString(url);
    }

    public void setHttp(Http http) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _http = http;
    }
}

