/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.xml;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Entity;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.ProcessingInstruction;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.kernel.xml.Text;
import com.liferay.portal.kernel.xml.XMLSchema;
import com.liferay.portal.kernel.xml.XPath;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class SAXReaderUtil {
    private static Log _log = LogFactoryUtil.getLog(SAXReaderUtil.class);
    private static final String[] _XML_SECURITY_WHITELIST = PropsUtil.getArray("xml.security.whitelist");
    private static SAXReader _saxReader;
    private static SAXReader _unsecureSAXReader;

    public static Attribute createAttribute(Element element, QName qName, String value) {
        return SAXReaderUtil.getSecureSAXReader().createAttribute(element, qName, value);
    }

    public static Attribute createAttribute(Element element, String name, String value) {
        return SAXReaderUtil.getSecureSAXReader().createAttribute(element, name, value);
    }

    public static Document createDocument() {
        return SAXReaderUtil.getSecureSAXReader().createDocument();
    }

    public static Document createDocument(Element rootElement) {
        return SAXReaderUtil.getSecureSAXReader().createDocument(rootElement);
    }

    public static Document createDocument(String encoding) {
        return SAXReaderUtil.getSecureSAXReader().createDocument(encoding);
    }

    public static Element createElement(QName qName) {
        return SAXReaderUtil.getSecureSAXReader().createElement(qName);
    }

    public static Element createElement(String name) {
        return SAXReaderUtil.getSecureSAXReader().createElement(name);
    }

    public static Entity createEntity(String name, String text) {
        return SAXReaderUtil.getSecureSAXReader().createEntity(name, text);
    }

    public static Namespace createNamespace(String uri) {
        return SAXReaderUtil.getSecureSAXReader().createNamespace(uri);
    }

    public static Namespace createNamespace(String prefix, String uri) {
        return SAXReaderUtil.getSecureSAXReader().createNamespace(prefix, uri);
    }

    public static ProcessingInstruction createProcessingInstruction(String target, Map<String, String> data) {
        return SAXReaderUtil.getSecureSAXReader().createProcessingInstruction(target, data);
    }

    public static ProcessingInstruction createProcessingInstruction(String target, String data) {
        return SAXReaderUtil.getSecureSAXReader().createProcessingInstruction(target, data);
    }

    public static QName createQName(String localName) {
        return SAXReaderUtil.getSecureSAXReader().createQName(localName);
    }

    public static QName createQName(String localName, Namespace namespace) {
        return SAXReaderUtil.getSecureSAXReader().createQName(localName, namespace);
    }

    public static Text createText(String text) {
        return SAXReaderUtil.getSecureSAXReader().createText(text);
    }

    public static XPath createXPath(String xPathExpression) {
        return SAXReaderUtil.getSecureSAXReader().createXPath(xPathExpression);
    }

    public static XPath createXPath(String xPathExpression, Map<String, String> namespaceContextMap) {
        return SAXReaderUtil.getSecureSAXReader().createXPath(xPathExpression, namespaceContextMap);
    }

    public static XPath createXPath(String xPathExpression, String prefix, String namespace) {
        return SAXReaderUtil.getSecureSAXReader().createXPath(xPathExpression, prefix, namespace);
    }

    public static SAXReader getSAXReader() {
        return SAXReaderUtil.getSecureSAXReader();
    }

    public static SAXReader getSecureSAXReader() {
        PortalRuntimePermission.checkGetBeanProperty(SAXReaderUtil.class);
        if (SAXReaderUtil.isCallerWhitelisted()) {
            return SAXReaderUtil.getUnsecureSAXReader();
        }
        return _saxReader;
    }

    public static SAXReader getUnsecureSAXReader() {
        PortalRuntimePermission.checkGetBeanProperty(SAXReaderUtil.class, "unsecureSAXReader");
        return _unsecureSAXReader;
    }

    public static Document read(File file) throws DocumentException {
        return SAXReaderUtil.getSecureSAXReader().read(file);
    }

    public static Document read(File file, boolean validate) throws DocumentException {
        return SAXReaderUtil.getSecureSAXReader().read(file, validate);
    }

    public static Document read(InputStream is) throws DocumentException {
        return SAXReaderUtil.getSecureSAXReader().read(is);
    }

    public static Document read(InputStream is, boolean validate) throws DocumentException {
        return SAXReaderUtil.getSecureSAXReader().read(is, validate);
    }

    public static Document read(Reader reader) throws DocumentException {
        return SAXReaderUtil.getSecureSAXReader().read(reader);
    }

    public static Document read(Reader reader, boolean validate) throws DocumentException {
        return SAXReaderUtil.getSecureSAXReader().read(reader, validate);
    }

    public static Document read(String xml) throws DocumentException {
        return SAXReaderUtil.getSecureSAXReader().read(xml);
    }

    public static Document read(String xml, boolean validate) throws DocumentException {
        return SAXReaderUtil.getSecureSAXReader().read(xml, validate);
    }

    public static Document read(String xml, XMLSchema xmlSchema) throws DocumentException {
        return SAXReaderUtil.getSecureSAXReader().read(xml, xmlSchema);
    }

    public static Document read(URL url) throws DocumentException {
        return SAXReaderUtil.getSecureSAXReader().read(url);
    }

    public static Document read(URL url, boolean validate) throws DocumentException {
        return SAXReaderUtil.getSecureSAXReader().read(url, validate);
    }

    public static Document readURL(String url) throws DocumentException, MalformedURLException {
        return SAXReaderUtil.getSecureSAXReader().readURL(url);
    }

    public static Document readURL(String url, boolean validate) throws DocumentException, MalformedURLException {
        return SAXReaderUtil.getSecureSAXReader().readURL(url, validate);
    }

    public static List<Node> selectNodes(String xPathFilterExpression, List<Node> nodes) {
        return SAXReaderUtil.getSecureSAXReader().selectNodes(xPathFilterExpression, nodes);
    }

    public static List<Node> selectNodes(String xPathFilterExpression, Node node) {
        return SAXReaderUtil.getSecureSAXReader().selectNodes(xPathFilterExpression, node);
    }

    public static void sort(List<Node> nodes, String xPathExpression) {
        SAXReaderUtil.getSecureSAXReader().sort(nodes, xPathExpression);
    }

    public static void sort(List<Node> nodes, String xPathExpression, boolean distinct) {
        SAXReaderUtil.getSecureSAXReader().sort(nodes, xPathExpression, distinct);
    }

    public void setSecureSAXReader(SAXReader saxReader) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _saxReader = saxReader;
    }

    public void setUnsecureSAXReader(SAXReader unsecureSAXReader) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass(), "unsecureSAXReader");
        _unsecureSAXReader = unsecureSAXReader;
    }

    protected static boolean isCallerWhitelisted() {
        StringBundler sb = new StringBundler(3);
        Exception e = new Exception();
        StackTraceElement[] stackTraceElements = e.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElements[2];
        String methodName = stackTraceElement.getMethodName();
        if (!methodName.startsWith("read")) {
            return false;
        }
        stackTraceElement = stackTraceElements[3];
        sb.append(stackTraceElement.getClassName());
        sb.append("#");
        sb.append(stackTraceElement.getMethodName());
        String callerSignature = sb.toString();
        String[] stringArray = _XML_SECURITY_WHITELIST;
        int n = _XML_SECURITY_WHITELIST.length;
        int n2 = 0;
        while (n2 < n) {
            String whitelistSignature = stringArray[n2];
            if (callerSignature.startsWith(whitelistSignature)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Unsecure SAX reader allowed for " + callerSignature + " based on the \"" + whitelistSignature + "\" whitelist");
                }
                return true;
            }
            ++n2;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Unsecure SAX reader disallowed for " + callerSignature);
        }
        return false;
    }
}

