/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.persistence;

import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.persistence.MBMessageActionableDynamicQuery;

public class MBMessageExportActionableDynamicQuery
extends MBMessageActionableDynamicQuery {
    private PortletDataContext _portletDataContext;

    public MBMessageExportActionableDynamicQuery(PortletDataContext portletDataContext) throws SystemException {
        this._portletDataContext = portletDataContext;
        this.setCompanyId(this._portletDataContext.getCompanyId());
        this.setGroupId(this._portletDataContext.getScopeGroupId());
    }

    @Override
    public long performCount() throws PortalException, SystemException {
        ManifestSummary manifestSummary = this._portletDataContext.getManifestSummary();
        StagedModelType stagedModelType = this.getStagedModelType();
        long modelAdditionCount = super.performCount();
        manifestSummary.addModelAdditionCount(stagedModelType.toString(), modelAdditionCount);
        long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount(this._portletDataContext, stagedModelType);
        manifestSummary.addModelDeletionCount(stagedModelType.toString(), modelDeletionCount);
        return modelAdditionCount;
    }

    @Override
    protected void addCriteria(DynamicQuery dynamicQuery) {
        Criterion modifiedDateCriterion = this._portletDataContext.getDateRangeCriteria("modifiedDate");
        Criterion statusDateCriterion = this._portletDataContext.getDateRangeCriteria("statusDate");
        if (modifiedDateCriterion != null && statusDateCriterion != null) {
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            disjunction.add(modifiedDateCriterion);
            disjunction.add(statusDateCriterion);
            dynamicQuery.add(disjunction);
        }
        if (this.getStagedModelType().getReferrerClassNameId() >= 0L) {
            Property classNameIdProperty = PropertyFactoryUtil.forName("classNameId");
            dynamicQuery.add(classNameIdProperty.eq(this.getStagedModelType().getReferrerClassNameId()));
        }
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(MBMessage.class.getName());
        Property workflowStatusProperty = PropertyFactoryUtil.forName("status");
        dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
    }

    protected StagedModelType getStagedModelType() {
        return new StagedModelType(PortalUtil.getClassNameId(MBMessage.class.getName()));
    }

    @Override
    protected void performAction(Object object) throws PortalException, SystemException {
        MBMessage stagedModel = (MBMessage)object;
        StagedModelDataHandlerUtil.exportStagedModel(this._portletDataContext, stagedModel);
    }
}

