/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.containers.graph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.interedition.collatex2.implementation.containers.graph.VariantGraphEdge;
import eu.interedition.collatex2.implementation.containers.graph.VariantGraphIndex;
import eu.interedition.collatex2.implementation.containers.graph.VariantGraphVertex;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IToken;
import eu.interedition.collatex2.interfaces.ITokenIndex;
import eu.interedition.collatex2.interfaces.IVariantGraph;
import eu.interedition.collatex2.interfaces.IVariantGraphEdge;
import eu.interedition.collatex2.interfaces.IVariantGraphVertex;
import eu.interedition.collatex2.interfaces.IWitness;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.BellmanFordShortestPath;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;

public class VariantGraph2
extends DirectedAcyclicGraph<IVariantGraphVertex, IVariantGraphEdge>
implements IVariantGraph {
    private final IVariantGraphVertex startVertex = new VariantGraphVertex("#", null);
    private final IVariantGraphVertex endVertex;

    private VariantGraph2() {
        super(IVariantGraphEdge.class);
        this.addVertex(this.startVertex);
        this.endVertex = new VariantGraphVertex("#", null);
        this.addVertex(this.endVertex);
    }

    @Override
    public List<String> getRepeatedTokens() {
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet((Iterable)this.vertexSet());
        linkedHashSet.remove(this.startVertex);
        linkedHashSet.remove(this.endVertex);
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (Object object : linkedHashSet) {
            arrayListMultimap.put((Object)object.getNormalized(), object);
        }
        ArrayList arrayList = Lists.newArrayList();
        for (String string : arrayListMultimap.keySet()) {
            if (arrayListMultimap.get((Object)string).size() <= 1) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public IVariantGraphVertex getEndVertex() {
        return this.endVertex;
    }

    @Override
    public IVariantGraphVertex getStartVertex() {
        return this.startVertex;
    }

    @Override
    public List<IWitness> getWitnesses() {
        Set set = this.outgoingEdgesOf(this.startVertex);
        ArrayList arrayList = Lists.newArrayList();
        for (IVariantGraphEdge iVariantGraphEdge : set) {
            arrayList.addAll(iVariantGraphEdge.getWitnesses());
        }
        Collections.sort(arrayList, new Comparator<IWitness>(){

            @Override
            public int compare(IWitness iWitness, IWitness iWitness2) {
                return iWitness.getSigil().compareTo(iWitness2.getSigil());
            }
        });
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public boolean isEmpty() {
        return this.getWitnesses().isEmpty();
    }

    public static VariantGraph2 create() {
        return new VariantGraph2();
    }

    public static VariantGraph2 create(IWitness iWitness) {
        VariantGraph2 variantGraph2 = VariantGraph2.create();
        ArrayList arrayList = Lists.newArrayList();
        for (INormalizedToken object : iWitness.getTokens()) {
            IVariantGraphVertex iVariantGraphVertex = variantGraph2.addNewVertex(object.getNormalized(), object);
            iVariantGraphVertex.addToken(iWitness, object);
            arrayList.add(iVariantGraphVertex);
        }
        Object object = variantGraph2.getStartVertex();
        for (IVariantGraphVertex iVariantGraphVertex : arrayList) {
            variantGraph2.addNewEdge((IVariantGraphVertex)object, iVariantGraphVertex, iWitness);
            object = iVariantGraphVertex;
        }
        variantGraph2.addNewEdge((IVariantGraphVertex)object, variantGraph2.getEndVertex(), iWitness);
        return variantGraph2;
    }

    @Override
    public List<IVariantGraphVertex> getPath(IWitness iWitness) {
        IVariantGraphVertex iVariantGraphVertex;
        ArrayList arrayList = Lists.newArrayList();
        IVariantGraphVertex iVariantGraphVertex2 = iVariantGraphVertex = this.getStartVertex();
        while (this.outDegreeOf(iVariantGraphVertex2) > 0) {
            Set set = this.outgoingEdgesOf(iVariantGraphVertex2);
            boolean bl = false;
            for (IVariantGraphEdge iVariantGraphEdge : set) {
                if (bl || !iVariantGraphEdge.containsWitness(iWitness)) continue;
                bl = true;
                IVariantGraphVertex iVariantGraphVertex3 = (IVariantGraphVertex)this.getEdgeTarget(iVariantGraphEdge);
                if (!iVariantGraphVertex3.getNormalized().equals("#")) {
                    arrayList.add(iVariantGraphVertex3);
                }
                iVariantGraphVertex2 = iVariantGraphVertex3;
            }
            if (bl) continue;
            throw new RuntimeException("No valid path found for " + iWitness.getSigil());
        }
        return arrayList;
    }

    public IVariantGraphVertex addNewVertex(String string, INormalizedToken iNormalizedToken) {
        VariantGraphVertex variantGraphVertex = new VariantGraphVertex(string, iNormalizedToken);
        this.addVertex(variantGraphVertex);
        return variantGraphVertex;
    }

    public void addNewEdge(IVariantGraphVertex iVariantGraphVertex, IVariantGraphVertex iVariantGraphVertex2, IWitness iWitness) {
        VariantGraphEdge variantGraphEdge = new VariantGraphEdge(iVariantGraphVertex, iVariantGraphVertex2, iWitness);
        this.addEdge(iVariantGraphVertex, iVariantGraphVertex2, variantGraphEdge);
    }

    @Override
    public List<IVariantGraphVertex> getLongestPath() {
        Object object2;
        for (Object object2 : this.edgeSet()) {
            this.setEdgeWeight(object2, -1.0);
        }
        IVariantGraphVertex iVariantGraphVertex = this.getStartVertex();
        object2 = this.getEndVertex();
        List list = BellmanFordShortestPath.findPathBetween((Graph)this, (Object)iVariantGraphVertex, (Object)object2);
        ArrayList arrayList = Lists.newArrayList();
        for (IVariantGraphEdge iVariantGraphEdge : list) {
            IVariantGraphVertex iVariantGraphVertex2 = (IVariantGraphVertex)this.getEdgeTarget(iVariantGraphEdge);
            if (iVariantGraphVertex2 == object2) continue;
            arrayList.add(iVariantGraphVertex2);
        }
        return arrayList;
    }

    @Override
    public ITokenIndex getTokenIndex(List<String> list) {
        return VariantGraphIndex.create(this, list);
    }

    @Override
    public List<INormalizedToken> getTokens(IWitness iWitness) {
        List<IVariantGraphVertex> list = this.getPath(iWitness);
        ArrayList arrayList = Lists.newArrayList();
        for (IVariantGraphVertex iVariantGraphVertex : list) {
            arrayList.add(iVariantGraphVertex);
        }
        return arrayList;
    }

    @Override
    public boolean isNear(IToken iToken, IToken iToken2) {
        if (!(iToken instanceof IVariantGraphVertex)) {
            throw new RuntimeException("IToken a is not of type IVariantGraphVertex!");
        }
        if (!(iToken2 instanceof IVariantGraphVertex)) {
            throw new RuntimeException("IToken b is not of type IVariantGraphVertex!");
        }
        return this.containsEdge((IVariantGraphVertex)iToken, (IVariantGraphVertex)iToken2);
    }

    @Override
    public Iterator<INormalizedToken> tokenIterator() {
        final Iterator iterator = this.iterator();
        return new Iterator<INormalizedToken>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public INormalizedToken next() {
                IVariantGraphVertex iVariantGraphVertex = (IVariantGraphVertex)iterator.next();
                return iVariantGraphVertex;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

