/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.containers.graph;

import com.google.common.collect.Sets;
import eu.interedition.collatex2.interfaces.IVariantGraphEdge;
import eu.interedition.collatex2.interfaces.IVariantGraphVertex;
import eu.interedition.collatex2.interfaces.IWitness;
import java.util.Collections;
import java.util.Set;
import org.jgrapht.graph.DefaultWeightedEdge;

public class VariantGraphEdge
extends DefaultWeightedEdge
implements IVariantGraphEdge {
    private final IVariantGraphVertex start;
    private final IVariantGraphVertex end;
    private final Set<IWitness> witnesses;

    public VariantGraphEdge(IVariantGraphVertex iVariantGraphVertex, IVariantGraphVertex iVariantGraphVertex2, IWitness iWitness) {
        this.start = iVariantGraphVertex;
        this.end = iVariantGraphVertex2;
        this.witnesses = Sets.newLinkedHashSet();
        this.addWitness(iWitness);
    }

    @Override
    public Set<IWitness> getWitnesses() {
        return Collections.unmodifiableSet(this.witnesses);
    }

    @Override
    public IVariantGraphVertex getBeginVertex() {
        return this.start;
    }

    @Override
    public IVariantGraphVertex getEndVertex() {
        return this.end;
    }

    public String toString() {
        String string = "";
        StringBuilder stringBuilder = new StringBuilder(this.getBeginVertex().getNormalized()).append(" -> ").append(this.getEndVertex().getNormalized()).append(": ");
        for (IWitness iWitness : this.witnesses) {
            stringBuilder.append(string).append(iWitness.getSigil());
            string = ", ";
        }
        return stringBuilder.toString();
    }

    @Override
    public void addWitness(IWitness iWitness) {
        this.witnesses.add(iWitness);
    }

    @Override
    public boolean containsWitness(IWitness iWitness) {
        return this.witnesses.contains(iWitness);
    }
}

