/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.containers.graph;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.interedition.collatex2.implementation.input.Phrase;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IPhrase;
import eu.interedition.collatex2.interfaces.ITokenIndex;
import eu.interedition.collatex2.interfaces.IVariantGraph;
import eu.interedition.collatex2.interfaces.IVariantGraphVertex;
import eu.interedition.collatex2.interfaces.IWitness;
import eu.interedition.collatex2.legacy.indexing.NullToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VariantGraphIndex
implements ITokenIndex {
    private final Map<String, List<INormalizedToken>> normalizedToTokens;
    private final IVariantGraph graph;

    public static ITokenIndex create(IVariantGraph iVariantGraph, List<String> list) {
        VariantGraphIndex variantGraphIndex = new VariantGraphIndex(iVariantGraph);
        for (IWitness iWitness : iVariantGraph.getWitnesses()) {
            List<IVariantGraphVertex> list2 = iVariantGraph.getPath(iWitness);
            int n = 0;
            for (IVariantGraphVertex iVariantGraphVertex : list2) {
                variantGraphIndex.makeTokenUniqueIfneeded(n, variantGraphIndex, list, iVariantGraphVertex, list2);
                ++n;
            }
        }
        return variantGraphIndex;
    }

    private void makeTokenUniqueIfneeded(int n, VariantGraphIndex variantGraphIndex, List<String> list, IVariantGraphVertex iVariantGraphVertex, List<IVariantGraphVertex> list2) {
        boolean bl;
        String string = iVariantGraphVertex.getNormalized();
        boolean bl2 = bl = !list.contains(string);
        if (bl) {
            ArrayList arrayList = Lists.newArrayList((Object[])new IVariantGraphVertex[]{iVariantGraphVertex});
            variantGraphIndex.add(arrayList);
        } else {
            List<IVariantGraphVertex> list3 = this.findUniqueVerticesToTheLeft(list2, list, n);
            List<IVariantGraphVertex> list4 = this.findUniqueVerticesToTheRight(list2, list, n);
            variantGraphIndex.add(list3);
            variantGraphIndex.add(list4);
        }
    }

    private List<IVariantGraphVertex> findUniqueVerticesToTheRight(List<IVariantGraphVertex> list, List<String> list2, int n) {
        int n2;
        ArrayList arrayList = Lists.newArrayList();
        boolean bl = false;
        for (int i = n2 = n; !bl && i < list.size(); ++i) {
            IVariantGraphVertex iVariantGraphVertex = list.get(i);
            String string = iVariantGraphVertex.getNormalized();
            bl = !list2.contains(string);
            arrayList.add(iVariantGraphVertex);
        }
        if (!bl) {
            arrayList.add(this.graph.getEndVertex());
        }
        return arrayList;
    }

    private List<IVariantGraphVertex> findUniqueVerticesToTheLeft(List<IVariantGraphVertex> list, List<String> list2, int n) {
        int n2;
        ArrayList arrayList = Lists.newArrayList();
        boolean bl = false;
        for (int i = n2 = n; !bl && i > -1; --i) {
            IVariantGraphVertex iVariantGraphVertex = list.get(i);
            String string = iVariantGraphVertex.getNormalized();
            bl = !list2.contains(string);
            arrayList.add(0, iVariantGraphVertex);
        }
        if (!bl) {
            arrayList.add(0, this.graph.getStartVertex());
        }
        return arrayList;
    }

    private VariantGraphIndex(IVariantGraph iVariantGraph) {
        this.graph = iVariantGraph;
        this.normalizedToTokens = Maps.newLinkedHashMap();
    }

    private void add(List<IVariantGraphVertex> list) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (IVariantGraphVertex object : list) {
            stringBuilder.append(string).append(object.getNormalized());
            string = " ";
        }
        ArrayList arrayList = Lists.newArrayList();
        for (IVariantGraphVertex iVariantGraphVertex : list) {
            if (iVariantGraphVertex.equals(this.graph.getStartVertex()) || iVariantGraphVertex.equals(this.graph.getEndVertex())) {
                arrayList.add(new NullToken(0, null));
                continue;
            }
            if (iVariantGraphVertex.getWitnesses().isEmpty()) {
                throw new RuntimeException("STOP! Witness set is not supposed to be empty! Vertex: " + iVariantGraphVertex.getNormalized());
            }
            arrayList.add(iVariantGraphVertex);
        }
        this.normalizedToTokens.put(stringBuilder.toString(), arrayList);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("VariantGraphIndex: (");
        String string = "";
        for (String string2 : this.normalizedToTokens.keySet()) {
            stringBuilder.append(string).append(string2);
            string = ", ";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean contains(String string) {
        return this.normalizedToTokens.containsKey(string);
    }

    @Override
    public IPhrase getPhrase(String string) {
        if (!this.contains(string)) {
            throw new RuntimeException("Item does not exist!");
        }
        Collection collection = this.normalizedToTokens.get(string);
        return new Phrase(Lists.newArrayList((Iterable)collection));
    }

    @Override
    public int size() {
        return this.normalizedToTokens.size();
    }

    @Override
    public Set<String> keys() {
        return this.normalizedToTokens.keySet();
    }
}

