/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.containers.witness;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import eu.interedition.collatex2.implementation.containers.witness.WitnessIndex;
import eu.interedition.collatex2.implementation.input.Phrase;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IPhrase;
import eu.interedition.collatex2.interfaces.IToken;
import eu.interedition.collatex2.interfaces.ITokenIndex;
import eu.interedition.collatex2.interfaces.IWitness;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class NormalizedWitness
implements Iterable<INormalizedToken>,
IWitness {
    private String sigil;
    private List<INormalizedToken> tokens;

    public NormalizedWitness() {
    }

    public NormalizedWitness(String string, List<INormalizedToken> list) {
        this.sigil = string;
        this.tokens = list;
    }

    public NormalizedWitness(String string) {
        this.sigil = string;
        this.tokens = Lists.newArrayList();
    }

    @Override
    public List<INormalizedToken> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<INormalizedToken> list) {
        this.tokens = list;
    }

    @Override
    public String getSigil() {
        return this.sigil;
    }

    public void setSigil(String string) {
        this.sigil = string;
    }

    @Override
    public Iterator<INormalizedToken> iterator() {
        return this.tokens.iterator();
    }

    @Override
    public IPhrase createPhrase(int n, int n2) {
        boolean bl = n - 1 > n2;
        ArrayList<INormalizedToken> arrayList = bl ? new ArrayList<INormalizedToken>() : this.tokens.subList(n - 1, n2);
        return new Phrase(arrayList);
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    @Override
    public List<String> getRepeatedTokens() {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (INormalizedToken object : this.getTokens()) {
            arrayListMultimap.put((Object)object.getNormalized(), (Object)object);
        }
        ArrayList arrayList = Lists.newArrayList();
        for (String string : arrayListMultimap.keySet()) {
            Collection collection = arrayListMultimap.get((Object)string);
            if (collection.size() <= 1) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public ITokenIndex getTokenIndex(List<String> list) {
        return new WitnessIndex(this, list);
    }

    public String toString() {
        return this.getSigil();
    }

    @Override
    public boolean isNear(IToken iToken, IToken iToken2) {
        return iToken2.getPosition() - iToken.getPosition() == 1;
    }

    @Override
    public Iterator<INormalizedToken> tokenIterator() {
        return this.iterator();
    }
}

