/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.containers.witness;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.interedition.collatex2.implementation.input.Phrase;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IPhrase;
import eu.interedition.collatex2.interfaces.ITokenIndex;
import eu.interedition.collatex2.interfaces.IWitness;
import eu.interedition.collatex2.legacy.indexing.NullToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WitnessIndex
implements ITokenIndex {
    List<IPhrase> phraseCollection = Lists.newArrayList();
    private static final Function<INormalizedToken, IPhrase> TOKEN_TO_PHRASE = new Function<INormalizedToken, IPhrase>(){

        public IPhrase apply(INormalizedToken iNormalizedToken) {
            return new Phrase(Lists.newArrayList((Object[])new INormalizedToken[]{iNormalizedToken}));
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(WitnessIndex.class);
    public static final Function<IPhrase, String> PHRASE_TO_NORMALIZED = new Function<IPhrase, String>(){

        public String apply(IPhrase iPhrase) {
            return iPhrase.getNormalized();
        }
    };

    public WitnessIndex(List<IPhrase> list) {
        this.phraseCollection = list;
    }

    public WitnessIndex(IWitness iWitness, List<String> list) {
        List<INormalizedToken> list2 = iWitness.getTokens();
        this.phraseCollection.addAll(this.getUniqueTokensAsPhrases(list2, list));
        this.phraseCollection.addAll(this.getUniquePhrasesFromRepeatingTokens(list2, list));
    }

    private Collection<IPhrase> getUniquePhrasesFromRepeatingTokens(List<INormalizedToken> list, List<String> list2) {
        ArrayList arrayList = Lists.newArrayList();
        HashSet hashSet = Sets.newHashSet();
        for (INormalizedToken iNormalizedToken : list) {
            LOG.debug(iNormalizedToken.getContent());
            if (!hashSet.contains(iNormalizedToken.getPosition()) && list2.contains(iNormalizedToken.getNormalized())) {
                arrayList.add(WitnessIndex.findUniquePhraseToTheLeft(iNormalizedToken, list2, list));
                arrayList.add(WitnessIndex.findUniquePhraseToTheRight(iNormalizedToken, list2, list));
                continue;
            }
            hashSet.add(iNormalizedToken.getPosition());
        }
        LOG.debug(((Object)arrayList).toString());
        return arrayList;
    }

    private static IPhrase findUniquePhraseToTheLeft(INormalizedToken iNormalizedToken, List<String> list, List<INormalizedToken> list2) {
        Phrase phrase = new Phrase(Lists.newArrayList((Object[])new INormalizedToken[]{iNormalizedToken}));
        boolean bl = false;
        for (int i = iNormalizedToken.getPosition() - 1; !bl && i > 0; --i) {
            INormalizedToken iNormalizedToken2 = list2.get(i - 1);
            String string = iNormalizedToken2.getNormalized();
            bl = !list.contains(string);
            phrase.addTokenToLeft(iNormalizedToken2);
        }
        if (!bl) {
            phrase.addTokenToLeft(new NullToken(1, iNormalizedToken.getSigil()));
        }
        return phrase;
    }

    private static IPhrase findUniquePhraseToTheRight(INormalizedToken iNormalizedToken, List<String> list, List<INormalizedToken> list2) {
        Phrase phrase = new Phrase(Lists.newArrayList((Object[])new INormalizedToken[]{iNormalizedToken}));
        boolean bl = false;
        for (int i = iNormalizedToken.getPosition() + 1; !bl && i < list2.size() + 1; ++i) {
            INormalizedToken iNormalizedToken2 = list2.get(i - 1);
            String string = iNormalizedToken2.getNormalized();
            bl = !list.contains(string);
            phrase.addTokenToRight(iNormalizedToken2);
        }
        if (!bl) {
            phrase.addTokenToRight(new NullToken(list2.size(), iNormalizedToken.getSigil()));
        }
        return phrase;
    }

    private IPhrase leftExpandedPhrase(INormalizedToken iNormalizedToken, List<INormalizedToken> list, Collection<String> collection, Set<Integer> set) {
        INormalizedToken iNormalizedToken2;
        ArrayList arrayList = Lists.newArrayList((Object[])new INormalizedToken[]{iNormalizedToken});
        String string = iNormalizedToken.getSigil();
        INormalizedToken iNormalizedToken3 = iNormalizedToken;
        do {
            int n = iNormalizedToken3.getPosition() - 1;
            LOG.debug(Integer.toString(n));
            iNormalizedToken2 = n > 0 ? list.get(n - 1) : new NullToken(iNormalizedToken3.getPosition(), string);
            arrayList.add(0, iNormalizedToken2);
        } while (collection.contains((iNormalizedToken3 = iNormalizedToken2).getNormalized()));
        return new Phrase(arrayList);
    }

    private IPhrase rightExpandedPhrase(INormalizedToken iNormalizedToken, List<INormalizedToken> list, Collection<String> collection, Set<Integer> set) {
        INormalizedToken iNormalizedToken2;
        ArrayList arrayList = Lists.newArrayList((Object[])new INormalizedToken[]{iNormalizedToken});
        INormalizedToken iNormalizedToken3 = iNormalizedToken;
        do {
            int n;
            iNormalizedToken2 = (n = iNormalizedToken3.getPosition() + 1) < list.size() ? list.get(n) : new NullToken(iNormalizedToken3.getPosition(), iNormalizedToken.getSigil());
            arrayList.add(iNormalizedToken2);
        } while (collection.contains((iNormalizedToken3 = iNormalizedToken2).getNormalized()));
        return new Phrase(arrayList);
    }

    private List<IPhrase> getUniqueTokensAsPhrases(List<INormalizedToken> list, final Collection<String> collection) {
        Predicate<INormalizedToken> predicate = new Predicate<INormalizedToken>(){

            public boolean apply(INormalizedToken iNormalizedToken) {
                return !collection.contains(iNormalizedToken.getNormalized());
            }
        };
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter(list, (Predicate)predicate), TOKEN_TO_PHRASE));
        return arrayList;
    }

    @Override
    public boolean contains(String string) {
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.transform(this.phraseCollection, PHRASE_TO_NORMALIZED));
        LOG.debug(((Object)arrayList).toString());
        return arrayList.contains(string);
    }

    @Override
    public int size() {
        return this.phraseCollection.size();
    }

    @Override
    public IPhrase getPhrase(String string) {
        for (IPhrase iPhrase : this.phraseCollection) {
            if (!iPhrase.getNormalized().equals(string)) continue;
            return iPhrase;
        }
        throw new RuntimeException("Phrase NOT found!");
    }

    @Override
    public Set<String> keys() {
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet((Iterable)Iterables.transform(this.phraseCollection, PHRASE_TO_NORMALIZED));
        return linkedHashSet;
    }
}

