/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.containers.witness;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import eu.interedition.collatex2.implementation.input.Phrase;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IPhrase;
import eu.interedition.collatex2.interfaces.ITokenIndex;
import eu.interedition.collatex2.interfaces.IWitness;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WitnessIndex0
implements ITokenIndex {
    private Logger log = LoggerFactory.getLogger(WitnessIndex0.class);
    Multiset<IPhrase> phraseBag = TreeMultiset.create();
    public static final Function<IPhrase, String> PHRASE_TO_NORMALIZED = new Function<IPhrase, String>(){

        public String apply(IPhrase iPhrase) {
            return iPhrase.getNormalized();
        }
    };

    public WitnessIndex0(Multiset<IPhrase> multiset) {
        this.phraseBag = multiset;
    }

    public WitnessIndex0(IWitness iWitness, Collection<String> collection) {
        List<INormalizedToken> list = iWitness.getTokens();
        Multimap<String, IPhrase> multimap = this.seed(list);
        Map<String, IPhrase> map = this.grow(multimap, list, collection);
        this.phraseBag.addAll(this.harvest(map));
    }

    @Override
    public boolean contains(String string) {
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.phraseBag.elementSet(), PHRASE_TO_NORMALIZED));
        this.log.debug(((Object)arrayList).toString());
        return arrayList.contains(string);
    }

    @Override
    public int size() {
        return this.phraseBag.size();
    }

    private Multimap<String, IPhrase> seed(List<INormalizedToken> list) {
        HashMultimap hashMultimap = HashMultimap.create();
        for (INormalizedToken iNormalizedToken : list) {
            hashMultimap.put((Object)iNormalizedToken.getNormalized(), (Object)new Phrase(Lists.newArrayList((Object[])new INormalizedToken[]{iNormalizedToken})));
        }
        return hashMultimap;
    }

    private Map<String, IPhrase> grow(Multimap<String, IPhrase> hashMultimap, List<INormalizedToken> list, Collection<String> collection) {
        Object object;
        HashMultimap hashMultimap2 = hashMultimap;
        do {
            object = HashMultimap.create();
            for (Object object2 : hashMultimap2.keySet()) {
                Collection collection2 = hashMultimap2.get(object2);
                if (collection2.size() == 1 && !collection.contains(object2)) {
                    IPhrase iPhrase = (IPhrase)collection2.iterator().next();
                    object.put(object2, (Object)iPhrase);
                    continue;
                }
                this.addExpandedPhrases((Multimap<String, IPhrase>)object, collection2, list, collection);
            }
        } while ((hashMultimap2 = object).entries().size() > hashMultimap2.keySet().size());
        object = Maps.newHashMap();
        for (Object object2 : hashMultimap2.entries()) {
            object.put(object2.getKey(), object2.getValue());
        }
        return object;
    }

    private void addExpandedPhrases(Multimap<String, IPhrase> multimap, Collection<IPhrase> collection, List<INormalizedToken> list, Collection<String> collection2) {
    }

    private List<IPhrase> harvest(Map<String, IPhrase> map) {
        ArrayList arrayList = Lists.newArrayList(map.values());
        Collections.sort(arrayList, Phrase.PHRASECOMPARATOR);
        return arrayList;
    }

    @Override
    public IPhrase getPhrase(String string) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public Set<String> keys() {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }
}

