/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.input;

import com.google.common.collect.Lists;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IPhrase;
import java.util.Comparator;
import java.util.List;

public class Phrase
implements IPhrase {
    private final List<INormalizedToken> tokens;
    public static final Comparator<IPhrase> PHRASECOMPARATOR = new Comparator<IPhrase>(){

        @Override
        public int compare(IPhrase iPhrase, IPhrase iPhrase2) {
            return iPhrase.compareTo(iPhrase2);
        }
    };

    public Phrase(List<INormalizedToken> list) {
        this.tokens = list;
    }

    @Override
    public String getNormalized() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (INormalizedToken iNormalizedToken : this.tokens) {
            stringBuilder.append(string).append(iNormalizedToken.getNormalized());
            string = " ";
        }
        return stringBuilder.toString();
    }

    @Override
    public String getContent() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (INormalizedToken iNormalizedToken : this.tokens) {
            stringBuilder.append(string).append(iNormalizedToken.getContent());
            string = " ";
        }
        return stringBuilder.toString();
    }

    @Override
    public INormalizedToken getFirstToken() {
        if (this.isEmpty()) {
            throw new RuntimeException("This ngram is empty!");
        }
        return this.tokens.get(0);
    }

    @Override
    public INormalizedToken getLastToken() {
        return this.tokens.get(this.tokens.size() - 1);
    }

    @Override
    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    public Phrase trim() {
        List<INormalizedToken> list = this.tokens.subList(1, this.tokens.size() - 1);
        return new Phrase(list);
    }

    public static Phrase create(INormalizedToken iNormalizedToken) {
        return new Phrase(Lists.newArrayList((Object[])new INormalizedToken[]{iNormalizedToken}));
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        return this.getContent();
    }

    @Override
    public String getSigil() {
        return this.getFirstToken().getSigil();
    }

    @Override
    public List<INormalizedToken> getTokens() {
        return this.tokens;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Phrase)) {
            return false;
        }
        return ((Object)this.tokens).equals(((Phrase)object).getTokens());
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    @Override
    public int compareTo(IPhrase iPhrase) {
        int n = this.getTokens().size() - iPhrase.getTokens().size();
        return n;
    }

    @Override
    public IPhrase createSubPhrase(int n, int n2) {
        return new Phrase(this.tokens.subList(n - 1, n2));
    }

    @Override
    public void addTokenToRight(INormalizedToken iNormalizedToken) {
        this.tokens.add(iNormalizedToken);
    }

    @Override
    public void addTokenToLeft(INormalizedToken iNormalizedToken) {
        this.tokens.add(0, iNormalizedToken);
    }
}

