/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.input.builders;

import com.google.common.collect.Lists;
import eu.interedition.collatex2.Util;
import eu.interedition.collatex2.implementation.containers.witness.NormalizedWitness;
import eu.interedition.collatex2.implementation.input.NormalizedToken;
import eu.interedition.collatex2.implementation.input.builders.WitnessPlainBuilder;
import eu.interedition.collatex2.implementation.input.builders.WitnessTeiBuilder;
import eu.interedition.collatex2.implementation.input.tokenization.WhitespaceTokenizer;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IToken;
import eu.interedition.collatex2.interfaces.ITokenNormalizer;
import eu.interedition.collatex2.interfaces.IWitness;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.SAXException;

public class WitnessBuilder {
    private final ITokenNormalizer tokenNormalizer;

    public WitnessBuilder(ITokenNormalizer iTokenNormalizer) {
        this.tokenNormalizer = iTokenNormalizer;
    }

    public IWitness build(InputStream inputStream, ContentType contentType) throws SAXException, IOException {
        if (contentType == null) {
            throw new IllegalArgumentException("Given content type is unsupported!");
        }
        switch (contentType) {
            case TEXT_PLAIN: {
                return new WitnessPlainBuilder(this.tokenNormalizer).build(inputStream);
            }
            case TEXT_XML: {
                return new WitnessTeiBuilder(this.tokenNormalizer).build(inputStream);
            }
        }
        throw new IllegalArgumentException("Given content type is unsupported!");
    }

    public IWitness build(String string, String string2) {
        WhitespaceTokenizer whitespaceTokenizer = new WhitespaceTokenizer();
        Iterator<IToken> iterator = whitespaceTokenizer.tokenize(string, string2).iterator();
        ArrayList arrayList = Lists.newArrayList();
        int n = 1;
        while (iterator.hasNext()) {
            IToken iToken = iterator.next();
            if (iToken.getContent().equals("")) continue;
            INormalizedToken iNormalizedToken = (INormalizedToken)this.tokenNormalizer.apply(iToken);
            arrayList.add(new NormalizedToken(string, iToken.getContent(), n, iNormalizedToken.getNormalized()));
            ++n;
        }
        return new NormalizedWitness(string, arrayList);
    }

    public IWitness build(String string) {
        return this.build(Util.generateRandomId(), string);
    }

    public IWitness[] buildWitnesses(String ... stringArray) {
        IWitness[] iWitnessArray = new IWitness[stringArray.length];
        for (int i = 0; i < iWitnessArray.length; ++i) {
            iWitnessArray[i] = this.build("" + (i + 1), stringArray[i]);
        }
        return iWitnessArray;
    }

    public static enum ContentType {
        TEXT_XML("text/xml"),
        TEXT_PLAIN("text/plain");

        private String type;

        private ContentType(String string2) {
            this.type = string2;
        }

        public static ContentType value(String string) {
            for (ContentType contentType : ContentType.values()) {
                if (!string.equals(contentType.type)) continue;
                return contentType;
            }
            return null;
        }
    }
}

