/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.output.apparatus;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.interedition.collatex2.implementation.output.apparatus.ApparatusEntry;
import eu.interedition.collatex2.interfaces.ColumnState;
import eu.interedition.collatex2.interfaces.IAlignmentTable;
import eu.interedition.collatex2.interfaces.IColumn;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelSegmentationApparatus {
    private static Logger logger = LoggerFactory.getLogger(ParallelSegmentationApparatus.class);
    private final List<ApparatusEntry> entries;
    private List<String> sigla;

    public List<ApparatusEntry> getEntries() {
        return this.entries;
    }

    public List<String> getSigla() {
        if (this.sigla == null) {
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
            for (ApparatusEntry apparatusEntry : this.entries) {
                linkedHashSet.addAll(apparatusEntry.getSigla());
            }
            this.sigla = Lists.newArrayList((Iterable)linkedHashSet);
        }
        return this.sigla;
    }

    public static ParallelSegmentationApparatus build(IAlignmentTable iAlignmentTable) {
        ArrayList arrayList = Lists.newArrayList();
        ApparatusEntry apparatusEntry = null;
        IColumn iColumn = null;
        for (IColumn iColumn2 : iAlignmentTable.getColumns()) {
            List<String> list;
            boolean bl;
            boolean bl2 = bl = iColumn == null || !iColumn.getInternalColumn().getState().equals((Object)iColumn2.getInternalColumn().getState()) || !((Object)iColumn2.getInternalColumn().getSigla()).equals(iColumn.getInternalColumn().getSigla());
            if (iColumn != null && iColumn.getInternalColumn().getState() == ColumnState.VARIANT && iColumn.getInternalColumn().getSigla().size() > iColumn2.getInternalColumn().getSigla().size() && iColumn.getInternalColumn().getSigla().containsAll(iColumn2.getInternalColumn().getSigla())) {
                bl = false;
            }
            if (bl) {
                list = iAlignmentTable.getSigla();
                logger.debug("!!!" + list);
                apparatusEntry = new ApparatusEntry(list);
                arrayList.add(apparatusEntry);
            }
            list = iAlignmentTable.getSigla();
            for (String string : list) {
                if (!iColumn2.getInternalColumn().containsWitness(string)) continue;
                INormalizedToken iNormalizedToken = iColumn2.getInternalColumn().getToken(string);
                apparatusEntry.addToken(string, iNormalizedToken);
            }
            iColumn = iColumn2;
        }
        return new ParallelSegmentationApparatus(arrayList);
    }

    private ParallelSegmentationApparatus(List<ApparatusEntry> list) {
        this.entries = list;
    }
}

