/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.output.jgraph;

import com.google.common.collect.Maps;
import eu.interedition.collatex2.implementation.output.jgraph.JVariantGraph;
import eu.interedition.collatex2.implementation.output.jgraph.JVariantGraphEdge;
import eu.interedition.collatex2.implementation.output.jgraph.JVariantGraphVertex;
import eu.interedition.collatex2.interfaces.IJVariantGraph;
import eu.interedition.collatex2.interfaces.IJVariantGraphVertex;
import eu.interedition.collatex2.interfaces.IVariantGraph;
import eu.interedition.collatex2.interfaces.IVariantGraphEdge;
import eu.interedition.collatex2.interfaces.IVariantGraphVertex;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVariantGraphCreator {
    private static final Logger LOG = LoggerFactory.getLogger(JVariantGraphCreator.class);
    private static IJVariantGraph joinedGraph;
    private static Map<IVariantGraphVertex, IJVariantGraphVertex> vertexMap;

    public static IJVariantGraph parallelSegmentate(IVariantGraph iVariantGraph) {
        joinedGraph = JVariantGraph.create();
        vertexMap = Maps.newHashMap();
        IVariantGraphVertex iVariantGraphVertex = iVariantGraph.getStartVertex();
        JVariantGraphVertex jVariantGraphVertex = new JVariantGraphVertex(iVariantGraphVertex);
        joinedGraph.setStartVertex(jVariantGraphVertex);
        vertexMap.put(iVariantGraphVertex, jVariantGraphVertex);
        IVariantGraphVertex iVariantGraphVertex2 = iVariantGraph.getEndVertex();
        JVariantGraphVertex jVariantGraphVertex2 = new JVariantGraphVertex(iVariantGraphVertex2);
        joinedGraph.setEndVertex(jVariantGraphVertex2);
        vertexMap.put(iVariantGraphVertex2, jVariantGraphVertex2);
        Set set = iVariantGraph.outgoingEdgesOf(iVariantGraphVertex);
        for (IVariantGraphEdge iVariantGraphEdge : set) {
            JVariantGraphCreator.processEdge(iVariantGraphEdge, iVariantGraph, jVariantGraphVertex);
        }
        return joinedGraph;
    }

    private static void processEdge(IVariantGraphEdge iVariantGraphEdge, IVariantGraph iVariantGraph, IJVariantGraphVertex iJVariantGraphVertex) {
        IJVariantGraphVertex iJVariantGraphVertex2;
        IVariantGraphVertex iVariantGraphVertex = (IVariantGraphVertex)iVariantGraph.getEdgeTarget(iVariantGraphEdge);
        if (vertexMap.containsKey(iVariantGraphVertex)) {
            iJVariantGraphVertex2 = vertexMap.get(iVariantGraphVertex);
        } else {
            iJVariantGraphVertex2 = new JVariantGraphVertex(iVariantGraphVertex);
            vertexMap.put(iVariantGraphVertex, iJVariantGraphVertex2);
            joinedGraph.addVertex(iJVariantGraphVertex2);
        }
        JVariantGraphEdge jVariantGraphEdge = new JVariantGraphEdge(iJVariantGraphVertex, iJVariantGraphVertex2, iVariantGraphEdge);
        joinedGraph.addEdge(iJVariantGraphVertex, iJVariantGraphVertex2, jVariantGraphEdge);
        JVariantGraphCreator.checkNextVertex(iVariantGraph, vertexMap, iVariantGraphVertex, iJVariantGraphVertex2);
    }

    private static void checkNextVertex(IVariantGraph iVariantGraph, Map<IVariantGraphVertex, IJVariantGraphVertex> map, IVariantGraphVertex iVariantGraphVertex, IJVariantGraphVertex iJVariantGraphVertex) {
        Set set = iVariantGraph.outgoingEdgesOf(iVariantGraphVertex);
        if (set.size() == 1) {
            IVariantGraphVertex iVariantGraphVertex2 = (IVariantGraphVertex)iVariantGraph.getEdgeTarget(set.iterator().next());
            if (JVariantGraphCreator.vertexHasOneIncomingEdge(iVariantGraph, iVariantGraphVertex2) && JVariantGraphCreator.vertexHasOutgoingEdges(iVariantGraph, iVariantGraphVertex2)) {
                if (!map.containsKey(iVariantGraphVertex2)) {
                    iJVariantGraphVertex.addVariantGraphVertex(iVariantGraphVertex2);
                }
                map.put(iVariantGraphVertex2, iJVariantGraphVertex);
                JVariantGraphCreator.checkNextVertex(iVariantGraph, map, iVariantGraphVertex2, iJVariantGraphVertex);
            } else {
                JVariantGraphCreator.processEdge((IVariantGraphEdge)set.iterator().next(), iVariantGraph, iJVariantGraphVertex);
            }
        } else {
            for (IVariantGraphEdge iVariantGraphEdge : set) {
                JVariantGraphCreator.processEdge(iVariantGraphEdge, iVariantGraph, iJVariantGraphVertex);
            }
        }
    }

    private static boolean vertexHasOneIncomingEdge(IVariantGraph iVariantGraph, IVariantGraphVertex iVariantGraphVertex) {
        return iVariantGraph.inDegreeOf(iVariantGraphVertex) == 1;
    }

    private static boolean vertexHasOutgoingEdges(IVariantGraph iVariantGraph, IVariantGraphVertex iVariantGraphVertex) {
        return iVariantGraph.outDegreeOf(iVariantGraphVertex) > 0;
    }
}

