/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.output.table;

import com.google.common.collect.Lists;
import eu.interedition.collatex2.implementation.output.table.Cell;
import eu.interedition.collatex2.implementation.output.table.Row;
import eu.interedition.collatex2.interfaces.ICell;
import eu.interedition.collatex2.interfaces.IColumn;
import eu.interedition.collatex2.interfaces.IRow;
import eu.interedition.collatex2.interfaces.IWitness;
import java.util.ArrayList;
import java.util.List;

public class BaseAlignmentTable {
    protected final List<String> sigla = Lists.newArrayList();
    protected final List<IColumn> columns = Lists.newArrayList();

    public final List<IRow> getRows() {
        ArrayList arrayList = Lists.newArrayList();
        for (String string : this.getSigla()) {
            arrayList.add(this.getRow(string));
        }
        return arrayList;
    }

    public final IRow getRow(String string) {
        ArrayList arrayList = Lists.newArrayList();
        for (IColumn iColumn : this.columns) {
            Cell cell = new Cell(iColumn.getInternalColumn(), string);
            arrayList.add(cell);
        }
        return new Row(string, arrayList);
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final int size() {
        return this.getColumns().size();
    }

    public final List<IColumn> getColumns() {
        return this.columns;
    }

    public List<String> getSigla() {
        return this.sigla;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (IRow iRow : this.getRows()) {
            stringBuilder.append(iRow.getSigil()).append(": ");
            String string = "";
            for (ICell iCell : iRow) {
                stringBuilder.append(string).append(this.cellToString(iCell));
                string = "|";
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    String cellToString(ICell iCell) {
        if (iCell.isEmpty()) {
            return " ";
        }
        return iCell.getToken().getNormalized().toString();
    }

    public IRow getRow(IWitness iWitness) {
        return this.getRow(iWitness.getSigil());
    }
}

