/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.output.table;

import com.google.common.collect.Lists;
import eu.interedition.collatex2.implementation.output.rankedgraph.IRankedVariantGraphVertex;
import eu.interedition.collatex2.implementation.output.rankedgraph.VariantGraphRanker;
import eu.interedition.collatex2.implementation.output.table.BaseAlignmentTable;
import eu.interedition.collatex2.implementation.output.table.VariantGraphBasedColumn;
import eu.interedition.collatex2.interfaces.IAlignmentTable;
import eu.interedition.collatex2.interfaces.IColumn;
import eu.interedition.collatex2.interfaces.IVariantGraph;
import eu.interedition.collatex2.interfaces.IVariantGraphVertex;
import eu.interedition.collatex2.interfaces.IWitness;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RankedGraphBasedAlignmentTable
extends BaseAlignmentTable
implements IAlignmentTable {
    private final IVariantGraph graph;

    public RankedGraphBasedAlignmentTable(IVariantGraph iVariantGraph) {
        this.graph = iVariantGraph;
        this.init();
    }

    private void init() {
        VariantGraphRanker variantGraphRanker = new VariantGraphRanker(this.graph);
        Iterator<IRankedVariantGraphVertex> iterator = variantGraphRanker.iterator();
        Iterator<IVariantGraphVertex> iterator2 = this.graph.iterator();
        iterator2.next();
        while (iterator.hasNext()) {
            IRankedVariantGraphVertex iRankedVariantGraphVertex = iterator.next();
            IVariantGraphVertex iVariantGraphVertex = iterator2.next();
            if (iVariantGraphVertex.equals(this.graph.getEndVertex())) continue;
            int n = iRankedVariantGraphVertex.getRank();
            if (n > this.columns.size()) {
                this.addNewColumn(iVariantGraphVertex, iRankedVariantGraphVertex.getRank());
                continue;
            }
            ((IColumn)this.columns.get(n - 1)).addVertex(iVariantGraphVertex);
        }
    }

    private IColumn addNewColumn(IVariantGraphVertex iVariantGraphVertex, int n) {
        VariantGraphBasedColumn variantGraphBasedColumn = new VariantGraphBasedColumn(iVariantGraphVertex, n);
        this.columns.add(variantGraphBasedColumn);
        return variantGraphBasedColumn;
    }

    @Override
    public final List<String> getSigla() {
        List<IWitness> list = this.graph.getWitnesses();
        ArrayList arrayList = Lists.newArrayList();
        for (IWitness iWitness : list) {
            arrayList.add(iWitness.getSigil());
        }
        return arrayList;
    }
}

