/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.vg_alignment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.interedition.collatex2.implementation.vg_alignment.Sequence;
import eu.interedition.collatex2.implementation.vg_alignment.TokenMatch;
import eu.interedition.collatex2.implementation.vg_alignment.TokenPair;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IPhrase;
import eu.interedition.collatex2.interfaces.ITokenContainer;
import eu.interedition.collatex2.interfaces.ITokenIndex;
import eu.interedition.collatex2.interfaces.ITokenMatch;
import eu.interedition.collatex2.interfaces.ITokenMatcher;
import eu.interedition.collatex2.interfaces.IWitness;
import eu.interedition.collatex2.legacy.indexing.NullToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenIndexMatcher
implements ITokenMatcher {
    static final Logger LOG = LoggerFactory.getLogger(TokenIndexMatcher.class);
    private final ITokenContainer base;

    public TokenIndexMatcher(ITokenContainer iTokenContainer) {
        this.base = iTokenContainer;
    }

    @Override
    public List<ITokenMatch> getMatches(IWitness iWitness) {
        List<String> list = this.combineRepeatedTokens(iWitness);
        ITokenIndex iTokenIndex = this.base.getTokenIndex(list);
        return this.findMatches(iTokenIndex, iWitness.getTokenIndex(list), iWitness);
    }

    private List<String> combineRepeatedTokens(IWitness iWitness) {
        HashSet hashSet = Sets.newHashSet();
        hashSet.addAll(this.base.getRepeatedTokens());
        hashSet.addAll(iWitness.getRepeatedTokens());
        return Lists.newArrayList((Iterable)hashSet);
    }

    private List<ITokenMatch> findMatches(ITokenIndex iTokenIndex, ITokenIndex iTokenIndex2, IWitness iWitness) {
        ArrayList arrayList = Lists.newArrayList();
        Set<String> set = iTokenIndex2.keys();
        for (String string : set) {
            if (!iTokenIndex.contains(string)) continue;
            IPhrase iPhrase = iTokenIndex2.getPhrase(string);
            IPhrase iPhrase2 = iTokenIndex.getPhrase(string);
            arrayList.add(new Sequence(iPhrase2, iPhrase));
        }
        LOG.debug("unfiltered matches: " + arrayList);
        return this.joinOverlappingMatches(arrayList, iWitness);
    }

    private List<ITokenMatch> joinOverlappingMatches(List<Sequence> list, IWitness iWitness) {
        List<ITokenMatch> list2 = this.filterMatchesBasedOnPositionMatches(list, iWitness);
        LOG.debug("filtered matches: " + list2);
        return list2;
    }

    private List<ITokenMatch> filterMatchesBasedOnPositionMatches(List<Sequence> list, IWitness iWitness) {
        Object object;
        Object object2;
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        List<Sequence> list2 = this.filterAwaySecondChoicesMultipleTokensOneColumn(this.filterAwaySecondChoicesMultipleColumnsOneToken(list));
        for (Sequence object3 : list2) {
            INormalizedToken iNormalizedToken;
            ArrayList arrayList = Lists.newArrayList();
            object2 = object3.getTablePhrase();
            object = object3.getPhrase();
            Iterator<INormalizedToken> iterator = object.getTokens().iterator();
            for (INormalizedToken iNormalizedToken2 : object2.getTokens()) {
                iNormalizedToken = iterator.next();
                if (iNormalizedToken2 instanceof NullToken) continue;
                arrayList.add(new TokenPair(iNormalizedToken2, iNormalizedToken));
            }
            for (TokenPair tokenPair : arrayList) {
                iNormalizedToken = tokenPair.tableToken;
                INormalizedToken iNormalizedToken3 = tokenPair.witnessToken;
                linkedHashMap.put(iNormalizedToken3, iNormalizedToken);
            }
        }
        ArrayList arrayList = Lists.newArrayList();
        for (INormalizedToken iNormalizedToken : iWitness.getTokens()) {
            object2 = (INormalizedToken)linkedHashMap.get(iNormalizedToken);
            if (object2 == null) continue;
            object = new TokenMatch((INormalizedToken)object2, iNormalizedToken);
            arrayList.add(object);
        }
        return arrayList;
    }

    private List<Sequence> filterAwaySecondChoicesMultipleColumnsOneToken(List<Sequence> list) {
        ArrayList arrayList = Lists.newArrayList();
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (Sequence sequence : list) {
            ArrayList arrayList2 = Lists.newArrayList();
            IPhrase iPhrase = sequence.getTablePhrase();
            IPhrase iPhrase2 = sequence.getPhrase();
            Iterator<INormalizedToken> iterator = iPhrase2.getTokens().iterator();
            for (INormalizedToken iNormalizedToken : iPhrase.getTokens()) {
                Object object = iterator.next();
                if (iNormalizedToken instanceof NullToken) continue;
                arrayList2.add(new TokenPair(iNormalizedToken, (INormalizedToken)object));
            }
            boolean bl = false;
            for (Object object : arrayList2) {
                INormalizedToken iNormalizedToken = ((TokenPair)object).tableToken;
                INormalizedToken iNormalizedToken2 = ((TokenPair)object).witnessToken;
                if (linkedHashMap.containsKey(iNormalizedToken2)) {
                    INormalizedToken iNormalizedToken3 = (INormalizedToken)linkedHashMap.get(iNormalizedToken2);
                    if (iNormalizedToken3 == iNormalizedToken) continue;
                    bl = true;
                    continue;
                }
                linkedHashMap.put(iNormalizedToken2, iNormalizedToken);
            }
            if (!bl) {
                arrayList.add(sequence);
                continue;
            }
            LOG.debug("Phrase '" + iPhrase2 + "' is an alternative! skipping...");
        }
        return arrayList;
    }

    private List<Sequence> filterAwaySecondChoicesMultipleTokensOneColumn(List<Sequence> list) {
        ArrayList arrayList = Lists.newArrayList();
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (Sequence sequence : list) {
            ArrayList arrayList2 = Lists.newArrayList();
            IPhrase iPhrase = sequence.getTablePhrase();
            IPhrase iPhrase2 = sequence.getPhrase();
            Iterator<INormalizedToken> iterator = iPhrase2.getTokens().iterator();
            for (INormalizedToken iNormalizedToken : iPhrase.getTokens()) {
                Object object = iterator.next();
                if (iNormalizedToken instanceof NullToken) continue;
                arrayList2.add(new TokenPair(iNormalizedToken, (INormalizedToken)object));
            }
            boolean bl = false;
            for (Object object : arrayList2) {
                INormalizedToken iNormalizedToken = ((TokenPair)object).tableToken;
                INormalizedToken iNormalizedToken2 = ((TokenPair)object).witnessToken;
                if (linkedHashMap.containsKey(iNormalizedToken)) {
                    INormalizedToken iNormalizedToken3 = (INormalizedToken)linkedHashMap.get(iNormalizedToken);
                    if (iNormalizedToken3 == iNormalizedToken2) continue;
                    bl = true;
                    continue;
                }
                linkedHashMap.put(iNormalizedToken, iNormalizedToken2);
            }
            if (!bl) {
                arrayList.add(sequence);
                continue;
            }
            LOG.debug("Phrase '" + iPhrase2 + "' is an alternative! skipping...");
        }
        return arrayList;
    }
}

