/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.vg_analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.interedition.collatex2.implementation.input.Phrase;
import eu.interedition.collatex2.implementation.vg_alignment.IAlignment2;
import eu.interedition.collatex2.implementation.vg_alignment.Sequence;
import eu.interedition.collatex2.implementation.vg_analysis.ISequence;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.ITokenContainer;
import eu.interedition.collatex2.interfaces.ITokenMatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SequenceDetection2 {
    private final List<ITokenMatch> tokenMatches;
    private final ITokenContainer base;
    private final ITokenContainer witness;

    public SequenceDetection2(List<ITokenMatch> list, ITokenContainer iTokenContainer, ITokenContainer iTokenContainer2) {
        this.tokenMatches = list;
        this.base = iTokenContainer;
        this.witness = iTokenContainer2;
    }

    public SequenceDetection2(IAlignment2 iAlignment2, ITokenContainer iTokenContainer, ITokenContainer iTokenContainer2) {
        this.base = iTokenContainer;
        this.witness = iTokenContainer2;
        this.tokenMatches = iAlignment2.getTokenMatches();
    }

    public List<ISequence> chainTokenMatches() {
        Map<ITokenMatch, ITokenMatch> map = this.buildPreviousMatchMap();
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = Lists.newArrayList();
        for (ITokenMatch iTokenMatch : this.tokenMatches) {
            ITokenMatch iTokenMatch2 = map.get(iTokenMatch);
            if (iTokenMatch2 == null || !this.base.isNear(iTokenMatch2.getBaseToken(), iTokenMatch.getBaseToken()) || !this.witness.isNear(iTokenMatch2.getWitnessToken(), iTokenMatch.getWitnessToken())) {
                this.createAndAddChainedMatch(arrayList, arrayList2, arrayList3);
                arrayList = Lists.newArrayList();
                arrayList2 = Lists.newArrayList();
            }
            INormalizedToken iNormalizedToken = iTokenMatch.getTokenA();
            INormalizedToken iNormalizedToken2 = iTokenMatch.getTokenB();
            arrayList.add(iNormalizedToken);
            arrayList2.add(iNormalizedToken2);
        }
        this.createAndAddChainedMatch(arrayList, arrayList2, arrayList3);
        return arrayList3;
    }

    private void createAndAddChainedMatch(List<INormalizedToken> list, List<INormalizedToken> list2, List<ISequence> list3) {
        if (list != null && !list.isEmpty()) {
            Phrase phrase = new Phrase(list);
            Phrase phrase2 = new Phrase(list2);
            Sequence sequence = new Sequence(phrase, phrase2);
            list3.add(sequence);
        }
    }

    private Map<ITokenMatch, ITokenMatch> buildPreviousMatchMap() {
        return this.buildPreviousMatchMap(this.tokenMatches);
    }

    private Map<ITokenMatch, ITokenMatch> buildPreviousMatchMap(List<ITokenMatch> list) {
        HashMap hashMap = Maps.newHashMap();
        ITokenMatch iTokenMatch = null;
        for (ITokenMatch iTokenMatch2 : list) {
            hashMap.put(iTokenMatch2, iTokenMatch);
            iTokenMatch = iTokenMatch2;
        }
        return hashMap;
    }
}

