/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.legacy.gapdetection;

import eu.interedition.collatex2.interfaces.IColumns;
import eu.interedition.collatex2.interfaces.IGap;
import eu.interedition.collatex2.interfaces.IInternalColumn;
import eu.interedition.collatex2.interfaces.IPhrase;

public class Gap
implements IGap {
    private final IColumns columns;
    private final IPhrase phrase;
    private final IInternalColumn nextColumn;

    public Gap(IColumns iColumns, IPhrase iPhrase, IInternalColumn iInternalColumn) {
        this.columns = iColumns;
        this.phrase = iPhrase;
        this.nextColumn = iInternalColumn;
    }

    public String toString() {
        if (this.isAddition()) {
            return "\"" + this.phrase.getNormalized() + "\" added";
        }
        if (this.isOmission()) {
            return this.columns.toString() + " omitted";
        }
        return this.columns.toString() + " -> " + this.phrase.getSigil() + ": " + this.phrase.getNormalized();
    }

    @Override
    public IColumns getColumns() {
        return this.columns;
    }

    @Override
    public IPhrase getPhrase() {
        return this.phrase;
    }

    @Override
    public boolean isEmpty() {
        return this.columns.isEmpty() && this.phrase.isEmpty();
    }

    @Override
    public boolean isReplacement() {
        return !this.columns.isEmpty() && !this.phrase.isEmpty();
    }

    @Override
    public boolean isAddition() {
        return this.columns.isEmpty() && !this.phrase.isEmpty();
    }

    @Override
    public boolean isOmission() {
        return !this.columns.isEmpty() && this.phrase.isEmpty();
    }

    @Override
    public IInternalColumn getNextColumn() {
        return this.nextColumn;
    }
}

