/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.legacy.gapdetection;

import com.google.common.collect.Lists;
import eu.interedition.collatex2.interfaces.IAlignmentTable;
import eu.interedition.collatex2.interfaces.IColumns;
import eu.interedition.collatex2.interfaces.IGap;
import eu.interedition.collatex2.interfaces.IInternalColumn;
import eu.interedition.collatex2.interfaces.IMatch;
import eu.interedition.collatex2.interfaces.IPhrase;
import eu.interedition.collatex2.interfaces.IWitness;
import eu.interedition.collatex2.legacy.gapdetection.Gap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GapDetection {
    static Logger LOG = LoggerFactory.getLogger(GapDetection.class);

    public static List<IGap> detectGap(List<IMatch> list, IAlignmentTable iAlignmentTable, IWitness iWitness) {
        List<IColumns> list2 = GapDetection.calculateMatchingColumnsForA(list);
        List<IPhrase> list3 = GapDetection.calculateMatchingPhrasesForB(list);
        List<IColumns> list4 = GapDetection.calculateGapColumnsForA(list2, iAlignmentTable);
        List<IPhrase> list5 = GapDetection.calculateGapPhrasesFor(list3, iWitness);
        List<IInternalColumn> list6 = GapDetection.getNextColumns(list2);
        ArrayList arrayList = Lists.newArrayList();
        for (int i = 0; i < list4.size(); ++i) {
            IColumns iColumns = list4.get(i);
            IPhrase iPhrase = list5.get(i);
            IInternalColumn iInternalColumn = list6.get(i);
            Gap gap = new Gap(iColumns, iPhrase, iInternalColumn);
            arrayList.add(gap);
        }
        return arrayList;
    }

    private static List<IColumns> calculateMatchingColumnsForA(List<IMatch> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (IMatch iMatch : list) {
            arrayList.add(iMatch.getColumns());
        }
        return arrayList;
    }

    private static List<IPhrase> calculateMatchingPhrasesForB(List<IMatch> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (IMatch iMatch : list) {
            arrayList.add(iMatch.getPhrase());
        }
        return arrayList;
    }

    private static List<IColumns> calculateGapColumnsForA(List<IColumns> list, IAlignmentTable iAlignmentTable) {
        LOG.debug(iAlignmentTable.toString());
        int n = 1;
        IColumns iColumns = null;
        ArrayList arrayList = Lists.newArrayList();
        for (IColumns iColumns2 : list) {
            int n2 = iColumns2.getBeginPosition();
            iColumns = iColumns2;
            n = 1 + iColumns.getEndPosition();
        }
        return arrayList;
    }

    private static List<IPhrase> calculateGapPhrasesFor(List<IPhrase> list, IWitness iWitness) {
        LOG.debug(iWitness.toString());
        int n = 1;
        IPhrase iPhrase = null;
        ArrayList arrayList = Lists.newArrayList();
        Iterator<IPhrase> iterator = list.iterator();
        while (iterator.hasNext()) {
            IPhrase iPhrase2;
            iPhrase = iPhrase2 = iterator.next();
        }
        arrayList.add(iWitness.createPhrase(n, iWitness.size()));
        return arrayList;
    }

    private static List<IInternalColumn> getNextColumns(List<IColumns> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (IColumns iColumns : list) {
            IInternalColumn iInternalColumn = iColumns.getFirstColumn();
            arrayList.add(iInternalColumn);
        }
        arrayList.add(null);
        return arrayList;
    }
}

