/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.legacy.indexing;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.interedition.collatex2.implementation.input.Token;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IWitness;
import eu.interedition.collatex2.legacy.indexing.BiGram;
import eu.interedition.collatex2.legacy.indexing.NullToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BiGramIndex
implements Iterable<BiGram> {
    private final List<BiGram> biGrams1;

    public BiGramIndex(List<BiGram> list) {
        this.biGrams1 = list;
    }

    public BiGramIndex() {
        this.biGrams1 = Lists.newArrayList();
    }

    public Map<String, BiGram> normalize() {
        Map<String, BiGram> map = BiGramIndex.normalize(this.biGrams1);
        return map;
    }

    public static BiGramIndex create(IWitness iWitness) {
        return BiGramIndex.create(iWitness.getTokens());
    }

    private static Map<String, BiGram> normalize(List<BiGram> list) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (BiGram biGram : list) {
            linkedHashMap.put(biGram.getNormalized(), biGram);
        }
        return linkedHashMap;
    }

    public Set<String> keys() {
        Map<String, BiGram> map = BiGramIndex.normalize(this.biGrams1);
        return map.keySet();
    }

    public BiGram get(String string) {
        Map<String, BiGram> map = BiGramIndex.normalize(this.biGrams1);
        return map.get(string);
    }

    public BiGramIndex removeBiGramsWithToken(final Token token) {
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.filter(this.biGrams1, (Predicate)new Predicate<BiGram>(){

            public boolean apply(BiGram biGram) {
                return !biGram.contains(token);
            }
        }));
        return new BiGramIndex(arrayList);
    }

    public int size() {
        return this.biGrams1.size();
    }

    public List<BiGram> getBiGrams() {
        return this.biGrams1;
    }

    public BiGram get(int n) {
        return this.biGrams1.get(n);
    }

    @Override
    public Iterator<BiGram> iterator() {
        return this.biGrams1.iterator();
    }

    public static BiGramIndex create(List<INormalizedToken> list) {
        if (list.isEmpty()) {
            return new BiGramIndex();
        }
        ArrayList arrayList = Lists.newArrayList(list);
        arrayList.add(new NullToken(list.size() + 1, list.get(0).getSigil()));
        INormalizedToken iNormalizedToken = new NullToken(0, list.get(0).getSigil());
        ArrayList arrayList2 = Lists.newArrayList();
        for (INormalizedToken iNormalizedToken2 : arrayList) {
            BiGram biGram = new BiGram(iNormalizedToken, iNormalizedToken2);
            arrayList2.add(biGram);
            iNormalizedToken = iNormalizedToken2;
        }
        return new BiGramIndex(arrayList2);
    }
}

