/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.legacy.indexing;

import com.google.common.collect.Lists;
import eu.interedition.collatex2.interfaces.IColumns;
import eu.interedition.collatex2.interfaces.IInternalColumn;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IPhrase;
import java.util.List;

public class Columns
implements IColumns {
    private final List<IInternalColumn> columns;

    public Columns(List<IInternalColumn> list) {
        this.columns = list;
    }

    public Columns() {
        this.columns = Lists.newArrayList();
    }

    @Override
    public void addMatchPhrase(IPhrase iPhrase) {
        if (iPhrase.size() > this.columns.size()) {
            throw new RuntimeException("The phrase to be placed in the table is longer than columns!");
        }
        List<INormalizedToken> list = iPhrase.getTokens();
        for (int i = 0; i < iPhrase.size(); ++i) {
            IInternalColumn iInternalColumn = this.columns.get(i);
            INormalizedToken iNormalizedToken = list.get(i);
            iInternalColumn.addMatch(iNormalizedToken);
        }
    }

    @Override
    public void addVariantPhrase(IPhrase iPhrase) {
        if (iPhrase.size() > this.columns.size()) {
            throw new RuntimeException("The phrase to be placed in the table is longer than columns!");
        }
        List<INormalizedToken> list = iPhrase.getTokens();
        for (int i = 0; i < iPhrase.size(); ++i) {
            IInternalColumn iInternalColumn = this.columns.get(i);
            INormalizedToken iNormalizedToken = list.get(i);
            iInternalColumn.addVariant(iNormalizedToken);
        }
    }

    @Override
    public int getBeginPosition() {
        return this.getFirstColumn().getPosition();
    }

    @Override
    public int getEndPosition() {
        return this.getLastColumn().getPosition();
    }

    @Override
    public IInternalColumn getFirstColumn() {
        if (this.isEmpty()) {
            throw new RuntimeException("Columns are empty!");
        }
        return this.columns.get(0);
    }

    @Override
    public IInternalColumn getLastColumn() {
        if (this.isEmpty()) {
            throw new RuntimeException("Columns are empty!");
        }
        return this.columns.get(this.columns.size() - 1);
    }

    @Override
    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (IInternalColumn iInternalColumn : this.columns) {
            stringBuffer.append(string);
            stringBuffer.append(iInternalColumn.toString());
            string = " ";
        }
        return stringBuffer.toString();
    }

    @Override
    public int size() {
        return this.columns.size();
    }

    @Override
    public List<IInternalColumn> getColumns() {
        return this.columns;
    }
}

