/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.legacy.indexing;

import com.google.common.collect.Lists;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IWitness;
import eu.interedition.collatex2.legacy.indexing.BiGram;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NGram
implements Iterable<INormalizedToken> {
    private final List<INormalizedToken> tokens;

    public NGram(List<INormalizedToken> list) {
        this.tokens = list;
    }

    public static NGram create(BiGram biGram) {
        ArrayList arrayList = Lists.newArrayList((Object[])new INormalizedToken[]{biGram.getFirstToken(), biGram.getLastToken()});
        return new NGram(arrayList);
    }

    public static NGram create(IWitness iWitness, int n, int n2) {
        List<INormalizedToken> list = iWitness.createPhrase(n, n2).getTokens();
        return new NGram(list);
    }

    public void add(BiGram biGram) {
        this.tokens.add(biGram.getLastToken());
    }

    public String getNormalized() {
        String string = "";
        String string2 = "";
        for (INormalizedToken iNormalizedToken : this.tokens) {
            string = string + string2 + iNormalizedToken.getNormalized();
            string2 = " ";
        }
        return string;
    }

    public INormalizedToken getFirstToken() {
        if (this.isEmpty()) {
            throw new RuntimeException("This ngram is empty!");
        }
        return this.tokens.get(0);
    }

    public INormalizedToken getLastToken() {
        return this.tokens.get(this.tokens.size() - 1);
    }

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    public NGram trim() {
        List<INormalizedToken> list = this.tokens.subList(1, this.tokens.size() - 1);
        return new NGram(list);
    }

    @Override
    public Iterator<INormalizedToken> iterator() {
        return this.tokens.iterator();
    }
}

