/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.dag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.jgrapht.graph.SimpleDirectedGraph;

public class DirectedAcyclicGraph<V, E>
extends SimpleDirectedGraph<V, E> {
    private static final long serialVersionUID = 4522128427004938150L;
    private TopoComparator<V> topoComparator;
    private TopoOrderMapping<V> topoOrderMap;
    private int maxTopoIndex = 0;
    private int minTopoIndex = 0;
    private long topologyUpdateCount = 0L;
    private VisitedFactory visitedFactory = new VisitedBitSetImpl();
    private TopoOrderMappingFactory<V> topoOrderFactory = new TopoVertexBiMap();

    public DirectedAcyclicGraph(Class<? extends E> clazz) {
        super(clazz);
        this.initialize();
    }

    DirectedAcyclicGraph(Class<? extends E> clazz, VisitedFactory visitedFactory, TopoOrderMappingFactory<V> topoOrderMappingFactory) {
        super(clazz);
        if (visitedFactory != null) {
            this.visitedFactory = visitedFactory;
        }
        if (topoOrderMappingFactory != null) {
            this.topoOrderFactory = topoOrderMappingFactory;
        }
        this.initialize();
    }

    private void initialize() {
        this.topoOrderMap = this.topoOrderFactory.getTopoOrderMapping();
        this.topoComparator = new TopoComparator<V>(this.topoOrderMap);
    }

    public Iterator<V> iterator() {
        return new TopoIterator();
    }

    public boolean addVertex(V v) {
        boolean bl = super.addVertex(v);
        if (bl) {
            ++this.maxTopoIndex;
            this.topoOrderMap.putVertex(this.maxTopoIndex, v);
            ++this.topologyUpdateCount;
        }
        return bl;
    }

    public boolean addVertex(V v, boolean bl) {
        boolean bl2 = super.addVertex(v);
        if (bl2) {
            int n = bl ? ++this.maxTopoIndex : --this.minTopoIndex;
            this.topoOrderMap.putVertex(n, v);
            ++this.topologyUpdateCount;
        }
        return bl2;
    }

    public E addDagEdge(V v, V v2) throws CycleFoundException {
        Integer n = this.topoOrderMap.getTopologicalIndex(v2);
        Integer n2 = this.topoOrderMap.getTopologicalIndex(v);
        if (n == null || n2 == null) {
            throw new IllegalArgumentException("vertices must be in the graph already!");
        }
        if (n < n2) {
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            Region region = new Region(n, n2);
            Visited visited = this.visitedFactory.getInstance(region);
            this.dfsF(v2, hashSet, visited, region);
            this.dfsB(v, hashSet2, visited, region);
            this.reorder(hashSet, hashSet2, visited);
            ++this.topologyUpdateCount;
        }
        return (E)super.addEdge(v, v2);
    }

    public E addEdge(V v, V v2) {
        E e = null;
        try {
            e = this.addDagEdge(v, v2);
        }
        catch (CycleFoundException cycleFoundException) {
            throw new IllegalArgumentException(cycleFoundException);
        }
        return e;
    }

    public boolean addDagEdge(V v, V v2, E e) throws CycleFoundException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.containsEdge(e)) {
            return false;
        }
        Integer n = this.topoOrderMap.getTopologicalIndex(v2);
        Integer n2 = this.topoOrderMap.getTopologicalIndex(v);
        if (n == null || n2 == null) {
            throw new IllegalArgumentException("vertices must be in the graph already!");
        }
        if (n < n2) {
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            Region region = new Region(n, n2);
            Visited visited = this.visitedFactory.getInstance(region);
            this.dfsF(v2, hashSet, visited, region);
            this.dfsB(v, hashSet2, visited, region);
            this.reorder(hashSet, hashSet2, visited);
            ++this.topologyUpdateCount;
        }
        return super.addEdge(v, v2, e);
    }

    public boolean addEdge(V v, V v2, E e) {
        boolean bl;
        try {
            bl = this.addDagEdge(v, v2, e);
        }
        catch (CycleFoundException cycleFoundException) {
            throw new IllegalArgumentException(cycleFoundException);
        }
        return bl;
    }

    public boolean removeVertex(V v) {
        boolean bl = super.removeVertex(v);
        if (bl) {
            Integer n = this.topoOrderMap.removeVertex(v);
            if (n == this.minTopoIndex) {
                while (this.minTopoIndex < 0 && null == this.topoOrderMap.getVertex(this.minTopoIndex)) {
                    ++this.minTopoIndex;
                }
            }
            if (n == this.maxTopoIndex) {
                while (this.maxTopoIndex > 0 && null == this.topoOrderMap.getVertex(this.maxTopoIndex)) {
                    --this.maxTopoIndex;
                }
            }
            ++this.topologyUpdateCount;
        }
        return bl;
    }

    public boolean removeAllVertices(Collection<? extends V> collection) {
        boolean bl = super.removeAllVertices(collection);
        this.topoOrderMap.removeAllVertices();
        this.maxTopoIndex = 0;
        this.minTopoIndex = 0;
        ++this.topologyUpdateCount;
        return bl;
    }

    private void dfsF(V v, Set<V> set, Visited visited, Region region) throws CycleFoundException {
        int n = this.topoOrderMap.getTopologicalIndex(v);
        visited.setVisited(n);
        set.add(v);
        for (Object e : this.outgoingEdgesOf(v)) {
            Object object = this.getEdgeTarget(e);
            Integer n2 = this.topoOrderMap.getTopologicalIndex(object);
            if (n2 == region.finish) {
                try {
                    for (V v2 : set) {
                        visited.clearVisited(this.topoOrderMap.getTopologicalIndex(v2));
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                throw new CycleFoundException();
            }
            if (!region.isIn(n2) || visited.getVisited(n2)) continue;
            this.dfsF(object, set, visited, region);
        }
    }

    private void dfsB(V v, Set<V> set, Visited visited, Region region) {
        int n = this.topoOrderMap.getTopologicalIndex(v);
        visited.setVisited(n);
        set.add(v);
        for (Object e : this.incomingEdgesOf(v)) {
            Object object = this.getEdgeSource(e);
            Integer n2 = this.topoOrderMap.getTopologicalIndex(object);
            if (!region.isIn(n2) || visited.getVisited(n2)) continue;
            this.dfsB(object, set, visited, region);
        }
    }

    private void reorder(Set<V> set, Set<V> set2, Visited visited) {
        Object object;
        ArrayList<V> arrayList = new ArrayList<V>(set);
        ArrayList<V> arrayList2 = new ArrayList<V>(set2);
        Collections.sort(arrayList, this.topoComparator);
        Collections.sort(arrayList2, this.topoComparator);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Object[] objectArray = new Object[set.size() + set2.size()];
        int n = 0;
        boolean bl = true;
        for (Object object2 : arrayList2) {
            object = this.topoOrderMap.getTopologicalIndex(object2);
            treeSet.add((Integer)object);
            objectArray[n++] = object2;
            if (!bl) continue;
            try {
                visited.clearVisited((Integer)object);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                bl = false;
            }
        }
        for (Object e : arrayList) {
            object = this.topoOrderMap.getTopologicalIndex(e);
            treeSet.add((Integer)object);
            objectArray[n++] = e;
            if (!bl) continue;
            try {
                visited.clearVisited((Integer)object);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                bl = false;
            }
        }
        n = 0;
        for (Integer n2 : treeSet) {
            object = objectArray[n++];
            this.topoOrderMap.putVertex(n2, object);
        }
    }

    private class TopoIterator
    implements Iterator<V> {
        private int currentTopoIndex;
        private final long updateCountAtCreation;
        private Integer nextIndex = null;

        public TopoIterator() {
            this.updateCountAtCreation = DirectedAcyclicGraph.this.topologyUpdateCount;
            this.currentTopoIndex = DirectedAcyclicGraph.this.minTopoIndex - 1;
        }

        @Override
        public boolean hasNext() {
            if (this.updateCountAtCreation != DirectedAcyclicGraph.this.topologyUpdateCount) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = this.getNextIndex();
            return this.nextIndex != null;
        }

        @Override
        public V next() {
            if (this.updateCountAtCreation != DirectedAcyclicGraph.this.topologyUpdateCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextIndex == null) {
                this.nextIndex = this.getNextIndex();
            }
            if (this.nextIndex == null) {
                throw new NoSuchElementException();
            }
            this.currentTopoIndex = this.nextIndex;
            this.nextIndex = null;
            return DirectedAcyclicGraph.this.topoOrderMap.getVertex(this.currentTopoIndex);
        }

        @Override
        public void remove() {
            if (this.updateCountAtCreation != DirectedAcyclicGraph.this.topologyUpdateCount) {
                throw new ConcurrentModificationException();
            }
            Object v = null;
            Object v2 = DirectedAcyclicGraph.this.topoOrderMap.getVertex(this.currentTopoIndex);
            v = v2;
            if (null == v2) {
                throw new IllegalStateException();
            }
            DirectedAcyclicGraph.this.topoOrderMap.removeVertex(v);
        }

        private Integer getNextIndex() {
            for (int i = this.currentTopoIndex + 1; i <= DirectedAcyclicGraph.this.maxTopoIndex; ++i) {
                if (null == DirectedAcyclicGraph.this.topoOrderMap.getVertex(i)) continue;
                return i;
            }
            return null;
        }
    }

    public static class CycleFoundException
    extends Exception {
        private static final long serialVersionUID = 5583471522212552754L;
    }

    public static class VisitedArrayImpl
    implements Visited,
    VisitedFactory {
        private static final long serialVersionUID = 1L;
        private final boolean[] visited;
        private final Region region;

        public VisitedArrayImpl() {
            this(null);
        }

        public VisitedArrayImpl(Region region) {
            if (region == null) {
                this.visited = null;
                this.region = null;
            } else {
                this.region = region;
                this.visited = new boolean[region.getSize()];
            }
        }

        @Override
        public Visited getInstance(Region region) {
            return new VisitedArrayImpl(region);
        }

        @Override
        public void setVisited(int n) {
            this.visited[n - this.region.start] = true;
        }

        @Override
        public boolean getVisited(int n) {
            return this.visited[n - this.region.start];
        }

        @Override
        public void clearVisited(int n) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public static class VisitedHashSetImpl
    implements Visited,
    VisitedFactory {
        private static final long serialVersionUID = 1L;
        private final Set<Integer> visited = new HashSet<Integer>();

        @Override
        public Visited getInstance(Region region) {
            this.visited.clear();
            return this;
        }

        @Override
        public void setVisited(int n) {
            this.visited.add(n);
        }

        @Override
        public boolean getVisited(int n) {
            return this.visited.contains(n);
        }

        @Override
        public void clearVisited(int n) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public static class VisitedArrayListImpl
    implements Visited,
    VisitedFactory {
        private static final long serialVersionUID = 1L;
        private final List<Boolean> visited = new ArrayList<Boolean>();
        private Region affectedRegion;

        @Override
        public Visited getInstance(Region region) {
            int n = region.finish - region.start + 1;
            while (this.visited.size() < n) {
                this.visited.add(Boolean.FALSE);
            }
            this.affectedRegion = region;
            return this;
        }

        @Override
        public void setVisited(int n) {
            this.visited.set(this.translateIndex(n), Boolean.TRUE);
        }

        @Override
        public boolean getVisited(int n) {
            Boolean bl = null;
            bl = this.visited.get(this.translateIndex(n));
            return bl;
        }

        @Override
        public void clearVisited(int n) throws UnsupportedOperationException {
            this.visited.set(this.translateIndex(n), Boolean.FALSE);
        }

        private int translateIndex(int n) {
            return n - this.affectedRegion.start;
        }
    }

    public static class VisitedBitSetImpl
    implements Visited,
    VisitedFactory {
        private static final long serialVersionUID = 1L;
        private final BitSet visited = new BitSet();
        private Region affectedRegion;

        @Override
        public Visited getInstance(Region region) {
            this.affectedRegion = region;
            return this;
        }

        @Override
        public void setVisited(int n) {
            this.visited.set(this.translateIndex(n), true);
        }

        @Override
        public boolean getVisited(int n) {
            return this.visited.get(this.translateIndex(n));
        }

        @Override
        public void clearVisited(int n) throws UnsupportedOperationException {
            this.visited.clear(this.translateIndex(n));
        }

        private int translateIndex(int n) {
            return n - this.affectedRegion.start;
        }
    }

    public static class Region
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int start;
        public final int finish;

        public Region(int n, int n2) {
            if (n > n2) {
                throw new IllegalArgumentException("(start > finish): invariant broken");
            }
            this.start = n;
            this.finish = n2;
        }

        public int getSize() {
            return this.finish - this.start + 1;
        }

        public boolean isIn(int n) {
            return n >= this.start && n <= this.finish;
        }
    }

    public class TopoVertexMap
    implements TopoOrderMapping<V>,
    TopoOrderMappingFactory<V> {
        private static final long serialVersionUID = 1L;
        private final List<V> topoToVertex = new ArrayList();
        private final Map<V, Integer> vertexToTopo = new HashMap();

        @Override
        public void putVertex(Integer n, V v) {
            int n2 = this.translateIndex(n);
            while (n2 + 1 > this.topoToVertex.size()) {
                this.topoToVertex.add(null);
            }
            this.topoToVertex.set(n2, v);
            this.vertexToTopo.put((Integer)v, n);
        }

        @Override
        public V getVertex(Integer n) {
            return this.topoToVertex.get(this.translateIndex(n));
        }

        @Override
        public Integer getTopologicalIndex(V v) {
            return this.vertexToTopo.get(v);
        }

        @Override
        public Integer removeVertex(V v) {
            Integer n = this.vertexToTopo.remove(v);
            if (n != null) {
                this.topoToVertex.set(this.translateIndex(n), null);
            }
            return n;
        }

        @Override
        public void removeAllVertices() {
            this.vertexToTopo.clear();
            this.topoToVertex.clear();
        }

        @Override
        public TopoOrderMapping<V> getTopoOrderMapping() {
            return this;
        }

        private final int translateIndex(int n) {
            if (n >= 0) {
                return 2 * n;
            }
            return -1 * (n * 2 - 1);
        }
    }

    private class TopoVertexBiMap
    implements TopoOrderMapping<V>,
    TopoOrderMappingFactory<V> {
        private static final long serialVersionUID = 1L;
        private final Map<Integer, V> topoToVertex = new HashMap();
        private final Map<V, Integer> vertexToTopo = new HashMap();

        private TopoVertexBiMap() {
        }

        @Override
        public void putVertex(Integer n, V v) {
            this.topoToVertex.put(n, v);
            this.vertexToTopo.put((Integer)v, n);
        }

        @Override
        public V getVertex(Integer n) {
            return this.topoToVertex.get(n);
        }

        @Override
        public Integer getTopologicalIndex(V v) {
            Integer n = this.vertexToTopo.get(v);
            return n;
        }

        @Override
        public Integer removeVertex(V v) {
            Integer n = this.vertexToTopo.remove(v);
            if (n != null) {
                this.topoToVertex.remove(n);
            }
            return n;
        }

        @Override
        public void removeAllVertices() {
            this.vertexToTopo.clear();
            this.topoToVertex.clear();
        }

        @Override
        public TopoOrderMapping<V> getTopoOrderMapping() {
            return this;
        }
    }

    private static class TopoComparator<V>
    implements Comparator<V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final TopoOrderMapping<V> topoOrderMap;

        public TopoComparator(TopoOrderMapping<V> topoOrderMapping) {
            this.topoOrderMap = topoOrderMapping;
        }

        @Override
        public int compare(V v, V v2) {
            return this.topoOrderMap.getTopologicalIndex(v).compareTo(this.topoOrderMap.getTopologicalIndex(v2));
        }
    }

    public static interface VisitedFactory
    extends Serializable {
        public Visited getInstance(Region var1);
    }

    public static interface Visited {
        public void setVisited(int var1);

        public boolean getVisited(int var1);

        public void clearVisited(int var1) throws UnsupportedOperationException;
    }

    public static interface TopoOrderMappingFactory<V> {
        public TopoOrderMapping<V> getTopoOrderMapping();
    }

    public static interface TopoOrderMapping<V>
    extends Serializable {
        public void putVertex(Integer var1, V var2);

        public V getVertex(Integer var1);

        public Integer getTopologicalIndex(V var1);

        public Integer removeVertex(V var1);

        public void removeAllVertices();
    }
}

