/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.mss.transcript;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Convert {
    static char[] symbolGreekTranslation = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', ' ', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\u03c2', '#', '$', '%', '&', '\u0342', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00b7', ';', '<', '=', '\u0308', '?', '@', '\u0391', '\u0392', '\u03a7', '\u0394', '\u0395', '\u03a6', '\u0393', '\u0397', '\u0399', '\u0314', '\u039a', '\u039b', '\u039c', '\u039d', '\u039f', '\u03a0', '\u0398', '\u03a1', '\u03a3', '\u03a4', '\u03a5', '\u0384', '\u03a9', '\u039e', '\u03a8', 'Z', '[', '\\', ']', '^', '_', '`', '\u03b1', '\u03b2', '\u03c7', '\u03b4', '\u03b5', '\u03c6', '\u03b3', '\u03b7', '\u03b9', '\u0313', '\u03ba', '\u03bb', '\u03bc', '\u03bd', 'o', '\u03c0', '\u03b8', '\u03c1', '\u03c3', '\u03c4', '\u03c5', '\u0301', '\u03c9', '\u03be', '\u03c8', '\u03b6', '{', '|', '}', '\u03c2', '\u007f', ' ', '\u0081', 'C', '\u0083', '\u0084', '>', '\u1fbd', '\u0087', '\u0088', ';', ' ', '\u008b', 'a', 'c', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', 'V', '\u0098', '\u0099', '/', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', 't', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', 's', 'r', 'g', '\u00aa', 'e', 'u', 'G', '\u00ae', '}', '\u00b0', '\u0306', 'j', '\u0323', 'y', 'm', 'd', 'w', '\u00b8', 'p', 'b', '[', ']', '\u00bd', '\u00be', '{', '\u00c0', '\u00ba', 'l', 'v', 'f', 'x', '\u02bc', '\u00c7', '\u00c8', ';', ' ', '\u00cb', '\u00cc', '\u00cd', 'Q', 'q', '\u0304', '\u0305', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', 'V', '\u00d8', '\u00d9', '|', '\\', '\u00dc', '\u00dd', '\u00de', '\u0302', '\u00e0', '\u00e1', ' ', 'W', '\u00e4', 'R', '\u00e6', 'Y', 'U', 'i', 'S', 'D', 'F', 'G', '\u00ee', ' ', '\u00f0', 'L', ':', '\u00f3', '\u00f4', '\u00f5', 'n', '\u00f7', 'J', '\u00f9', 'h', 'k', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};

    public static String translate(char c) {
        return new String(new char[]{c <= '\u00ff' ? symbolGreekTranslation[c] : c});
    }

    public static StringBuffer translate(StringBuffer s) {
        StringBuffer out = new StringBuffer();
        try {
            byte[] b = s.toString().getBytes("iso8859-1");
            int lastC = 0;
            for (int i = 0; i < b.length; ++i) {
                int newC;
                int c = b[i] < 0 ? b[i] + 256 : b[i];
                int n = newC = c <= 255 ? symbolGreekTranslation[c] : c;
                if (newC == 59) {
                    switch (lastC) {
                        case 913: 
                        case 917: 
                        case 919: 
                        case 921: 
                        case 927: 
                        case 933: 
                        case 937: 
                        case 945: 
                        case 949: 
                        case 951: 
                        case 953: 
                        case 959: 
                        case 965: 
                        case 969: {
                            newC = 768;
                            break;
                        }
                    }
                }
                out.append((char)newC);
                lastC = newC;
                if (c != 10 && c != 13) continue;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return out;
    }

    public static String translate(String s) {
        return Convert.translate(new StringBuffer(s)).toString();
    }

    public static StringBuffer processWitness(Reader reader, int book, int chap) throws IOException, SAXException, ParserConfigurationException {
        StringBuffer retVal = new StringBuffer();
        String pertinentContext = "B" + Integer.toString(book) + "K" + Integer.toString(chap) + "V";
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        SAXParser sp = spf.newSAXParser();
        InputSource input = new InputSource(reader);
        SAXDemo handler = new SAXDemo(retVal, pertinentContext);
        sp.parse(input, (DefaultHandler)handler);
        return retVal;
    }

    private static StringBuffer loadInputStream(InputStream is) throws Exception {
        StringBuffer data = new StringBuffer();
        byte[] buffer = new byte[2048];
        int len = 0;
        while ((len = is.read(buffer)) > -1) {
            data.append(new String(buffer, 0, len, "iso8859-1"));
        }
        is.close();
        return data;
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println("usage: sb2u <filename>");
            return;
        }
        FileInputStream inFile = new FileInputStream(argv[0]);
        StringBuffer inBuffer = Convert.loadInputStream(inFile);
        inBuffer = Convert.translate(inBuffer);
        PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        out.println(inBuffer);
    }

    public static class SAXDemo
    extends DefaultHandler {
        StringBuffer result = new StringBuffer();
        String pertinentContext = "";
        boolean process = false;
        StringBuffer accumulator = new StringBuffer();

        public SAXDemo(StringBuffer result, String pertinentContext) {
            this.result = result;
            this.pertinentContext = pertinentContext;
        }

        @Override
        public void characters(char[] buffer, int start, int length) {
            this.accumulator.append(buffer, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.accumulator.setLength(0);
            if (qName.equals("ab")) {
                String context = attributes.getValue("xml:id");
                boolean bl = this.process = context != null && context.startsWith(this.pertinentContext);
                if (this.process) {
                    this.result.append('\n');
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.process && qName.equals("w")) {
                this.result.append(this.accumulator);
                this.result.append(' ');
            }
        }

        @Override
        public void warning(SAXParseException exception) {
            System.err.println("WARNING: line " + exception.getLineNumber() + ": " + exception.getMessage());
        }

        @Override
        public void error(SAXParseException exception) {
            System.err.println("ERROR: line " + exception.getLineNumber() + ": " + exception.getMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.err.println("FATAL: line " + exception.getLineNumber() + ": " + exception.getMessage());
            throw exception;
        }
    }
}

