/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.interedition.collatex2.implementation.containers.graph.VariantGraph2Creator;
import eu.interedition.collatex2.implementation.containers.witness.AlternativeWitnessIndex;
import eu.interedition.collatex2.implementation.containers.witness.NormalizedWitness;
import eu.interedition.collatex2.implementation.input.tokenization.DefaultTokenNormalizer;
import eu.interedition.collatex2.implementation.input.tokenization.WhitespaceTokenizer;
import eu.interedition.collatex2.implementation.output.apparatus.ParallelSegmentationApparatus;
import eu.interedition.collatex2.implementation.output.table.RankedGraphBasedAlignmentTable;
import eu.interedition.collatex2.implementation.vg_alignment.IAlignment2;
import eu.interedition.collatex2.implementation.vg_alignment.VariantGraphAligner;
import eu.interedition.collatex2.implementation.vg_analysis.Analysis;
import eu.interedition.collatex2.implementation.vg_analysis.IAnalysis;
import eu.interedition.collatex2.implementation.vg_analysis.ISequence;
import eu.interedition.collatex2.implementation.vg_analysis.SequenceDetection2;
import eu.interedition.collatex2.interfaces.IAligner;
import eu.interedition.collatex2.interfaces.IAlignmentTable;
import eu.interedition.collatex2.interfaces.IMatch;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IPhrase;
import eu.interedition.collatex2.interfaces.IToken;
import eu.interedition.collatex2.interfaces.ITokenContainer;
import eu.interedition.collatex2.interfaces.ITokenIndex;
import eu.interedition.collatex2.interfaces.ITokenMatch;
import eu.interedition.collatex2.interfaces.ITokenNormalizer;
import eu.interedition.collatex2.interfaces.ITokenizer;
import eu.interedition.collatex2.interfaces.IVariantGraph;
import eu.interedition.collatex2.interfaces.IWitness;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CollateXEngine {
    private ITokenizer tokenizer = new WhitespaceTokenizer();
    private ITokenNormalizer tokenNormalizer = new DefaultTokenNormalizer();

    public void setTokenizer(ITokenizer iTokenizer) {
        this.tokenizer = iTokenizer;
    }

    public void setTokenNormalizer(ITokenNormalizer iTokenNormalizer) {
        this.tokenNormalizer = iTokenNormalizer;
    }

    public IAlignmentTable align(IWitness ... iWitnessArray) {
        IVariantGraph iVariantGraph = VariantGraph2Creator.create(iWitnessArray);
        RankedGraphBasedAlignmentTable rankedGraphBasedAlignmentTable = new RankedGraphBasedAlignmentTable(iVariantGraph);
        return rankedGraphBasedAlignmentTable;
    }

    public IWitness createWitness(String string, String string2) {
        Iterable<IToken> iterable = this.tokenizer.tokenize(string, string2);
        return new NormalizedWitness(string, Lists.newArrayList(Iterables.transform(iterable, this.tokenNormalizer)));
    }

    public ParallelSegmentationApparatus createApparatus(IAlignmentTable iAlignmentTable) {
        return ParallelSegmentationApparatus.build(iAlignmentTable);
    }

    public static IMatch createMatch(INormalizedToken iNormalizedToken, INormalizedToken iNormalizedToken2, float f) {
        throw new RuntimeException("Near matches are not yet supported!");
    }

    public static IMatch createMatch(IPhrase iPhrase, IPhrase iPhrase2, float f) {
        throw new RuntimeException("Near matches are not yet supported!");
    }

    public static ITokenIndex createWitnessIndex(IWitness iWitness) {
        return new AlternativeWitnessIndex(iWitness, iWitness.getRepeatedTokens());
    }

    protected static Set<String> getTokensWithMultiples(Collection<IWitness> collection) {
        HashSet<String> hashSet = Sets.newHashSet();
        for (IWitness iWitness : collection) {
            HashMultiset<String> hashMultiset = HashMultiset.create();
            List<INormalizedToken> list = iWitness.getTokens();
            for (INormalizedToken iNormalizedToken : list) {
                hashMultiset.add(iNormalizedToken.getNormalized());
            }
            Set set = hashMultiset.elementSet();
            Iterator object2 = set.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                if (hashMultiset.count(string) <= 1) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    protected static Set<String> getPhrasesWithMultiples(IWitness ... iWitnessArray) {
        HashSet<String> hashSet = Sets.newHashSet();
        for (IWitness iWitness : iWitnessArray) {
            HashMultiset<String> hashMultiset = HashMultiset.create();
            List<INormalizedToken> list = iWitness.getTokens();
            for (INormalizedToken iNormalizedToken : list) {
                hashMultiset.add(iNormalizedToken.getNormalized());
            }
            boolean bl = false;
            for (String string : hashMultiset.elementSet()) {
                if (hashMultiset.count(string) <= 1) continue;
                bl = true;
                hashSet.add(string);
            }
            if (bl) {
                void var9_15;
                boolean bl2 = false;
                while (var9_15 < list.size() - 1) {
                    String string;
                    string = list.get((int)var9_15).getNormalized();
                    String string2 = list.get((int)(var9_15 + true)).getNormalized();
                    if (hashSet.contains(string) && hashSet.contains(string2)) {
                        hashMultiset.add(string + " " + string2);
                    }
                    ++var9_15;
                }
            }
            for (String string : hashMultiset.elementSet()) {
                if (hashMultiset.count(string) <= 1) continue;
                bl = true;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    public IVariantGraph graph(IWitness ... iWitnessArray) {
        return VariantGraph2Creator.create(iWitnessArray);
    }

    public IAnalysis analyse(IVariantGraph iVariantGraph, IWitness iWitness) {
        IAlignment2 iAlignment2 = this.align(iVariantGraph, iWitness);
        List<ITokenMatch> list = iAlignment2.getTokenMatches();
        SequenceDetection2 sequenceDetection2 = new SequenceDetection2(list, (ITokenContainer)iVariantGraph, (ITokenContainer)iWitness);
        List<ISequence> list2 = sequenceDetection2.chainTokenMatches();
        return new Analysis(list2, iVariantGraph);
    }

    public IAlignment2 align(IVariantGraph iVariantGraph, IWitness iWitness) {
        VariantGraphAligner variantGraphAligner = new VariantGraphAligner(iVariantGraph);
        IAlignment2 iAlignment2 = variantGraphAligner.align(iWitness);
        return iAlignment2;
    }

    public IAligner createAligner() {
        return null;
    }
}

