/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.containers.graph;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.interedition.collatex2.implementation.containers.graph.VariantGraph2;
import eu.interedition.collatex2.implementation.vg_alignment.IAlignment2;
import eu.interedition.collatex2.implementation.vg_alignment.VariantGraphAligner;
import eu.interedition.collatex2.implementation.vg_analysis.Analysis;
import eu.interedition.collatex2.implementation.vg_analysis.ISequence;
import eu.interedition.collatex2.implementation.vg_analysis.ITransposition2;
import eu.interedition.collatex2.implementation.vg_analysis.SequenceDetection2;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.ITokenContainer;
import eu.interedition.collatex2.interfaces.ITokenMatch;
import eu.interedition.collatex2.interfaces.IVariantGraph;
import eu.interedition.collatex2.interfaces.IVariantGraphEdge;
import eu.interedition.collatex2.interfaces.IVariantGraphVertex;
import eu.interedition.collatex2.interfaces.IWitness;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class VariantGraph2Creator {
    private final VariantGraph2 graph;

    public VariantGraph2Creator(VariantGraph2 variantGraph2) {
        this.graph = variantGraph2;
    }

    public void addWitness(IWitness iWitness) {
        VariantGraphAligner variantGraphAligner = new VariantGraphAligner(this.graph);
        IAlignment2 iAlignment2 = variantGraphAligner.align(iWitness);
        List<ITokenMatch> list = iAlignment2.getTokenMatches();
        SequenceDetection2 sequenceDetection2 = new SequenceDetection2(list, (ITokenContainer)this.graph, (ITokenContainer)iWitness);
        List<ISequence> list2 = sequenceDetection2.chainTokenMatches();
        Analysis analysis = new Analysis(list2, this.graph);
        List<ITransposition2> list3 = analysis.getTranspositions();
        this.makeEdgesForMatches(iWitness, list, list3);
    }

    private void makeEdgesForMatches(IWitness iWitness, List<ITokenMatch> list, List<ITransposition2> list2) {
        Object object;
        LinkedHashMap<INormalizedToken, ITokenMatch> linkedHashMap = Maps.newLinkedHashMap();
        LinkedHashMap<INormalizedToken, ITokenMatch> linkedHashMap2 = Maps.newLinkedHashMap();
        for (ITokenMatch object2 : list) {
            object = object2.getTokenA();
            linkedHashMap.put((INormalizedToken)object, object2);
        }
        Stack stack = new Stack();
        stack.addAll(list2);
        Collections.reverse(stack);
        while (!stack.isEmpty()) {
            ISequence iSequence;
            ITransposition2 iTransposition2 = (ITransposition2)stack.pop();
            object = VariantGraph2Creator.findMirroredTransposition(stack, iTransposition2);
            if (object != null && this.transpositionsAreNear(iTransposition2, (ITransposition2)object)) {
                stack.remove(object);
                iSequence = object.getSequenceA();
                this.removeSequenceFromMatches(linkedHashMap, linkedHashMap2, iSequence);
                continue;
            }
            iSequence = iTransposition2.getSequenceA();
            this.removeSequenceFromMatches(linkedHashMap, linkedHashMap2, iSequence);
        }
        this.addWitnessToGraph(iWitness, linkedHashMap, linkedHashMap2);
    }

    private boolean transpositionsAreNear(ITransposition2 iTransposition2, ITransposition2 iTransposition22) {
        INormalizedToken iNormalizedToken = iTransposition2.getSequenceA().getWitnessPhrase().getLastToken();
        INormalizedToken iNormalizedToken2 = iTransposition22.getSequenceA().getWitnessPhrase().getFirstToken();
        boolean bl = this.graph.isNear(iNormalizedToken, iNormalizedToken2);
        return bl;
    }

    private void removeSequenceFromMatches(Map<INormalizedToken, ITokenMatch> map, Map<INormalizedToken, ITokenMatch> map2, ISequence iSequence) {
        for (INormalizedToken iNormalizedToken : iSequence.getBasePhrase().getTokens()) {
            if (!map.containsKey(iNormalizedToken)) {
                throw new RuntimeException("Could not remove match from map!");
            }
            ITokenMatch iTokenMatch = map.remove(iNormalizedToken);
            map2.put(iNormalizedToken, iTokenMatch);
        }
    }

    private static ITransposition2 findMirroredTransposition(Stack<ITransposition2> stack, ITransposition2 iTransposition2) {
        for (ITransposition2 iTransposition22 : stack) {
            if (!iTransposition22.getSequenceA().getNormalized().equals(iTransposition2.getSequenceB().getNormalized()) || !iTransposition22.getSequenceB().getNormalized().equals(iTransposition2.getSequenceA().getNormalized())) continue;
            return iTransposition22;
        }
        return null;
    }

    private void addWitnessToGraph(IWitness iWitness, Map<INormalizedToken, ITokenMatch> map, Map<INormalizedToken, ITokenMatch> map2) {
        IVariantGraphVertex iVariantGraphVertex = this.graph.getStartVertex();
        for (INormalizedToken iNormalizedToken : iWitness.getTokens()) {
            IVariantGraphVertex iVariantGraphVertex2;
            Object object;
            if (!map.containsKey(iNormalizedToken)) {
                object = map2.containsKey(iNormalizedToken) ? ((IVariantGraphVertex)map2.get(iNormalizedToken).getTokenB()).getVertexKey() : iNormalizedToken;
                iVariantGraphVertex2 = this.graph.addNewVertex(iNormalizedToken.getNormalized(), (INormalizedToken)object);
            } else {
                object = map.get(iNormalizedToken);
                iVariantGraphVertex2 = (IVariantGraphVertex)object.getBaseToken();
            }
            this.connectBeginToEndVertex(iVariantGraphVertex, iVariantGraphVertex2, iWitness);
            iVariantGraphVertex2.addToken(iWitness, iNormalizedToken);
            iVariantGraphVertex = iVariantGraphVertex2;
        }
        IVariantGraphVertex iVariantGraphVertex3 = this.graph.getEndVertex();
        this.connectBeginToEndVertex(iVariantGraphVertex, iVariantGraphVertex3, iWitness);
    }

    private void connectBeginToEndVertex(IVariantGraphVertex iVariantGraphVertex, IVariantGraphVertex iVariantGraphVertex2, IWitness iWitness) {
        if (this.graph.containsEdge(iVariantGraphVertex, iVariantGraphVertex2)) {
            IVariantGraphEdge iVariantGraphEdge = (IVariantGraphEdge)this.graph.getEdge(iVariantGraphVertex, iVariantGraphVertex2);
            iVariantGraphEdge.addWitness(iWitness);
        } else {
            this.graph.addNewEdge(iVariantGraphVertex, iVariantGraphVertex2, iWitness);
        }
    }

    public static IVariantGraph create(IWitness ... iWitnessArray) {
        ArrayList<IWitness> arrayList = Lists.newArrayList(iWitnessArray);
        if (arrayList.isEmpty()) {
            return VariantGraph2.create();
        }
        IWitness iWitness = (IWitness)arrayList.remove(0);
        IWitness[] iWitnessArray2 = arrayList.toArray(new IWitness[arrayList.size()]);
        VariantGraph2 variantGraph2 = VariantGraph2.create(iWitness);
        VariantGraph2Creator variantGraph2Creator = new VariantGraph2Creator(variantGraph2);
        for (IWitness iWitness2 : iWitnessArray2) {
            variantGraph2Creator.addWitness(iWitness2);
        }
        return variantGraph2;
    }
}

