/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.containers.graph;

import com.google.common.collect.Maps;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IVariantGraphVertex;
import eu.interedition.collatex2.interfaces.IWitness;
import java.util.Map;
import java.util.Set;

public class VariantGraphVertex
implements IVariantGraphVertex {
    private final String normalized;
    private final Map<IWitness, INormalizedToken> tokenMap;
    private final INormalizedToken vertexKey;

    public VariantGraphVertex(String string, INormalizedToken iNormalizedToken) {
        this.normalized = string;
        this.vertexKey = iNormalizedToken;
        this.tokenMap = Maps.newLinkedHashMap();
    }

    @Override
    public String getNormalized() {
        return this.normalized;
    }

    @Override
    public INormalizedToken getToken(IWitness iWitness) {
        if (!this.tokenMap.containsKey(iWitness)) {
            throw new RuntimeException("TOKEN FOR WITNESS " + iWitness.getSigil() + " NOT FOUND IN VERTEX " + this.getNormalized() + "!");
        }
        return this.tokenMap.get(iWitness);
    }

    @Override
    public void addToken(IWitness iWitness, INormalizedToken iNormalizedToken) {
        this.tokenMap.put(iWitness, iNormalizedToken);
    }

    @Override
    public boolean containsWitness(String string) {
        return this.internalGetWitnessForSigil(string) != null;
    }

    @Override
    public IWitness getWitnessForSigil(String string) {
        IWitness iWitness = this.internalGetWitnessForSigil(string);
        if (iWitness == null) {
            throw new RuntimeException("Witness with " + string + " not found in this vertex!");
        }
        return iWitness;
    }

    private IWitness internalGetWitnessForSigil(String string) {
        Set<IWitness> set = this.tokenMap.keySet();
        for (IWitness iWitness : set) {
            if (!iWitness.getSigil().equals(string)) continue;
            return iWitness;
        }
        return null;
    }

    @Override
    public Set<IWitness> getWitnesses() {
        return this.tokenMap.keySet();
    }

    public String toString() {
        return "[" + this.getNormalized() + "]";
    }

    @Override
    public int getPosition() {
        throw new RuntimeException("WRONG! THIS METHOD WILL BE REMOVED!");
    }

    @Override
    public String getSigil() {
        throw new RuntimeException("WRONG!");
    }

    @Override
    public String getContent() {
        throw new RuntimeException("Do not call this method! Call getToken(IWitness).getContent() instead.");
    }

    @Override
    public INormalizedToken getVertexKey() {
        return this.vertexKey;
    }
}

