/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.containers.witness;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import eu.interedition.collatex2.implementation.input.Phrase;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IPhrase;
import eu.interedition.collatex2.interfaces.ITokenIndex;
import eu.interedition.collatex2.interfaces.IWitness;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WitnessIndex0
implements ITokenIndex {
    private Logger log = LoggerFactory.getLogger(WitnessIndex0.class);
    Multiset<IPhrase> phraseBag = TreeMultiset.create();
    public static final Function<IPhrase, String> PHRASE_TO_NORMALIZED = new Function<IPhrase, String>(){

        @Override
        public String apply(IPhrase iPhrase) {
            return iPhrase.getNormalized();
        }
    };

    public WitnessIndex0(Multiset<IPhrase> multiset) {
        this.phraseBag = multiset;
    }

    public WitnessIndex0(IWitness iWitness, Collection<String> collection) {
        List<INormalizedToken> list = iWitness.getTokens();
        Multimap<String, IPhrase> multimap = this.seed(list);
        Map<String, IPhrase> map = this.grow(multimap, list, collection);
        this.phraseBag.addAll(this.harvest(map));
    }

    @Override
    public boolean contains(String string) {
        ArrayList<String> arrayList = Lists.newArrayList(Iterables.transform(this.phraseBag.elementSet(), PHRASE_TO_NORMALIZED));
        this.log.debug(((Object)arrayList).toString());
        return arrayList.contains(string);
    }

    @Override
    public int size() {
        return this.phraseBag.size();
    }

    private Multimap<String, IPhrase> seed(List<INormalizedToken> list) {
        HashMultimap<String, IPhrase> hashMultimap = HashMultimap.create();
        for (INormalizedToken iNormalizedToken : list) {
            hashMultimap.put(iNormalizedToken.getNormalized(), new Phrase(Lists.newArrayList(iNormalizedToken)));
        }
        return hashMultimap;
    }

    private Map<String, IPhrase> grow(Multimap<String, IPhrase> multimap, List<INormalizedToken> list, Collection<String> collection) {
        Serializable serializable;
        Multimap<String, IPhrase> multimap2 = multimap;
        do {
            serializable = HashMultimap.create();
            for (String object : multimap2.keySet()) {
                Collection<IPhrase> collection2 = multimap2.get(object);
                if (collection2.size() == 1 && !collection.contains(object)) {
                    IPhrase iPhrase = collection2.iterator().next();
                    serializable.put((String)object, (IPhrase)iPhrase);
                    continue;
                }
                this.addExpandedPhrases((Multimap<String, IPhrase>)((Object)serializable), collection2, list, collection);
            }
        } while ((multimap2 = serializable).entries().size() > multimap2.keySet().size());
        serializable = Maps.newHashMap();
        for (Map.Entry entry : multimap2.entries()) {
            serializable.put(entry.getKey(), entry.getValue());
        }
        return serializable;
    }

    private void addExpandedPhrases(Multimap<String, IPhrase> multimap, Collection<IPhrase> collection, List<INormalizedToken> list, Collection<String> collection2) {
    }

    private List<IPhrase> harvest(Map<String, IPhrase> map) {
        ArrayList<IPhrase> arrayList = Lists.newArrayList(map.values());
        Collections.sort(arrayList, Phrase.PHRASECOMPARATOR);
        return arrayList;
    }

    @Override
    public IPhrase getPhrase(String string) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    @Override
    public Set<String> keys() {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }
}

