/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.input.builders;

import com.google.common.collect.Lists;
import eu.interedition.collatex2.Util;
import eu.interedition.collatex2.implementation.containers.witness.NormalizedWitness;
import eu.interedition.collatex2.implementation.input.NormalizedToken;
import eu.interedition.collatex2.implementation.input.builders.WitnessStreamBuilder;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.ITokenNormalizer;
import eu.interedition.collatex2.interfaces.IWitness;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WitnessTeiBuilder
extends WitnessStreamBuilder {
    DocumentBuilder builder = null;
    XPathFactory factory;
    private final ITokenNormalizer tokenNormalizer;

    public WitnessTeiBuilder(ITokenNormalizer iTokenNormalizer) {
        super(iTokenNormalizer);
        this.tokenNormalizer = iTokenNormalizer;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InternalError("Internal error. Can't create document builder!");
        }
        this.factory = XPathFactory.newInstance();
    }

    @Override
    public IWitness build(InputStream inputStream) throws SAXException, IOException {
        String string = Util.generateRandomId();
        Document document = this.getXmlDocument(inputStream);
        XPath xPath = this.factory.newXPath();
        Object object = this.evaluate(xPath, document, "/TEI/text/body//w");
        NodeList nodeList = (NodeList)object;
        List<INormalizedToken> list = Lists.newArrayList();
        if (nodeList == null || nodeList.getLength() == 0) {
            object = this.evaluate(xPath, document, "/TEI/text/body//p");
            nodeList = (NodeList)object;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2 = nodeList.item(i).getTextContent();
                stringBuilder.append(string2);
            }
            IWitness iWitness = this.build(stringBuilder.toString());
            list = iWitness.getTokens();
        } else {
            int n = 1;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string3 = nodeList.item(i).getTextContent();
                NormalizedToken normalizedToken = new NormalizedToken(string, string3, n++, string3);
                normalizedToken.setNormalized(((INormalizedToken)this.tokenNormalizer.apply(normalizedToken)).getNormalized());
                list.add(normalizedToken);
            }
        }
        return new NormalizedWitness(string, list);
    }

    private Object evaluate(XPath xPath, Document document, String string) {
        Object object;
        XPathExpression xPathExpression;
        try {
            xPathExpression = xPath.compile(string);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new InternalError("Incorrect xpath expression!");
        }
        try {
            object = xPathExpression.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new InternalError("Incorrect xpath expression!");
        }
        return object;
    }

    private Document getXmlDocument(InputStream inputStream) throws SAXException, IOException {
        Document document = null;
        document = this.builder.parse(inputStream);
        return document;
    }
}

