/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.input.tokenization;

import eu.interedition.collatex2.implementation.input.NormalizedToken;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IToken;
import eu.interedition.collatex2.interfaces.ITokenNormalizer;
import java.util.regex.Pattern;

public class DefaultTokenNormalizer
implements ITokenNormalizer {
    private static final Pattern PUNCT = Pattern.compile("\\p{Punct}");

    @Override
    public INormalizedToken apply(IToken iToken) {
        String string = PUNCT.matcher(iToken.getContent().toLowerCase()).replaceAll("");
        if (string == null || string.length() == 0) {
            string = iToken.getContent();
        }
        return new NormalizedToken(iToken.getSigil(), iToken.getContent(), iToken.getPosition(), string);
    }
}

