/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.output.apparatus;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import eu.interedition.collatex2.implementation.input.Phrase;
import eu.interedition.collatex2.interfaces.ApparatusEntryState;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IPhrase;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ApparatusEntry {
    private final List<String> sigla;
    private final Multimap<String, INormalizedToken> sigilToTokens;

    public ApparatusEntry(List<String> list) {
        this.sigla = list;
        this.sigilToTokens = LinkedHashMultimap.create();
    }

    public void addToken(String string, INormalizedToken iNormalizedToken) {
        this.sigilToTokens.put(string, iNormalizedToken);
    }

    public boolean containsWitness(String string) {
        return this.sigilToTokens.containsKey(string);
    }

    public IPhrase getPhrase(String string) {
        return new Phrase(Lists.newArrayList(this.sigilToTokens.get(string)));
    }

    public List<String> getSigla() {
        return this.sigla;
    }

    public Set<String> getEmptyCells() {
        LinkedHashSet<String> linkedHashSet = Sets.newLinkedHashSet(this.sigla);
        linkedHashSet.removeAll(this.sigilToTokens.keySet());
        return linkedHashSet;
    }

    public boolean hasEmptyCells() {
        return this.sigla.size() != this.sigilToTokens.keySet().size();
    }

    public ApparatusEntryState getState() {
        HashSet<String> hashSet = Sets.newHashSet();
        for (String string : this.sigla) {
            hashSet.add(this.getPhrase(string).getNormalized());
        }
        int n = hashSet.size();
        if (n == 1) {
            return ApparatusEntryState.INVARIANT;
        }
        if (n == 2 && this.hasEmptyCells()) {
            return ApparatusEntryState.SEMI_INVARIANT;
        }
        return ApparatusEntryState.VARIANT;
    }
}

