/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.output.apparatus;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.interedition.collatex2.implementation.output.apparatus.ApparatusEntry;
import eu.interedition.collatex2.implementation.output.apparatus.ParallelSegmentationApparatus;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TeiParallelSegmentationApparatusBuilder {
    public static final String TEI_NS = "http://www.tei-c.org/ns/1.0";
    private static final Function<String, String> WIT_TO_XML_ID = new Function<String, String>(){

        @Override
        public String apply(String string) {
            return string.startsWith("#") ? string : "#" + string;
        }
    };

    public static void build(ParallelSegmentationApparatus parallelSegmentationApparatus, Node node) {
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        for (ApparatusEntry apparatusEntry : parallelSegmentationApparatus.getEntries()) {
            ArrayListMultimap<Object, String> arrayListMultimap = ArrayListMultimap.create();
            for (String string : apparatusEntry.getSigla()) {
                arrayListMultimap.put(apparatusEntry.getPhrase(string).getContent(), string);
            }
            if (arrayListMultimap.keySet().size() == 1 && !apparatusEntry.hasEmptyCells()) {
                node.appendChild(document.createTextNode((String)arrayListMultimap.keys().iterator().next()));
            } else {
                Object object2;
                HashMap hashMap = Maps.newHashMap();
                for (Object object2 : arrayListMultimap.keySet()) {
                    hashMap.put(object2, Sets.newTreeSet(arrayListMultimap.get(object2)));
                }
                TreeMap treeMap = Maps.newTreeMap();
                for (Map.Entry entry : hashMap.entrySet()) {
                    treeMap.put(Joiner.on(" ").join(Iterables.transform((Iterable)entry.getValue(), WIT_TO_XML_ID)), entry.getKey());
                }
                object2 = document.createElementNS(TEI_NS, "app");
                node.appendChild((Node)object2);
                for (Map.Entry entry : treeMap.entrySet()) {
                    Element element = document.createElementNS(TEI_NS, "rdg");
                    object2.appendChild(element);
                    element.setAttribute("wit", (String)entry.getKey());
                    String string = (String)entry.getValue();
                    if (string.isEmpty()) continue;
                    element.setTextContent(string);
                }
            }
            node.appendChild(document.createTextNode(" "));
        }
        if (!parallelSegmentationApparatus.getEntries().isEmpty()) {
            node.removeChild(node.getLastChild());
        }
    }
}

