/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.output.cgraph;

import com.google.common.collect.Maps;
import eu.interedition.collatex2.implementation.containers.graph.VariantGraphEdge;
import eu.interedition.collatex2.implementation.containers.graph.VariantGraphVertex;
import eu.interedition.collatex2.implementation.output.cgraph.CyclicVariantGraph;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IVariantGraph;
import eu.interedition.collatex2.interfaces.IVariantGraphEdge;
import eu.interedition.collatex2.interfaces.IVariantGraphVertex;
import eu.interedition.collatex2.interfaces.IWitness;
import java.util.HashMap;
import java.util.Iterator;

public class CVariantGraphCreator {
    public static IVariantGraph getCyclicVariantGraph(IVariantGraph iVariantGraph) {
        IVariantGraphVertex iVariantGraphVertex;
        INormalizedToken iNormalizedToken;
        HashMap<INormalizedToken, IVariantGraphVertex> hashMap = Maps.newHashMap();
        HashMap<Object, IVariantGraphVertex> hashMap2 = Maps.newHashMap();
        CyclicVariantGraph cyclicVariantGraph = CyclicVariantGraph.create();
        hashMap2.put(iVariantGraph.getStartVertex(), cyclicVariantGraph.getStartVertex());
        hashMap2.put(iVariantGraph.getEndVertex(), cyclicVariantGraph.getEndVertex());
        for (Object object : iVariantGraph.vertexSet()) {
            if (hashMap2.containsKey(object)) continue;
            iNormalizedToken = object.getVertexKey();
            if (hashMap.containsKey(iNormalizedToken)) {
                iVariantGraphVertex = (IVariantGraphVertex)hashMap.get(iNormalizedToken);
            } else {
                iVariantGraphVertex = new VariantGraphVertex(object.getNormalized(), iNormalizedToken);
                hashMap.put(iNormalizedToken, iVariantGraphVertex);
                cyclicVariantGraph.addVertex(iVariantGraphVertex);
            }
            hashMap2.put(object, iVariantGraphVertex);
        }
        for (Object object : iVariantGraph.edgeSet()) {
            IVariantGraphEdge iVariantGraphEdge;
            iNormalizedToken = (IVariantGraphVertex)hashMap2.get(object.getBeginVertex());
            iVariantGraphVertex = (IVariantGraphVertex)hashMap2.get(object.getEndVertex());
            Iterator<IWitness> iterator = object.getWitnesses().iterator();
            if (cyclicVariantGraph.containsEdge(iNormalizedToken, iVariantGraphVertex)) {
                iVariantGraphEdge = (IVariantGraphEdge)cyclicVariantGraph.getEdge(iNormalizedToken, iVariantGraphVertex);
            } else {
                iVariantGraphEdge = new VariantGraphEdge((IVariantGraphVertex)iNormalizedToken, iVariantGraphVertex, iterator.next());
                cyclicVariantGraph.addEdge(iNormalizedToken, iVariantGraphVertex, iVariantGraphEdge);
            }
            while (iterator.hasNext()) {
                iVariantGraphEdge.addWitness(iterator.next());
            }
        }
        return cyclicVariantGraph;
    }
}

