/*
 * Decompiled with CFR 0.152.
 */
package eu.interedition.collatex2.implementation.output.cgraph;

import com.google.common.collect.Lists;
import eu.interedition.collatex2.implementation.containers.graph.VariantGraphEdge;
import eu.interedition.collatex2.implementation.containers.graph.VariantGraphVertex;
import eu.interedition.collatex2.interfaces.INormalizedToken;
import eu.interedition.collatex2.interfaces.IToken;
import eu.interedition.collatex2.interfaces.ITokenIndex;
import eu.interedition.collatex2.interfaces.IVariantGraph;
import eu.interedition.collatex2.interfaces.IVariantGraphEdge;
import eu.interedition.collatex2.interfaces.IVariantGraphVertex;
import eu.interedition.collatex2.interfaces.IWitness;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jgrapht.graph.SimpleDirectedGraph;

public class CyclicVariantGraph
extends SimpleDirectedGraph<IVariantGraphVertex, IVariantGraphEdge>
implements IVariantGraph {
    private final IVariantGraphVertex startVertex = new VariantGraphVertex("#", null);
    private final IVariantGraphVertex endVertex;

    private CyclicVariantGraph() {
        super(IVariantGraphEdge.class);
        this.addVertex(this.startVertex);
        this.endVertex = new VariantGraphVertex("#", null);
        this.addVertex(this.endVertex);
    }

    public static CyclicVariantGraph create() {
        return new CyclicVariantGraph();
    }

    public static CyclicVariantGraph create(IWitness iWitness) {
        CyclicVariantGraph cyclicVariantGraph = CyclicVariantGraph.create();
        ArrayList<IVariantGraphVertex> arrayList = Lists.newArrayList();
        for (INormalizedToken object : iWitness.getTokens()) {
            IVariantGraphVertex iVariantGraphVertex = cyclicVariantGraph.addNewVertex(object.getNormalized(), object);
            iVariantGraphVertex.addToken(iWitness, object);
            arrayList.add(iVariantGraphVertex);
        }
        Object object = cyclicVariantGraph.getStartVertex();
        for (IVariantGraphVertex iVariantGraphVertex : arrayList) {
            cyclicVariantGraph.addNewEdge((IVariantGraphVertex)object, iVariantGraphVertex, iWitness);
            object = iVariantGraphVertex;
        }
        cyclicVariantGraph.addNewEdge((IVariantGraphVertex)object, cyclicVariantGraph.getEndVertex(), iWitness);
        return cyclicVariantGraph;
    }

    public IVariantGraphVertex addNewVertex(String string, INormalizedToken iNormalizedToken) {
        VariantGraphVertex variantGraphVertex = new VariantGraphVertex(string, iNormalizedToken);
        this.addVertex(variantGraphVertex);
        return variantGraphVertex;
    }

    public void addNewEdge(IVariantGraphVertex iVariantGraphVertex, IVariantGraphVertex iVariantGraphVertex2, IWitness iWitness) {
        VariantGraphEdge variantGraphEdge = new VariantGraphEdge(iVariantGraphVertex, iVariantGraphVertex2, iWitness);
        this.addEdge(iVariantGraphVertex, iVariantGraphVertex2, variantGraphEdge);
    }

    @Override
    public IVariantGraphVertex getEndVertex() {
        return this.endVertex;
    }

    @Override
    public IVariantGraphVertex getStartVertex() {
        return this.startVertex;
    }

    @Override
    public List<String> getRepeatedTokens() {
        throw new UnsupportedOperationException("NOT IMPLEMENTED!");
    }

    @Override
    public List<IWitness> getWitnesses() {
        throw new UnsupportedOperationException("NOT IMPLEMENTED!");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("NOT IMPLEMENTED!");
    }

    @Override
    public List<IVariantGraphVertex> getPath(IWitness iWitness) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED!");
    }

    @Override
    public List<IVariantGraphVertex> getLongestPath() {
        throw new UnsupportedOperationException("NOT IMPLEMENTED!");
    }

    @Override
    public ITokenIndex getTokenIndex(List<String> list) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED!");
    }

    @Override
    public List<INormalizedToken> getTokens(IWitness iWitness) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED!");
    }

    @Override
    public boolean isNear(IToken iToken, IToken iToken2) {
        throw new UnsupportedOperationException("NOT IMPLEMENTED!");
    }

    @Override
    public Iterator<INormalizedToken> tokenIterator() {
        throw new UnsupportedOperationException("NOT IMPLEMENTED!");
    }

    @Override
    public Iterator<IVariantGraphVertex> iterator() {
        throw new UnsupportedOperationException("NOT IMPLEMENTED!");
    }
}

